/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.dialogs;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IHexEditorService;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.dialogs.ValueViewDialog;
import org.jkiss.dbeaver.ui.data.editors.ReferenceValueEditor;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class TextViewDialog
extends ValueViewDialog {
    private static final Log log = Log.getLog(TextViewDialog.class);
    private static final String VALUE_TYPE_SELECTOR = "string.value.type";
    private StyledText textEdit;
    private Label lengthLabel;
    private IHexEditorService hexEditorService;
    private Control hexEditControl;
    private TabFolder editorContainer;
    private boolean dirty;

    public TextViewDialog(IValueController valueController) {
        super(valueController);
    }

    @Override
    protected Composite createDialogArea(Composite parent) {
        Composite dialogGroup = super.createDialogArea(parent);
        ReferenceValueEditor referenceValueEditor = new ReferenceValueEditor(null, this.getValueController(), this);
        boolean isForeignKey = referenceValueEditor.isReferenceValue();
        Label label = new Label(dialogGroup, 0);
        label.setText(ResultSetMessages.dialog_data_label_value);
        boolean readOnly = this.getValueController().isReadOnly();
        this.hexEditorService = null;
        if (!isForeignKey) {
            this.hexEditorService = (IHexEditorService)DBWorkbench.getService(IHexEditorService.class);
        }
        DBSTypedObject valueType = this.getValueController().getValueType();
        long maxSize = valueType.getMaxLength();
        if (this.hexEditorService != null) {
            this.editorContainer = new TabFolder(dialogGroup, 0x800080);
            this.editorContainer.setLayoutData((Object)new GridData(1808));
            this.lengthLabel = new Label(dialogGroup, 131072);
            this.lengthLabel.setLayoutData((Object)new GridData(768));
        }
        int selectedType = 0;
        if (this.getDialogSettings().get(VALUE_TYPE_SELECTOR) != null) {
            selectedType = this.getDialogSettings().getInt(VALUE_TYPE_SELECTOR);
        }
        int style = 0;
        if (readOnly) {
            style |= 8;
        }
        style = this.hexEditorService != null ? (style |= 0x342) : (style |= 0x800);
        this.textEdit = new StyledText((Composite)(this.hexEditorService != null ? this.editorContainer : dialogGroup), style);
        this.textEdit.setFont(UIUtils.getMonospaceFont());
        this.textEdit.setMargins(3, 3, 3, 3);
        if (maxSize > 0L && valueType.getDataKind() == DBPDataKind.STRING) {
            this.textEdit.setTextLimit((int)maxSize);
        }
        GridData gd = new GridData(isForeignKey ? 768 : 1808);
        gd.widthHint = 300;
        if (!isForeignKey) {
            gd.heightHint = 200;
            gd.grabExcessVerticalSpace = true;
        }
        this.textEdit.setLayoutData((Object)gd);
        this.textEdit.setFocus();
        this.textEdit.setEditable(!readOnly);
        this.textEdit.addModifyListener(e -> {
            this.dirty = true;
            this.updateValueLength();
        });
        StyledTextUtils.fillDefaultStyledTextContextMenu((StyledText)this.textEdit);
        if (this.hexEditorService != null) {
            TabItem item = new TabItem(this.editorContainer, 524288);
            item.setText("Text");
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_TEXT));
            item.setControl((Control)this.textEdit);
        }
        Point minSize = null;
        if (this.hexEditorService != null) {
            this.hexEditControl = this.hexEditorService.createHexControl((Composite)this.editorContainer, readOnly);
            minSize = this.hexEditControl.computeSize(-1, -1);
            minSize.x += 50;
            minSize.y += 50;
            TabItem item = new TabItem(this.editorContainer, 524288);
            item.setText("Hex");
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_BINARY));
            item.setControl(this.hexEditControl);
            if (selectedType >= this.editorContainer.getItemCount()) {
                selectedType = 0;
            }
            this.editorContainer.setSelection(selectedType);
            this.editorContainer.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    TextViewDialog.this.getDialogSettings().put(TextViewDialog.VALUE_TYPE_SELECTOR, TextViewDialog.this.editorContainer.getSelectionIndex());
                }
            });
            this.hexEditControl.addListener(24, event -> {
                boolean bl = this.dirty = true;
            });
            this.updateValueLength();
        }
        this.primeEditorValue(this.getValueController().getValue());
        if (isForeignKey) {
            referenceValueEditor.createEditorSelector(dialogGroup);
        }
        if (minSize != null) {
            this.getShell().setMinimumSize(minSize);
        }
        return dialogGroup;
    }

    private byte[] getBinaryContent() {
        if (this.hexEditorService != null) {
            return this.hexEditorService.getHexContent(this.hexEditControl);
        }
        return null;
    }

    private String getBinaryString() {
        String stringValue;
        byte[] bytes = this.getBinaryContent();
        int length = bytes.length;
        try {
            stringValue = new String(bytes, 0, length, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            stringValue = new String(bytes);
        }
        return stringValue;
    }

    private void setBinaryContent(String stringValue) {
        if (this.hexEditorService != null && stringValue != null) {
            byte[] bytes;
            String charset = this.getDefaultCharset();
            try {
                bytes = stringValue.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                bytes = stringValue.getBytes(Charset.defaultCharset());
            }
            try {
                this.hexEditorService.setHexContent(this.hexEditControl, bytes, charset);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    private String getDefaultCharset() {
        return DBValueFormatting.getDefaultBinaryFileEncoding((DBPDataSource)this.getValueController().getExecutionContext().getDataSource());
    }

    @Override
    public Object extractEditorValue() {
        Object prevValue = this.getValueController().getValue();
        Object rawValue = prevValue instanceof DBDContent ? (ContentUtils.isTextContent((DBDContent)((DBDContent)prevValue)) ? (this.isTextEditorActive() ? this.textEdit.getText() : this.getBinaryString()) : (Object)(this.isTextEditorActive() ? GeneralUtils.convertToBytes((String)this.textEdit.getText()) : this.getBinaryContent())) : (this.isTextEditorActive() ? this.textEdit.getText() : this.getBinaryString());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBCSession session = this.getValueController().getExecutionContext().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Make text value from editor");){
                return this.getValueController().getValueHandler().getValueFromObject(session, this.getValueController().getValueType(), rawValue, false, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Extract editor value", "Can't extract editor value", (Throwable)e);
            return null;
        }
    }

    @Override
    public Control getControl() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return null;
        }
        if (this.isTextEditorActive()) {
            return this.textEdit;
        }
        return this.hexEditControl;
    }

    private boolean isTextEditorActive() {
        return this.editorContainer == null || this.editorContainer.getSelectionIndex() == 0;
    }

    private void updateValueLength() {
        if (this.lengthLabel != null) {
            long maxSize = this.getValueController().getValueType().getMaxLength();
            long length = this.textEdit.getText().length();
            this.lengthLabel.setText("Length: " + length + (String)(maxSize > 0L ? " [" + maxSize + "]" : ""));
        }
    }

    @Override
    public void primeEditorValue(@Nullable Object value) {
        if (value instanceof DBDContentCached) {
            value = ((DBDContentCached)value).getCachedValue();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            this.textEdit.setText(GeneralUtils.convertToString((byte[])bytes, (int)0, (int)bytes.length));
            if (this.hexEditorService != null) {
                this.hexEditorService.setHexContent(this.hexEditControl, bytes, this.getDefaultCharset());
            }
        } else {
            IValueController valueController = this.getValueController();
            String strValue = valueController.getValueHandler().getValueDisplayString(valueController.getValueType(), value, DBDDisplayFormat.EDIT);
            this.textEdit.setText(strValue);
            if (this.hexEditControl != null) {
                this.setBinaryContent(strValue);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.getValueController().getValueType().getDataKind() == DBPDataKind.STRING) {
            Button button = this.createButton(parent, 10, ResultSetMessages.dialog_text_view_open_editor, false);
            button.setToolTipText(ResultSetMessages.dialog_text_view_open_editor_tip);
        }
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            ContentEditor.openEditor(this.getValueController());
            this.cancelPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }
}

