/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.utils.CommonUtils;

class SpreadsheetFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(SpreadsheetFindReplaceTarget.class);
    private static SpreadsheetFindReplaceTarget instance;
    private int ownerIdentity;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;
    private boolean sessionActive = false;
    private List<GridPos> originalSelection = new ArrayList<GridPos>();

    SpreadsheetFindReplaceTarget() {
    }

    public static synchronized SpreadsheetFindReplaceTarget getInstance() {
        if (instance == null) {
            instance = new SpreadsheetFindReplaceTarget();
            SpreadsheetFindReplaceTarget.instance.scopeHighlightColor = UIStyles.getDefaultTextColor((String)"AbstractTextEditor.Color.FindScope", (int)26);
        }
        return instance;
    }

    public synchronized SpreadsheetFindReplaceTarget owned(@NotNull SpreadsheetPresentation newOwner) {
        this.refreshOwner(newOwner);
        return this;
    }

    public boolean isSessionActive() {
        return this.sessionActive;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Color getScopeHighlightColor() {
        return this.scopeHighlightColor;
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return new Point(0, 0);
        }
        Collection<Integer> rowSelection = owner.getSpreadsheet().getRowSelection();
        int minRow = rowSelection.stream().mapToInt(v -> v).min().orElse(-1);
        int maxRow = rowSelection.stream().mapToInt(v -> v).max().orElse(-1);
        return new Point(minRow, maxRow);
    }

    public String getSelectionText() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return "";
        }
        GridPos selection = owner.getSelection().getFirstElement();
        if (selection == null) {
            return "";
        }
        Spreadsheet spreadsheet = owner.getSpreadsheet();
        GridCell cell = spreadsheet.posToCell(selection);
        String value = cell == null ? "" : CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, false));
        return CommonUtils.toString((Object)value);
    }

    public boolean isEditable() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        return owner != null && owner.getController().getReadOnlyStatus() == null;
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void beginSession() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet(false);
        if (owner == null) {
            return;
        }
        this.sessionActive = true;
        owner.getControl().redraw();
        this.originalSelection = new ArrayList<GridPos>(owner.getSpreadsheet().getSelection());
        owner.highlightRows(-1, -1, null);
    }

    public void endSession() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet(false);
        if (owner == null) {
            return;
        }
        this.sessionActive = false;
        this.searchPattern = null;
        Control control = owner.getControl();
        if (control != null && !control.isDisposed()) {
            owner.getSpreadsheet().deselectAll();
            owner.getSpreadsheet().selectCells(this.originalSelection);
        }
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return;
        }
        if (scope == null || scope.getLength() == 0) {
            owner.highlightRows(-1, -1, null);
            if (scope == null) {
                owner.getSpreadsheet().deselectAll();
                owner.getSpreadsheet().selectCells(this.originalSelection);
            }
        } else {
            owner.highlightRows(scope.getOffset(), scope.getLength(), this.scopeHighlightColor);
        }
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return;
        }
        int columnCount = owner.getSpreadsheet().getColumnCount();
        ArrayList<GridPos> selRows = new ArrayList<GridPos>();
        int rowNum = 0;
        while (rowNum < length) {
            int col = 0;
            while (col < columnCount) {
                selRows.add(new GridPos(col, offset + rowNum));
                ++col;
            }
            ++rowNum;
        }
        owner.setSelection((ISelection)new StructuredSelection(selRows));
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        Pattern findPattern;
        GridPos startPosition;
        int lastRow;
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return -1;
        }
        this.searchPattern = null;
        ResultSetModel model = owner.getController().getModel();
        if (model.isEmpty()) {
            return -1;
        }
        Spreadsheet spreadsheet = owner.getSpreadsheet();
        int rowCount = spreadsheet.getItemCount();
        int columnCount = spreadsheet.getColumnCount();
        Collection<GridPos> selection = spreadsheet.getSelection();
        int firstRow = owner.getHighlightScopeFirstLine();
        if (firstRow < 0) {
            firstRow = 0;
        }
        if ((lastRow = owner.getHighlightScopeLastLine()) >= rowCount || lastRow < 0) {
            lastRow = rowCount - 1;
        }
        GridPos gridPos = startPosition = selection.isEmpty() ? null : selection.iterator().next();
        if (startPosition == null) {
            int startRow = searchForward ? firstRow : lastRow;
            startPosition = startRow >= 0 ? new GridPos(0, startRow) : new GridPos(0, 0);
        }
        if (regExSearch) {
            try {
                findPattern = Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                log.warn((Object)("Bad regex pattern: " + findString));
                return -1;
            }
        } else {
            Object pattern = Pattern.quote(findString);
            if (wholeWord) {
                pattern = "\\b" + (String)pattern + "\\b";
            }
            findPattern = Pattern.compile((String)pattern, caseSensitive ? 0 : 2);
        }
        int minColumnNum = owner.getController().isRecordMode() ? -1 : 0;
        GridPos curPosition = new GridPos(startPosition);
        while (true) {
            String cellText;
            if (searchForward) {
                ++curPosition.col;
                if (curPosition.col >= columnCount) {
                    curPosition.col = minColumnNum;
                    ++curPosition.row;
                }
            } else {
                --curPosition.col;
                if (curPosition.col < minColumnNum) {
                    curPosition.col = columnCount - 1;
                    --curPosition.row;
                }
            }
            if (firstRow >= 0 && curPosition.row < firstRow || lastRow >= 0 && curPosition.row > lastRow) {
                if (offset == -1) {
                    offset = 0;
                    curPosition = searchForward ? new GridPos(0, firstRow) : new GridPos(columnCount - 1, lastRow);
                } else {
                    spreadsheet.redraw();
                    return -1;
                }
            }
            if (owner.getController().isRecordMode() && curPosition.col == minColumnNum) {
                cellText = spreadsheet.getLabelProvider().getText(spreadsheet.getRow(curPosition.row));
            } else {
                GridCell cell = spreadsheet.posToCell(curPosition);
                if (cell == null) continue;
                cellText = CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, false));
            }
            Matcher matcher = findPattern.matcher(cellText);
            if (wholeWord ? matcher.matches() : matcher.find()) break;
        }
        if (curPosition.col == minColumnNum) {
            curPosition.col = 0;
        }
        spreadsheet.setFocusColumn(curPosition.col);
        spreadsheet.setFocusItem(curPosition.row);
        spreadsheet.setCellSelection(curPosition);
        if (!owner.getController().isHasMoreData() || !this.replaceAll || curPosition.row >= spreadsheet.getTopIndex() && curPosition.row < spreadsheet.getBottomIndex()) {
            spreadsheet.showSelection();
        }
        this.searchPattern = findPattern;
        return curPosition.row;
    }

    public void replaceSelection(String text, boolean regExReplace) {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return;
        }
        GridPos selection = owner.getSelection().getFirstElement();
        if (selection == null) {
            return;
        }
        GridCell cell = owner.getSpreadsheet().posToCell(selection);
        if (cell == null) {
            return;
        }
        ResultSetCellLocation cellLocation = owner.getCellLocation(cell);
        String oldValue = CommonUtils.toString((Object)owner.getSpreadsheet().getContentProvider().getCellValue(cell.col, cell.row, true));
        String newValue = text;
        if (this.searchPattern != null) {
            newValue = this.searchPattern.matcher(oldValue).replaceAll(newValue);
        }
        Object originalValue = owner.getSpreadsheet().getContentProvider().getCellValue(cell.col, cell.row, false);
        try {
            if (originalValue instanceof DBDContent) {
                ((DBDContent)originalValue).updateContents((DBRProgressMonitor)new VoidProgressMonitor(), (DBDContentStorage)new StringContentStorage(newValue));
                new ResultSetValueController(owner.getController(), cellLocation, IValueController.EditType.NONE, null).updateValue(originalValue, true);
            } else {
                owner.getController().updateCellValue(cellLocation.getAttribute(), cellLocation.getRow(), cellLocation.getRowIndexes(), newValue, true);
            }
        }
        catch (DBException e) {
            log.error((Object)"Error updating contents", (Throwable)e);
        }
        owner.getController().updatePanelsContent(false);
    }

    public String toString() {
        SpreadsheetPresentation owner = this.getActiveSpreadsheet();
        if (owner == null) {
            return super.toString();
        }
        DBSDataContainer dataContainer = owner.getController().getDataContainer();
        return "Target: " + (dataContainer == null ? null : dataContainer.getName());
    }

    private void refreshOwner(@NotNull SpreadsheetPresentation newOwner) {
        if (this.ownerIdentity == newOwner.hashCode()) {
            return;
        }
        boolean refreshSession = this.sessionActive;
        Pattern searchPattern = this.searchPattern;
        if (refreshSession) {
            this.endSession();
        }
        this.ownerIdentity = newOwner.hashCode();
        if (refreshSession) {
            this.beginSession();
            this.searchPattern = searchPattern;
        }
    }

    @Nullable
    private SpreadsheetPresentation getActiveSpreadsheet() {
        return this.getActiveSpreadsheet(true);
    }

    @Nullable
    private SpreadsheetPresentation getActiveSpreadsheet(boolean refreshActiveSpreadsheet) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        SpreadsheetPresentation spreadsheet = (SpreadsheetPresentation)activeEditor.getAdapter(SpreadsheetPresentation.class);
        if (spreadsheet == null) {
            return null;
        }
        if (refreshActiveSpreadsheet) {
            this.refreshOwner(spreadsheet);
        }
        return spreadsheet;
    }
}

