/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.controls.ValueFormatSelector;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerCopySpecial
extends ResultSetHandlerMain
implements IElementUpdater {
    public static final Log log = Log.getLog(ResultSetHandlerCopySpecial.class);
    public static final String CMD_COPY_SPECIAL = "org.jkiss.dbeaver.core.edit.copy.special";
    public static final String CMD_COPY_SPECIAL_LAST = "org.jkiss.dbeaver.core.edit.copy.special.with.last.settings";
    private static ResultSetCopySettings copySettingsLast = null;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResultSetController resultSet = ResultSetHandlerCopySpecial.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.edit.copy.special": {
                this.showAdvancedCopyDialog(resultSet, HandlerUtil.getActiveShell((ExecutionEvent)event));
                break;
            }
            case "org.jkiss.dbeaver.core.edit.copy.special.with.last.settings": {
                if (copySettingsLast == null) {
                    this.showAdvancedCopyDialog(resultSet, HandlerUtil.getActiveShell((ExecutionEvent)event));
                    break;
                }
                ResultSetUtils.copyToClipboard(resultSet.getActivePresentation().copySelection(copySettingsLast));
                break;
            }
            default: {
                log.warn((Object)String.format("Unexpected command id: %s", event.getCommand().getId()));
            }
        }
        return null;
    }

    public void showAdvancedCopyDialog(IResultSetController resultSet, Shell shell) {
        AdvancedCopyConfigDialog configDialog = new AdvancedCopyConfigDialog(shell);
        if (configDialog.open() == 0) {
            copySettingsLast = configDialog.copySettings;
            ResultSetUtils.copyToClipboard(resultSet.getActivePresentation().copySelection(configDialog.copySettings));
        }
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        element.setText(ResultSetMessages.actions_spreadsheet_copy_special);
    }

    private static class AdvancedCopyConfigDialog
    extends CopyConfigDialog {
        static final String PARAM_COPY_HEADER = "copyHeader";
        static final String PARAM_COPY_ROWS = "copyRows";
        static final String PARAM_QUOTE_CELLS = "quoteCells";
        static final String PARAM_FORCE_QUOTES = "forceQuotes";
        static final String PARAM_FORMAT = "format";
        static final String PARAM_COPY_HTML = "copyHTML";
        private Button copyHeaderCheck;
        private Button copyRowsCheck;
        private Button quoteCellsCheck;
        private Button forceQuoteCheck;
        private Button copyHtmlCheck;
        private ValueFormatSelector formatSelector;

        protected AdvancedCopyConfigDialog(Shell shell) {
            super(shell, "AdvanceCopySettings");
            this.copySettings.setQuoteCells(true);
            this.copySettings.setCopyHeader(true);
            this.copySettings.setCopyRowNumbers(false);
            this.copySettings.setFormat(DBDDisplayFormat.UI);
            if (this.settings.get(PARAM_COPY_HEADER) != null) {
                this.copySettings.setCopyHeader(this.settings.getBoolean(PARAM_COPY_HEADER));
            }
            if (this.settings.get(PARAM_COPY_ROWS) != null) {
                this.copySettings.setCopyRowNumbers(this.settings.getBoolean(PARAM_COPY_ROWS));
            }
            if (this.settings.get(PARAM_QUOTE_CELLS) != null) {
                this.copySettings.setQuoteCells(this.settings.getBoolean(PARAM_QUOTE_CELLS));
            }
            if (this.settings.get(PARAM_FORCE_QUOTES) != null) {
                this.copySettings.setForceQuotes(this.settings.getBoolean(PARAM_FORCE_QUOTES));
            }
            if (this.settings.get(PARAM_FORMAT) != null) {
                this.copySettings.setFormat(DBDDisplayFormat.valueOf((String)this.settings.get(PARAM_FORMAT)));
            }
            if (this.settings.get(PARAM_COPY_HTML) != null) {
                this.copySettings.setCopyHTML(this.settings.getBoolean(PARAM_COPY_HTML));
            }
        }

        @Override
        protected void createControlsBefore(Composite group) {
            this.copyHeaderCheck = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.copy_special_copy_header_text, null, (boolean)this.copySettings.isCopyHeader(), (int)2);
            this.copyRowsCheck = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.copy_special_copy_row_numbers_text, null, (boolean)this.copySettings.isCopyRowNumbers(), (int)2);
            this.quoteCellsCheck = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.copy_special_quote_cell_values_text, (String)ResultSetMessages.copy_special_quote_cell_values_tip, (boolean)this.copySettings.isQuoteCells(), (int)2);
            this.forceQuoteCheck = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.copy_special_force_quote_cell_values_text, (String)ResultSetMessages.copy_special_force_quote_cell_values_tip, (boolean)this.copySettings.isForceQuotes(), (int)2);
            this.copyHtmlCheck = UIUtils.createCheckbox((Composite)group, (String)ResultSetMessages.copy_special_copy_as_html_text, (String)ResultSetMessages.copy_special_copy_as_html_tip, (boolean)this.copySettings.isCopyHTML(), (int)2);
            this.formatSelector = new ValueFormatSelector(group);
            this.formatSelector.select(this.copySettings.getFormat());
        }

        @Override
        protected void okPressed() {
            this.copySettings.setCopyHeader(this.copyHeaderCheck.getSelection());
            this.copySettings.setCopyRowNumbers(this.copyRowsCheck.getSelection());
            this.copySettings.setQuoteCells(this.quoteCellsCheck.getSelection());
            this.copySettings.setForceQuotes(this.forceQuoteCheck.getSelection());
            this.copySettings.setCopyHTML(this.copyHtmlCheck.getSelection());
            this.copySettings.setFormat(this.formatSelector.getSelection());
            this.settings.put(PARAM_COPY_HEADER, this.copySettings.isCopyHeader());
            this.settings.put(PARAM_COPY_ROWS, this.copySettings.isCopyRowNumbers());
            this.settings.put(PARAM_QUOTE_CELLS, this.copySettings.isQuoteCells());
            this.settings.put(PARAM_FORCE_QUOTES, this.copySettings.isForceQuotes());
            this.settings.put(PARAM_COPY_HTML, this.copySettings.isCopyHTML());
            this.settings.put(PARAM_FORMAT, this.copySettings.getFormat().name());
            super.okPressed();
        }
    }

    public static class CopyConfigDialog
    extends BaseDialog {
        static final String PARAM_COL_DELIMITER = "delimiter";
        static final String PARAM_ROW_DELIMITER = "rowDelimiter";
        static final String PARAM_QUOTE_STRING = "quoteString";
        protected final IDialogSettings settings;
        private Combo colDelimCombo;
        private Combo rowDelimCombo;
        private Combo quoteStringCombo;
        protected ResultSetCopySettings copySettings;

        protected CopyConfigDialog(Shell shell, String dialogId) {
            super(shell, ResultSetMessages.copy_special_options, null);
            this.settings = UIUtils.getDialogSettings((String)dialogId);
            this.copySettings = new ResultSetCopySettings();
            this.copySettings.setColumnDelimiter("\t");
            this.copySettings.setRowDelimiter("\n");
            this.copySettings.setQuoteString("\"");
            if (this.settings.get(PARAM_COL_DELIMITER) != null) {
                this.copySettings.setColumnDelimiter(this.settings.get(PARAM_COL_DELIMITER));
            }
            if (this.settings.get(PARAM_ROW_DELIMITER) != null) {
                this.copySettings.setRowDelimiter(this.settings.get(PARAM_ROW_DELIMITER));
            }
            if (this.settings.get(PARAM_QUOTE_STRING) != null) {
                this.copySettings.setQuoteString(this.settings.get(PARAM_QUOTE_STRING));
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite group = super.createDialogArea(parent);
            ((GridLayout)group.getLayout()).numColumns = 2;
            this.createControlsBefore(group);
            this.colDelimCombo = UIWidgets.createDelimiterCombo((Composite)group, (String)ResultSetMessages.copy_special_column_delimiter, (String[])new String[]{"\t", ";", ","}, (String)this.copySettings.getColumnDelimiter(), (boolean)false);
            this.rowDelimCombo = UIWidgets.createDelimiterCombo((Composite)group, (String)ResultSetMessages.copy_special_row_delimiter, (String[])new String[]{"\n", "|", "^", ","}, (String)this.copySettings.getRowDelimiter(), (boolean)false);
            this.quoteStringCombo = UIWidgets.createDelimiterCombo((Composite)group, (String)ResultSetMessages.copy_special_quote_character, (String[])new String[]{"\"", "'"}, (String)this.copySettings.getQuoteString(), (boolean)false);
            Composite placeholder = UIUtils.createPlaceholder((Composite)group, (int)2);
            placeholder.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            UIUtils.createLabel((Composite)placeholder, (String)NLS.bind((String)ResultSetMessages.copy_special_hint_for_hotkey, (Object)ActionUtils.findCommandDescription((String)ResultSetHandlerCopySpecial.CMD_COPY_SPECIAL_LAST, (IServiceLocator)PlatformUI.getWorkbench(), (boolean)true)));
            this.createControlsAfter(group);
            return group;
        }

        protected void createControlsAfter(Composite group) {
        }

        protected void createControlsBefore(Composite group) {
        }

        protected void okPressed() {
            this.copySettings.setColumnDelimiter(CommonUtils.unescapeDisplayString((String)this.colDelimCombo.getText()));
            this.copySettings.setRowDelimiter(CommonUtils.unescapeDisplayString((String)this.rowDelimCombo.getText()));
            this.copySettings.setQuoteString(CommonUtils.unescapeDisplayString((String)this.quoteStringCombo.getText()));
            this.settings.put(PARAM_COL_DELIMITER, this.copySettings.getColumnDelimiter());
            this.settings.put(PARAM_ROW_DELIMITER, this.copySettings.getRowDelimiter());
            this.settings.put(PARAM_QUOTE_STRING, this.copySettings.getQuoteString());
            super.okPressed();
        }
    }
}

