/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.hints.DBDAttributeHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDCellHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintContext;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.data.hints.ValueHintRegistry;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class ResultSetHintContext
implements DBDValueHintContext {
    private static final Log log = Log.getLog(ResultSetHintContext.class);
    private final Supplier<DBSDataContainer> dataContainerSupplier;
    private final Map<String, Object> contextAttributes = new HashMap<String, Object>();
    private final Map<DBDValueHintProvider, HintProviderInfo> hintProviders = new IdentityHashMap<DBDValueHintProvider, HintProviderInfo>();

    ResultSetHintContext(Supplier<DBSDataContainer> dataContainerSupplier) {
        this.dataContainerSupplier = dataContainerSupplier;
    }

    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.dataContainerSupplier.get();
    }

    @Nullable
    public Object getHintContextAttribute(@NotNull String name) {
        return this.contextAttributes.get(name);
    }

    public void setHintContextAttribute(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.contextAttributes.remove(name);
        } else {
            this.contextAttributes.put(name, value);
        }
    }

    public List<DBDCellHintProvider> getCellHintProviders(DBDAttributeBinding attr) {
        ArrayList<DBDCellHintProvider> result = new ArrayList<DBDCellHintProvider>();
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDCellHintProvider)) continue;
            DBDCellHintProvider chp = (DBDCellHintProvider)pi.provider;
            if (!pi.attributes.contains(attr)) continue;
            result.add(chp);
        }
        return result;
    }

    public List<DBDAttributeHintProvider> getColumnHintProviders(DBDAttributeBinding attr) {
        ArrayList<DBDAttributeHintProvider> result = new ArrayList<DBDAttributeHintProvider>();
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDAttributeHintProvider)) continue;
            DBDAttributeHintProvider ahp = (DBDAttributeHintProvider)pi.provider;
            if (!pi.attributes.contains(attr)) continue;
            result.add(ahp);
        }
        return result;
    }

    void resetCache() {
        this.contextAttributes.clear();
        this.hintProviders.clear();
    }

    void initProviders(DBDAttributeBinding[] attributes) {
        try {
            DBSDataContainer dataContainer = this.getDataContainer();
            DBPDataSource ds = dataContainer == null ? null : dataContainer.getDataSource();
            DBDAttributeBinding[] dBDAttributeBindingArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                List attrHintProviders = ValueHintRegistry.getInstance().getAllValueBindings(ds, (DBSTypedObject)attr, null);
                for (DBDValueHintProvider provider : attrHintProviders) {
                    HintProviderInfo providerInfo = this.hintProviders.computeIfAbsent(provider, dBDValueHintProvider -> new HintProviderInfo((DBDValueHintProvider)dBDValueHintProvider));
                    providerInfo.enabled = true;
                    providerInfo.attributes.add(attr);
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error loading hint providers", e);
        }
    }

    public void cacheRequiredData(@NotNull DBRProgressMonitor monitor, @Nullable List<DBDAttributeBinding> attributes, @NotNull List<ResultSetRow> rows, boolean cleanupCache) throws DBException {
        for (HintProviderInfo pi : this.hintProviders.values()) {
            if (!pi.enabled || !(pi.provider instanceof DBDCellHintProvider)) continue;
            DBDCellHintProvider chp = (DBDCellHintProvider)pi.provider;
            chp.cacheRequiredData(monitor, (DBDValueHintContext)this, !CommonUtils.isEmpty(attributes) ? attributes : pi.attributes, rows, cleanupCache);
        }
    }

    private static class HintProviderInfo {
        final DBDValueHintProvider provider;
        boolean enabled;
        final Set<DBDAttributeBinding> attributes = new LinkedHashSet<DBDAttributeBinding>();

        private HintProviderInfo(DBDValueHintProvider provider) {
            this.provider = provider;
        }
    }
}

