/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDNote;
import org.jkiss.dbeaver.erd.ui.ERDIcon;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditPartFactory;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.editor.tools.HandToolEntry;
import org.jkiss.dbeaver.erd.ui.editor.tools.SelectionToolEntry;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIMessages;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouterDescriptor;
import org.jkiss.dbeaver.erd.ui.router.ERDConnectionRouterRegistry;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;

public class ERDDecoratorDefault
implements ERDDecorator {
    public static final ImageDescriptor CONNECT_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_ASSOCIATION);
    public static final ImageDescriptor FOREIGN_KEY_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_FOREIGN_KEY);
    public static final ImageDescriptor NOTE_IMAGE = DBeaverIcons.getImageDescriptor((DBPImage)ERDIcon.NOTE);
    private DBPPreferenceStore store = ERDUIActivator.getDefault().getPreferences();
    private ERDConnectionRouterRegistry connectionRouterRegistry = ERDConnectionRouterRegistry.getInstance();
    private static final Log log = Log.getLog(ERDDecoratorDefault.class);

    @Override
    public boolean showCheckboxes() {
        return false;
    }

    @Override
    public boolean supportsAttributeStyle(@NotNull ERDViewStyle style) {
        return true;
    }

    @Override
    public boolean supportsAttributeVisibility() {
        return true;
    }

    @Override
    public boolean supportsStructureEdit() {
        return true;
    }

    @Override
    @NotNull
    public Insets getDefaultEntityInsets() {
        if (this.getConnectionRouterDescriptor().supportedAttributeAssociation()) {
            return new Insets(50, 50, 50, 50);
        }
        return new Insets(40, 40, 30, 30);
    }

    @Override
    @Nullable
    public Dimension getEntitySnapSize() {
        if (this.store.getBoolean("erd.grid.enabled")) {
            return new Dimension(this.store.getInt("erd.grid.width"), this.store.getInt("erd.grid.height"));
        }
        return null;
    }

    @Override
    @NotNull
    public EditPartFactory createPartFactory() {
        return new ERDEditPartFactory();
    }

    @Override
    public void fillPalette(@NotNull PaletteRoot paletteRoot, boolean readOnly) {
        PaletteDrawer controls = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        controls.add((PaletteEntry)selectionTool);
        HandToolEntry moveTool = new HandToolEntry();
        controls.add((PaletteEntry)moveTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
        if (!readOnly) {
            PaletteSeparator separator = new PaletteSeparator("tools");
            separator.setUserModificationPermission(1);
            controls.add((PaletteEntry)separator);
            controls.add((PaletteEntry)new ConnectionCreationToolEntry(ERDUIMessages.erd_tool_create_connection, ERDUIMessages.erd_tool_create_connection_tip, null, CONNECT_IMAGE, CONNECT_IMAGE));
            controls.add((PaletteEntry)new CreationToolEntry(ERDUIMessages.erd_tool_create_note, ERDUIMessages.erd_tool_create_note_tip, new CreationFactory(){

                public Object getNewObject() {
                    return new ERDNote(ERDUIMessages.erd_tool_create_default);
                }

                public Object getObjectType() {
                    return "create child";
                }
            }, NOTE_IMAGE, NOTE_IMAGE));
        }
    }

    protected PaletteDrawer createToolsDrawer(PaletteRoot paletteRoot) {
        PaletteDrawer controls = new PaletteDrawer("Tools", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        paletteRoot.add((PaletteEntry)controls);
        return controls;
    }

    protected ERDConnectionRouterDescriptor getConnectionRouterDescriptor() {
        return this.connectionRouterRegistry.getActiveRouter();
    }
}

