/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.DatabaseLazyEditorInput;
import org.jkiss.utils.CommonUtils;

public class DatabaseEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = DatabaseEditorInputFactory.class.getName();
    static final String TAG_CLASS = "class";
    static final String TAG_PROJECT = "project";
    static final String TAG_DATA_SOURCE = "data-source";
    static final String TAG_NODE = "node";
    static final String TAG_NODE_NAME = "node-name";
    static final String TAG_ACTIVE_PAGE = "page";
    static final String TAG_ACTIVE_FOLDER = "folder";
    private static volatile boolean lookupEditor;

    public static void setLookupEditor(boolean lookupEditor) {
        DatabaseEditorInputFactory.lookupEditor = lookupEditor;
    }

    public IAdaptable createElement(IMemento memento) {
        return new DatabaseLazyEditorInput(memento);
    }

    public static void saveState(IMemento memento, DatabaseEditorInput input) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ui.editors.reopen-after-restart")) {
            return;
        }
        DBCExecutionContext context = input.getExecutionContext();
        if (context == null) {
            return;
        }
        if (input.getDatabaseObject() != null && !input.getDatabaseObject().isPersisted()) {
            return;
        }
        Object node = input.getNavigatorNode();
        memento.putString(TAG_CLASS, input.getClass().getName());
        memento.putString(TAG_PROJECT, context.getDataSource().getContainer().getProject().getName());
        memento.putString(TAG_DATA_SOURCE, context.getDataSource().getContainer().getId());
        memento.putString(TAG_NODE, node.getNodeUri());
        memento.putString(TAG_NODE_NAME, node.getNodeDisplayName());
        if (!CommonUtils.isEmpty((String)input.getDefaultPageId())) {
            memento.putString(TAG_ACTIVE_PAGE, input.getDefaultPageId());
        }
        if (!CommonUtils.isEmpty((String)input.getDefaultFolderId())) {
            memento.putString(TAG_ACTIVE_FOLDER, input.getDefaultFolderId());
        }
    }
}

