/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class MySQLUtils {
    private static final Log log = Log.getLog(MySQLUtils.class);
    private static final String COLUMN_POSTFIX_PRIV = "_priv";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();

    static {
        typeMap.put("bit", -7);
        typeMap.put("bool", 16);
        typeMap.put("boolean", 16);
        typeMap.put("tinyint", -6);
        typeMap.put("smallint", 5);
        typeMap.put("mediumint", 4);
        typeMap.put("int", 4);
        typeMap.put("integer", 4);
        typeMap.put("int24", 4);
        typeMap.put("bigint", -5);
        typeMap.put("real", 8);
        typeMap.put("float", 7);
        typeMap.put("decimal", 3);
        typeMap.put("dec", 3);
        typeMap.put("numeric", 3);
        typeMap.put("double", 8);
        typeMap.put("double precision", 8);
        typeMap.put("char", 1);
        typeMap.put("varchar", 12);
        typeMap.put("date", 91);
        typeMap.put("time", 92);
        typeMap.put("year", 91);
        typeMap.put("timestamp", 93);
        typeMap.put("datetime", 93);
        typeMap.put("tinyblob", -2);
        typeMap.put("blob", -4);
        typeMap.put("mediumblob", -4);
        typeMap.put("longblob", -4);
        typeMap.put("tinytext", 12);
        typeMap.put("text", 12);
        typeMap.put("mediumtext", 12);
        typeMap.put("longtext", 12);
        typeMap.put("enum", 1);
        typeMap.put("set", 1);
        typeMap.put("geometry", -2);
        typeMap.put("binary", -2);
        typeMap.put("varbinary", -3);
        typeMap.put("uuid", 1);
    }

    public static int typeNameToValueType(String typeName) {
        Integer valueType = typeMap.get(typeName.toLowerCase(Locale.ENGLISH));
        return valueType == null ? 1111 : valueType;
    }

    public static List<String> collectPrivilegeNames(ResultSet resultSet) {
        try {
            ArrayList<String> privs = new ArrayList<String>();
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            int colCount = rsMetaData.getColumnCount();
            int i = 0;
            while (i < colCount) {
                String colName = rsMetaData.getColumnName(i + 1);
                if (colName.toLowerCase(Locale.ENGLISH).endsWith(COLUMN_POSTFIX_PRIV)) {
                    privs.add(colName.substring(0, colName.length() - COLUMN_POSTFIX_PRIV.length()));
                }
                ++i;
            }
            return privs;
        }
        catch (SQLException e) {
            log.debug((Object)e);
            return Collections.emptyList();
        }
    }

    public static Map<String, Boolean> collectPrivileges(List<String> privNames, ResultSet resultSet) {
        TreeMap<String, Boolean> privs = new TreeMap<String, Boolean>();
        for (String privName : privNames) {
            privs.put(privName, "Y".equals(JDBCUtils.safeGetString((ResultSet)resultSet, (String)(privName + COLUMN_POSTFIX_PRIV))));
        }
        return privs;
    }

    public static String getMySQLConsoleBinaryName() {
        return RuntimeUtils.getNativeBinaryName((String)"mysql");
    }

    /*
     * Exception decompiling
     */
    public static String determineCurrentDatabase(JDBCSession session) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isMariaDB(DBPDriver driver) {
        return "org.mariadb.jdbc.Driver".equals(driver.getDriverClassName());
    }

    public static boolean isAlterUSerSupported(MySQLDataSource dataSource) {
        return dataSource.isMariaDB() ? dataSource.isServerVersionAtLeast(10, 2) : dataSource.isServerVersionAtLeast(5, 7);
    }

    public static boolean isColumnSridSupported(@NotNull MySQLDataSource dataSource) {
        return !dataSource.isMariaDB() && dataSource.isServerVersionAtLeast(8, 0);
    }

    public static boolean isSpatialDataType(@NotNull String name) {
        switch (name.toLowerCase(Locale.ROOT)) {
            case "geometrycollection": 
            case "multilinestring": 
            case "polygon": 
            case "point": 
            case "multipolygon": 
            case "linestring": 
            case "multipoint": 
            case "geometry": {
                return true;
            }
        }
        return false;
    }
}

