/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.model.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.gbase8s.GBase8sUtils;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sCatalog;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sDataTypeCache;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sProcedure;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sSchema;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sSynonym;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTable;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTableColumn;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class GBase8sMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(GBase8sMetaModel.class);
    private static final String[] VALID_TABLE_TYPES = new String[]{"TABLE", "VIEW", "SYSTEM TABLE"};

    public GenericCatalog createCatalogImpl(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        return new GBase8sCatalog(dataSource, catalogName);
    }

    public JDBCBasicDataTypeCache<GenericStructContainer, ? extends JDBCDataType> createDataTypeCache(@NotNull GenericStructContainer container) {
        return new GBase8sDataTypeCache(container);
    }

    public GenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new GBase8sProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new GBase8sSchema(dataSource, catalog, schemaName);
    }

    public GenericSynonym createSynonymImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME");
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        return new GBase8sSynonym(container, name, description, dbResult);
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        return new GBase8sTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new GenericView(container, tableName, tableType, dbResult);
        }
        return new GBase8sTable(container, tableName, tableType, dbResult);
    }

    public GenericTableTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull GenericTableBase genericTableBase, String triggerName, @NotNull JDBCResultSet resultSet) {
        if (CommonUtils.isEmpty((String)triggerName)) {
            triggerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TRIGGER_NAME");
        }
        if (triggerName == null) {
            return null;
        }
        triggerName = triggerName.trim();
        return new GBase8sTableTrigger(genericTableBase, triggerName, resultSet);
    }

    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        return GBase8sUtils.getProcedureSource(monitor, sourceObject);
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String tableDDL = super.getTableDDL(monitor, sourceObject, options);
        return tableDDL + GBase8sUtils.getTriggerDDL(monitor, sourceObject);
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        return GBase8sUtils.getTriggerDDL(monitor, trigger);
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return GBase8sUtils.getViewDDL(monitor, (GenericTableBase)sourceObject);
    }

    public void loadProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        block29: {
            LinkedHashMap funcMap = new LinkedHashMap();
            JDBCPreparedStatement dbState = null;
            JDBCResultSet dbResult = null;
            GenericDataSource dataSource = container.getDataSource();
            GenericMetaObject procObject = dataSource.getMetaObject("procedure");
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                    if (!this.hasProcedureSupport()) break block29;
                    String query = "SELECT procid, procname, isproc, specificname, type, procflags, paramtypes::LVARCHAR AS columntypenames, mode FROM sysprocedures ";
                    dbState = session.prepareStatement(query);
                    dbResult = dbState.executeQuery();
                    while (dbResult.next()) {
                        GenericProcedure function;
                        DBSProcedureType procedureType;
                        if (monitor.isCanceled()) {
                            break;
                        }
                        String procedureName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"procname");
                        String specificName = GenericUtils.safeGetStringTrimmed((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"specificname");
                        String isProc = GenericUtils.safeGetString((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"isproc");
                        String procType = GenericUtils.safeGetString((GenericMetaObject)procObject, (ResultSet)dbResult, (String)"type");
                        if (!"0".equalsIgnoreCase(procType) || container.hasProcedure(procedureName)) continue;
                        switch (isProc) {
                            case "t": {
                                DBSProcedureType dBSProcedureType = DBSProcedureType.PROCEDURE;
                                break;
                            }
                            case "f": {
                                DBSProcedureType dBSProcedureType;
                                if (this.hasFunctionSupport()) {
                                    dBSProcedureType = DBSProcedureType.FUNCTION;
                                    break;
                                }
                                dBSProcedureType = DBSProcedureType.UNKNOWN;
                                break;
                            }
                            case "u": {
                                DBSProcedureType dBSProcedureType = DBSProcedureType.PROCEDURE;
                                break;
                            }
                            default: {
                                DBSProcedureType dBSProcedureType = procedureType = DBSProcedureType.UNKNOWN;
                            }
                        }
                        if (CommonUtils.isEmpty((String)specificName)) {
                            specificName = procedureName;
                        }
                        if ((function = (GenericProcedure)funcMap.get(procedureName)) != null && !this.supportsEqualFunctionsAndProceduresNames()) {
                            log.debug((Object)("Broken driver [" + session.getDataSource().getContainer().getDriver().getName() + "] - returns the same list for getProcedures and getFunctons"));
                            break;
                        }
                        GenericProcedure procedure = this.createProcedureImpl((GenericStructContainer)container, procedureName, specificName, null, procedureType, (GenericFunctionResultType)(DBSProcedureType.FUNCTION.equals((Object)procedureType) ? GenericFunctionResultType.TABLE : null));
                        container.addProcedure(procedure);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
            }
        }
    }

    /*
     * Loose catch block
     */
    public List<GBase8sTableTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws DBException {
        assert (table != null);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read triggers");){
                ArrayList<GBase8sTableTrigger> arrayList;
                JDBCPreparedStatement dbStat;
                Throwable throwable2;
                block33: {
                    String query = "SELECT T1.trigname FROM systriggers AS T1, systables AS T2 WHERE T2.tabid = T1.tabid AND T2.tabname = ?";
                    throwable2 = null;
                    Object var9_13 = null;
                    dbStat = session.prepareStatement(query);
                    dbStat.setString(1, table.getName());
                    ArrayList<GBase8sTableTrigger> result = new ArrayList<GBase8sTableTrigger>();
                    Throwable throwable3 = null;
                    Object var13_19 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                            if (name == null) continue;
                            result.add(new GBase8sTableTrigger(table, name.trim(), dbResult));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    arrayList = result;
                    if (dbStat == null) break block33;
                    dbStat.close();
                }
                return arrayList;
                {
                    catch (Throwable throwable5) {
                        try {
                            if (dbStat != null) {
                                dbStat.close();
                            }
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                            } else if (throwable2 != throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)container.getDataSource());
        }
    }

    public JDBCStatement prepareSynonymsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        return this.prepareTSObjectLoadStatement(session, container, null, "%", new String[]{"SYNONYM"});
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        return this.prepareTSObjectLoadStatement(session, owner, object, objectName, VALID_TABLE_TYPES);
    }

    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        String query = "SELECT T1.trigname as TRIGGER_NAME, T1.*, T2.tabname AS OWNER FROM systriggers AS T1, systables AS T2 WHERE T2.tabid = T1.tabid " + (table != null ? "AND T2.tabname = ?" : "");
        JDBCPreparedStatement dbStat = session.prepareStatement(query);
        if (table != null) {
            dbStat.setString(1, table.getName());
        }
        return dbStat;
    }

    JDBCStatement prepareTSObjectLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName, @Nullable String[] types) throws SQLException {
        String tableNamePattern;
        if (object == null && objectName == null) {
            DBSObjectFilter tableFilters = session.getDataSource().getContainer().getObjectFilter(GenericTable.class, (DBSObject)owner, false);
            if (tableFilters != null && tableFilters.hasSingleMask()) {
                tableNamePattern = tableFilters.getSingleMask();
                if (!CommonUtils.isEmpty((String)tableNamePattern)) {
                    tableNamePattern = SQLUtils.makeSQLLike((String)tableNamePattern);
                }
            } else {
                tableNamePattern = owner.getDataSource().getAllObjectsPattern();
            }
        } else {
            tableNamePattern = JDBCUtils.escapeWildCards((JDBCSession)session, (String)(object != null ? object.getName() : objectName));
        }
        String catalog = owner.getCatalog() == null ? null : owner.getCatalog().getName();
        String schemaPattern = owner.getSchema() == null || DBUtils.isVirtualObject((Object)owner.getSchema()) ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)owner.getSchema().getName());
        boolean isOracleMode = GBase8sUtils.isOracleSqlMode(owner.getDataSource().getContainer());
        return session.getMetaData().getTables(isOracleMode ? catalog : schemaPattern, isOracleMode ? schemaPattern : catalog, tableNamePattern, types).getSourceStatement();
    }

    public boolean supportNestedForeignKeys() {
        return false;
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return false;
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public boolean hasFunctionSupport() {
        return true;
    }

    public boolean isTrimObjectNames() {
        return true;
    }
}

