/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPSystemInfoObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreExtension
implements PostgreObject,
PostgreScriptObject,
DBPSystemInfoObject {
    private static final Log log = Log.getLog(PostgreExtension.class);
    private PostgreDatabase database;
    private long oid;
    private String name;
    private String owner;
    private String tables;
    private String conditions;
    private boolean relocatable;
    private String version;
    private Map<Long, String> tableConditions;

    public PostgreExtension(PostgreDatabase database) {
        this.database = database;
        this.owner = "public";
    }

    public PostgreExtension(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        this.database = database;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extname");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extversion");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"schema_name");
        this.tables = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"tbls");
        this.relocatable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"extrelocatable");
        this.conditions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"extcondition");
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, order=5)
    public String getTables() {
        return this.tables;
    }

    @Property(viewable=true, order=6)
    public String getConditions() {
        return this.conditions;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4, listProvider=SchemaListProvider.class)
    @NotNull
    public String getSchema() {
        return this.owner;
    }

    public void setSchema(String schema) {
        this.owner = schema;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public boolean getRelocatable() {
        return this.relocatable;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=2)
    public String getVersion() {
        return this.version;
    }

    public boolean isExtensionTable(PostgreTableBase table) {
        return this.tableConditions != null && this.tableConditions.containsKey(table.getObjectId());
    }

    public String getExternalTableCondition(long tableOid) {
        return this.tableConditions == null ? null : this.tableConditions.get(tableOid);
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        String lineBreak = System.getProperty("line.separator");
        return "-- Extension: " + this.getName() + lineBreak + lineBreak + "-- DROP EXTENSION " + this.getName() + ";" + lineBreak + lineBreak + "CREATE EXTENSION " + this.getName() + lineBreak + "\tSCHEMA \"" + this.getSchema() + "\"" + lineBreak + "\tVERSION " + this.version;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    public static class SchemaListProvider
    implements IPropertyValueListProvider<PostgreExtension> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(PostgreExtension object) {
            try {
                Collection<PostgreSchema> schemas = object.getDatabase().getSchemas((DBRProgressMonitor)new VoidProgressMonitor());
                return schemas.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }
}

