/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionPermissionsDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class PrefPageConnectionTypes
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.connectionTypes";
    private static final String HELP_CONNECTION_TYPES_LINK = "Connection-Types";
    private Table typeTable;
    private Text typeId;
    private Text typeName;
    private Text typeDescription;
    private ColorSelector colorPicker;
    private Button autocommitCheck;
    private Button confirmCheck;
    private Button confirmDataChangeCheck;
    private Button autoCloseTransactionsCheck;
    private Text autoCloseTransactionsTtlText;
    private Button autoCloseConnectionsCheck;
    private Text autoCloseConnectionsTtlText;
    private Button smartCommitCheck;
    private Button smartCommitRecoverCheck;
    private ToolItem deleteButton;
    private DBPConnectionType selectedType;
    private final Map<DBPConnectionType, DBPConnectionType> changedInfo = new HashMap<DBPConnectionType, DBPConnectionType>();

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.typeTable = new Table(composite, 2052);
        this.typeTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.typeTable, (int)16384, (String)CoreMessages.pref_page_connection_types_label_table_column_name);
        UIUtils.createTableColumn((Table)this.typeTable, (int)16384, (String)CoreMessages.pref_page_connection_types_label_table_column_description);
        this.typeTable.setHeaderVisible(true);
        this.typeTable.setLayoutData((Object)new GridData(1808));
        this.typeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.showSelectedType(PrefPageConnectionTypes.this.getSelectedType());
            }
        });
        ToolBar toolbar = new ToolBar(composite, 0x800100);
        ToolItem newButton = new ToolItem(toolbar, 0);
        newButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        this.deleteButton = new ToolItem(toolbar, 0);
        this.deleteButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                int i = 1;
                while (true) {
                    name = "Type" + i;
                    boolean hasName = false;
                    for (DBPConnectionType type : PrefPageConnectionTypes.this.changedInfo.keySet()) {
                        if (!type.getName().equals(name)) continue;
                        hasName = true;
                        break;
                    }
                    if (!hasName) break;
                    ++i;
                }
                DBPConnectionType newType = new DBPConnectionType(DBPConnectionType.DEFAULT_TYPE);
                newType.setId(name.toLowerCase());
                newType.setName("New type");
                newType.setColor("255,255,255");
                PrefPageConnectionTypes.this.addTypeToTable(newType, newType);
                PrefPageConnectionTypes.this.typeTable.select(PrefPageConnectionTypes.this.typeTable.getItemCount() - 1);
                PrefPageConnectionTypes.this.typeTable.showSelection();
                PrefPageConnectionTypes.this.showSelectedType(newType);
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType connectionType = PrefPageConnectionTypes.this.getSelectedType();
                if (!UIUtils.confirmAction((Shell)PrefPageConnectionTypes.this.getShell(), (String)CoreMessages.pref_page_connection_types_label_delete_connection_type, (String)NLS.bind((String)CoreMessages.pref_page_connection_types_label_delete_connection_type_description, (Object)connectionType.getName(), (Object)DBPConnectionType.DEFAULT_TYPE.getName()))) {
                    return;
                }
                PrefPageConnectionTypes.this.changedInfo.remove(connectionType);
                int index = PrefPageConnectionTypes.this.typeTable.getSelectionIndex();
                PrefPageConnectionTypes.this.typeTable.remove(index);
                if (index > 0) {
                    --index;
                }
                PrefPageConnectionTypes.this.typeTable.select(index);
                PrefPageConnectionTypes.this.showSelectedType(PrefPageConnectionTypes.this.getSelectedType());
            }
        });
        Group groupSettings = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_connection_types_group_parameters, (int)2, (int)2, (int)300);
        groupSettings.setLayoutData((Object)new GridData(1808));
        this.typeId = UIUtils.createLabelText((Composite)groupSettings, (String)CoreMessages.pref_page_connection_types_label_id, null);
        this.typeId.addModifyListener(e -> {
            this.getSelectedType().setId(this.typeId.getText());
            this.updateTableInfo();
        });
        this.typeName = UIUtils.createLabelText((Composite)groupSettings, (String)CoreMessages.pref_page_connection_types_label_name, null);
        this.typeName.addModifyListener(e -> {
            this.getSelectedType().setName(this.typeName.getText());
            this.updateTableInfo();
        });
        this.typeDescription = UIUtils.createLabelText((Composite)groupSettings, (String)CoreMessages.pref_page_connection_types_label_description, null);
        this.typeDescription.addModifyListener(e -> {
            this.getSelectedType().setDescription(this.typeDescription.getText());
            this.updateTableInfo();
        });
        UIUtils.createControlLabel((Composite)groupSettings, (String)CoreMessages.pref_page_connection_types_label_color);
        this.colorPicker = new ColorSelector((Composite)groupSettings);
        this.colorPicker.addListener(event -> {
            this.getSelectedType().setColor(StringConverter.asString((RGB)this.colorPicker.getColorValue()));
            this.updateTableInfo();
        });
        Group placeholder = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_connection_types_group_settings, (int)2, (int)2, (int)300);
        placeholder.setLayoutData((Object)new GridData(1808));
        this.confirmCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.pref_page_connection_types_label_confirm_sql_execution, (String)CoreMessages.pref_page_connection_types_label_confirm_sql_execution_tip, (boolean)false, (int)2);
        this.confirmCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setConfirmExecute(PrefPageConnectionTypes.this.confirmCheck.getSelection());
            }
        });
        this.confirmDataChangeCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.pref_page_connection_types_label_confirm_data_change, (String)CoreMessages.pref_page_connection_types_label_confirm_data_change_tip, (boolean)false, (int)2);
        this.confirmDataChangeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setConfirmDataChange(PrefPageConnectionTypes.this.confirmDataChangeCheck.getSelection());
            }
        });
        this.autocommitCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.pref_page_connection_types_label_auto_commit_by_default, (String)CoreMessages.pref_page_connection_types_label_auto_commit_by_default_tip, (boolean)false, (int)2);
        this.autocommitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setAutocommit(PrefPageConnectionTypes.this.autocommitCheck.getSelection());
            }
        });
        this.smartCommitCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.action_menu_transaction_smart_auto_commit, (String)CoreMessages.action_menu_transaction_smart_auto_commit_tip, (boolean)false, (int)2);
        this.smartCommitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setSmartCommit(PrefPageConnectionTypes.this.smartCommitCheck.getSelection());
                PrefPageConnectionTypes.this.updateCommitRecoverCheckBox();
            }
        });
        this.smartCommitRecoverCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover, (String)CoreMessages.action_menu_transaction_smart_auto_commit_recover_tip, (boolean)false, (int)2);
        this.smartCommitRecoverCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setSmartCommitRecover(PrefPageConnectionTypes.this.smartCommitRecoverCheck.getSelection());
            }
        });
        this.autoCloseTransactionsCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.action_menu_transaction_auto_close_enabled, (String)CoreMessages.pref_page_connection_types_label_auto_close_enabled_tip, (boolean)true, (int)1);
        this.autoCloseTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setAutoCloseTransactions(PrefPageConnectionTypes.this.autoCloseTransactionsCheck.getSelection());
            }
        });
        this.autoCloseTransactionsTtlText = new Text((Composite)placeholder, 2048);
        this.autoCloseTransactionsTtlText.setToolTipText(CoreMessages.pref_page_connection_types_label_auto_close_ttl_tip);
        this.autoCloseTransactionsTtlText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        GridData grd = new GridData();
        grd.widthHint = UIUtils.getFontHeight((Control)this.autoCloseTransactionsTtlText) * 6;
        this.autoCloseTransactionsTtlText.setLayoutData((Object)grd);
        this.autoCloseTransactionsTtlText.addModifyListener(e -> this.getSelectedType().setCloseIdleTransactionPeriod(CommonUtils.toInt((Object)this.autoCloseTransactionsTtlText.getText(), (int)DBPConnectionType.DEFAULT_TYPE.getCloseIdleTransactionPeriod())));
        this.autoCloseConnectionsCheck = UIUtils.createCheckbox((Composite)placeholder, (String)CoreMessages.dialog_connection_wizard_final_label_close_idle_connections, (String)CoreMessages.dialog_connection_wizard_final_label_close_idle_connections_tooltip, (boolean)true, (int)1);
        this.autoCloseConnectionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setAutoCloseConnections(PrefPageConnectionTypes.this.autoCloseConnectionsCheck.getSelection());
            }
        });
        this.autoCloseConnectionsTtlText = new Text((Composite)placeholder, 2048);
        this.autoCloseConnectionsTtlText.setToolTipText(CoreMessages.pref_page_connection_types_label_auto_close_ttl_tip);
        this.autoCloseConnectionsTtlText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        GridData grdConnections = new GridData();
        grdConnections.widthHint = UIUtils.getFontHeight((Control)this.autoCloseTransactionsTtlText) * 6;
        this.autoCloseConnectionsTtlText.setLayoutData((Object)grdConnections);
        this.autoCloseConnectionsTtlText.addModifyListener(e -> this.getSelectedType().setCloseIdleConnectionPeriod(CommonUtils.toInt((Object)this.autoCloseConnectionsTtlText.getText(), (int)DBPConnectionType.DEFAULT_TYPE.getCloseIdleConnectionPeriod())));
        Button epButton = UIUtils.createDialogButton((Composite)placeholder, (String)CoreMessages.pref_page_label_edit_permissions, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditConnectionPermissionsDialog dialog = new EditConnectionPermissionsDialog(PrefPageConnectionTypes.this.getShell(), PrefPageConnectionTypes.this.getSelectedType().getModifyPermission());
                if (dialog.open() == 0) {
                    PrefPageConnectionTypes.this.getSelectedType().setModifyPermissions(dialog.getAccessRestrictions());
                }
            }
        });
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        epButton.setLayoutData((Object)gd);
        Link urlHelpLabel = UIUtils.createLink((Composite)composite, (String)("<a>" + CoreMessages.pref_page_connection_types_wiki_link + "</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)PrefPageConnectionTypes.HELP_CONNECTION_TYPES_LINK));
            }
        });
        GridData gridData = new GridData(4, 0x1000008, true, true);
        urlHelpLabel.setLayoutData((Object)gridData);
        this.performDefaults(false);
        this.updateCommitRecoverCheckBox();
        return composite;
    }

    private void updateCommitRecoverCheckBox() {
        if (!this.smartCommitCheck.getSelection()) {
            this.smartCommitRecoverCheck.setEnabled(false);
        } else if (!this.smartCommitRecoverCheck.isEnabled()) {
            this.smartCommitRecoverCheck.setEnabled(true);
        }
    }

    private DBPConnectionType getSelectedType() {
        return (DBPConnectionType)this.typeTable.getItem(this.typeTable.getSelectionIndex()).getData();
    }

    private void showSelectedType(DBPConnectionType connectionType) {
        Color connectionTypeColor = UIUtils.getConnectionTypeColor((DBPConnectionType)connectionType);
        if (connectionTypeColor != null) {
            this.colorPicker.setColorValue(connectionTypeColor.getRGB());
        } else {
            this.colorPicker.setColorValue(this.colorPicker.getButton().getBackground().getRGB());
        }
        this.typeId.setText(connectionType.getId());
        this.typeId.setEnabled(this.changedInfo.get(connectionType) == connectionType);
        this.typeName.setText(connectionType.getName());
        this.typeDescription.setText(connectionType.getDescription());
        this.autocommitCheck.setSelection(connectionType.isAutocommit());
        this.confirmCheck.setSelection(connectionType.isConfirmExecute());
        this.confirmDataChangeCheck.setSelection(connectionType.isConfirmDataChange());
        this.smartCommitCheck.setSelection(connectionType.isSmartCommit());
        this.smartCommitRecoverCheck.setSelection(connectionType.isSmartCommitRecover());
        this.autoCloseTransactionsCheck.setSelection(connectionType.isAutoCloseTransactions());
        this.autoCloseTransactionsTtlText.setText(String.valueOf(connectionType.getCloseIdleTransactionPeriod()));
        this.autoCloseConnectionsCheck.setSelection(connectionType.isAutoCloseConnections());
        this.autoCloseConnectionsTtlText.setText(String.valueOf(connectionType.getCloseIdleConnectionPeriod()));
        this.deleteButton.setEnabled(!connectionType.isPredefined());
    }

    private void updateTableInfo() {
        DBPConnectionType connectionType = this.getSelectedType();
        TableItem[] tableItemArray = this.typeTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == connectionType) {
                item.setText(0, connectionType.getName());
                item.setText(1, connectionType.getDescription());
                Color connectionColor = UIUtils.getConnectionTypeColor((DBPConnectionType)connectionType);
                item.setBackground(1, connectionColor);
                break;
            }
            ++n2;
        }
    }

    private static DBPConnectionType findSystemType(DBPConnectionType type) {
        DBPConnectionType[] dBPConnectionTypeArray = DBPConnectionType.SYSTEM_TYPES;
        int n = DBPConnectionType.SYSTEM_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            DBPConnectionType ct = dBPConnectionTypeArray[n2];
            if (ct.getId().equals(type.getId())) {
                return ct;
            }
            ++n2;
        }
        return null;
    }

    protected void performDefaults() {
        this.performDefaults(true);
        super.performDefaults();
    }

    protected void performDefaults(boolean resetSystemSettings) {
        this.typeTable.removeAll();
        for (DBPConnectionType source : DataSourceProviderRegistry.getInstance().getConnectionTypes()) {
            DBPConnectionType systemType = resetSystemSettings ? PrefPageConnectionTypes.findSystemType(source) : null;
            DBPConnectionType connectionType = systemType != null ? systemType : new DBPConnectionType(source);
            this.addTypeToTable(source, connectionType);
        }
        this.typeTable.select(0);
        if (this.selectedType != null) {
            int i = 0;
            while (i < this.typeTable.getItemCount()) {
                if (this.typeTable.getItem(i).getData().equals(this.selectedType)) {
                    this.typeTable.select(i);
                    break;
                }
                ++i;
            }
        }
        this.showSelectedType(this.getSelectedType());
        this.typeTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PrefPageConnectionTypes.this.typeTable.removeControlListener((ControlListener)this);
                UIUtils.packColumns((Table)PrefPageConnectionTypes.this.typeTable, (boolean)true);
            }
        });
    }

    private void addTypeToTable(DBPConnectionType source, DBPConnectionType connectionType) {
        this.changedInfo.put(connectionType, source);
        TableItem item = new TableItem(this.typeTable, 16384);
        item.setText(0, connectionType.getName());
        item.setText(1, CommonUtils.toString((Object)connectionType.getDescription()));
        if (connectionType.getColor() != null) {
            Color connectionColor = UIUtils.getConnectionTypeColor((DBPConnectionType)connectionType);
            item.setBackground(1, connectionColor);
        }
        item.setData((Object)connectionType);
    }

    public boolean performOk() {
        this.typeId.setEnabled(false);
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        HashSet<DBPConnectionType> toRemove = new HashSet<DBPConnectionType>();
        for (DBPConnectionType type : registry.getConnectionTypes()) {
            if (this.changedInfo.values().contains(type)) continue;
            toRemove.add(type);
        }
        HashSet<DBPConnectionType> changedSet = new HashSet<DBPConnectionType>();
        for (DBPConnectionType dBPConnectionType : toRemove) {
            registry.removeConnectionType(dBPConnectionType);
            changedSet.add(dBPConnectionType);
        }
        for (Map.Entry entry : this.changedInfo.entrySet()) {
            boolean hasChanges = false;
            DBPConnectionType changed = (DBPConnectionType)entry.getKey();
            DBPConnectionType source = (DBPConnectionType)entry.getValue();
            if (source == changed) {
                if (CommonUtils.isEmpty((String)changed.getId())) {
                    changed.setId(SecurityUtils.generateUniqueId());
                }
                for (DBPConnectionType type : this.changedInfo.keySet()) {
                    if (type == changed || !type.getId().equals(changed.getId())) continue;
                    changed.setId(SecurityUtils.generateUniqueId());
                    break;
                }
                entry.setValue(new DBPConnectionType(source));
                registry.addConnectionType(changed);
                hasChanges = true;
            } else if (!source.equals((Object)changed)) {
                source.setId(changed.getId());
                source.setName(changed.getName());
                source.setDescription(changed.getDescription());
                source.setAutocommit(changed.isAutocommit());
                source.setConfirmExecute(changed.isConfirmExecute());
                source.setConfirmDataChange(changed.isConfirmDataChange());
                source.setColor(changed.getColor());
                source.setModifyPermissions((Collection)changed.getModifyPermission());
                source.setSmartCommit(changed.isSmartCommit());
                source.setSmartCommitRecover(changed.isSmartCommitRecover());
                source.setAutoCloseTransactions(changed.isAutoCloseTransactions());
                source.setCloseIdleTransactionPeriod(changed.getCloseIdleTransactionPeriod());
                source.setAutoCloseConnections(changed.isAutoCloseConnections());
                source.setCloseIdleConnectionPeriod(changed.getCloseIdleConnectionPeriod());
                hasChanges = true;
            }
            if (!hasChanges) continue;
            changedSet.add(source);
        }
        HashSet<DBPDataSourceRegistry> hashSet = new HashSet<DBPDataSourceRegistry>();
        if (!changedSet.isEmpty()) {
            registry.saveConnectionTypes();
            block4: for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
                DBPDataSourceRegistry projectRegistry = project.getDataSourceRegistry();
                for (DBPDataSourceContainer ds : projectRegistry.getDataSources()) {
                    DBPConnectionConfiguration cnnCfg = ds.getConnectionConfiguration();
                    DBPConnectionType cnnType = cnnCfg.getConnectionType();
                    if (!changedSet.contains(cnnType)) continue;
                    if (toRemove.contains(cnnType)) {
                        cnnCfg.setConnectionType(DBPConnectionType.DEFAULT_TYPE);
                    }
                    projectRegistry.flushConfig();
                    hashSet.add(projectRegistry);
                    continue block4;
                }
            }
        }
        for (DBPDataSourceRegistry dsReg : hashSet) {
            dsReg.notifyDataSourceListeners(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, null, (Object)dsReg));
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
        this.selectedType = (DBPConnectionType)element.getAdapter(DBPConnectionType.class);
    }
}

