/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.rm;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManagerBuffer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.rm.DataSourceConfigurationManagerRM;

public class DataSourceRegistryRM<T extends DataSourceDescriptor>
extends DataSourceRegistry<T> {
    private static final Log log = Log.getLog(DataSourceRegistryRM.class);
    @NotNull
    private final RMController rmController;

    public DataSourceRegistryRM(@NotNull DBPProject project, @NotNull RMController rmController, @NotNull DBPPreferenceStore preferenceStore) {
        super(project, new DataSourceConfigurationManagerRM(project, rmController), preferenceStore);
        this.rmController = rmController;
    }

    @Override
    protected void persistDataSourceCreate(@NotNull DBPDataSourceContainer container) {
        if (this.getProject().isInMemory()) {
            return;
        }
        DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
        this.saveConfigurationToManager((DBRProgressMonitor)new VoidProgressMonitor(), buffer, dsc -> dsc.equals(container));
        try {
            this.rmController.createProjectDataSources(this.getRemoteProjectId(), new String(buffer.getData(), StandardCharsets.UTF_8), List.of(container.getId()));
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data source update", (Throwable)e);
        }
    }

    @Override
    protected void persistDataSourceUpdate(@NotNull DBPDataSourceContainer container) {
        if (this.getProject().isInMemory()) {
            return;
        }
        DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
        this.saveConfigurationToManager((DBRProgressMonitor)new VoidProgressMonitor(), buffer, dsc -> dsc.equals(container));
        try {
            this.rmController.updateProjectDataSources(this.getRemoteProjectId(), new String(buffer.getData(), StandardCharsets.UTF_8), List.of(container.getId()));
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data source update", (Throwable)e);
        }
    }

    @Override
    protected void persistDataSourceDelete(@NotNull DBPDataSourceContainer container) {
        if (this.getProject().isInMemory()) {
            return;
        }
        try {
            this.rmController.deleteProjectDataSources(this.getRemoteProjectId(), new String[]{container.getId()});
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data source update", (Throwable)e);
        }
    }

    @Override
    protected void persistDataFolderDelete(@NotNull String folderPath, boolean dropContents) {
        if (this.getProject().isInMemory()) {
            return;
        }
        try {
            this.rmController.deleteProjectDataSourceFolders(this.getRemoteProjectId(), new String[]{folderPath}, dropContents);
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data folder delete", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public DataSourceFolder addFolder(@Nullable DBPDataSourceFolder parent, @NotNull String name) {
        if (this.getProject().isInMemory()) {
            return this.createFolder(parent, name);
        }
        try {
            this.rmController.createProjectDataSourceFolder(this.getRemoteProjectId(), (String)(parent == null ? name : parent.getFolderPath() + "/" + name));
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data folder create", (Throwable)e);
            return null;
        }
        return this.createFolder(parent, name);
    }

    @Override
    public void moveFolder(@NotNull String oldPath, @NotNull String newPath) {
        if (this.getProject().isInMemory()) {
            super.moveFolder(oldPath, newPath);
            return;
        }
        try {
            this.rmController.moveProjectDataSourceFolder(this.getRemoteProjectId(), oldPath, newPath);
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error persisting rm data folder move", (Throwable)e);
            return;
        }
        super.moveFolder(oldPath, newPath);
    }

    @Override
    protected void saveDataSources(DBRProgressMonitor monitor) {
        if (this.getProject().isInMemory()) {
            return;
        }
        DataSourceConfigurationManagerBuffer buffer = new DataSourceConfigurationManagerBuffer();
        this.saveConfigurationToManager(monitor, buffer, null);
        try {
            this.rmController.updateProjectDataSources(this.getRemoteProjectId(), new String(buffer.getData(), StandardCharsets.UTF_8), List.of());
            this.lastError = null;
        }
        catch (DBException e) {
            this.lastError = e;
            log.error((Object)"Error saving data source configuration", (Throwable)e);
        }
    }

    @NotNull
    private String getRemoteProjectId() {
        return this.getProject().getId();
    }
}

