/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.rpc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestClient;
import org.jkiss.utils.rest.RestServer;

public class DBeaverInstanceServer
implements IInstanceController {
    private static final Log log = Log.getLog(DBeaverInstanceServer.class);
    private DBPDataSourceContainer dataSourceContainer = null;
    private final RestServer<IInstanceController> server;
    private final FileChannel configFileChannel;
    private final List<File> filesToConnect = new ArrayList<File>();

    private DBeaverInstanceServer() throws IOException {
        this.server = RestServer.builder(IInstanceController.class, (Object)this).setFilter(address -> address.getAddress().isLoopbackAddress()).create();
        this.configFileChannel = FileChannel.open(DBeaverInstanceServer.getConfigPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Properties props = new Properties();
            props.setProperty("port", String.valueOf(this.server.getAddress().getPort()));
            props.store(os, "DBeaver instance server properties");
            this.configFileChannel.write(ByteBuffer.wrap(os.toByteArray()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        log.debug((Object)("Starting instance server at http://localhost:" + this.server.getAddress().getPort()));
    }

    @Nullable
    public static DBeaverInstanceServer createServer() throws IOException {
        if (DBeaverInstanceServer.createClient() != null) {
            log.debug((Object)"Can't start instance server because other instance is already running");
            return null;
        }
        return new DBeaverInstanceServer();
    }

    @Nullable
    public static IInstanceController createClient() {
        return DBeaverInstanceServer.createClient(null);
    }

    @Nullable
    public static IInstanceController createClient(@Nullable String workspacePath) {
        Path path = DBeaverInstanceServer.getConfigPath(workspacePath);
        if (Files.notExists(path, new LinkOption[0])) {
            log.trace((Object)"No instance controller is available");
            return null;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)("Error reading instance controller configuration: " + e.getMessage()));
            return null;
        }
        String port = properties.getProperty("port");
        if (CommonUtils.isEmptyTrimmed((String)port)) {
            log.error((Object)"No port specified for the instance controller to connect to");
            return null;
        }
        IInstanceController instance = (IInstanceController)RestClient.builder((URI)URI.create("http://localhost:" + port), IInstanceController.class).create();
        try {
            long payload = System.currentTimeMillis();
            long response = instance.ping(payload);
            if (response != payload) {
                throw new IllegalStateException("Invalid ping response: " + response + ", was expecting " + payload);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error accessing instance server: " + e.getMessage()));
            return null;
        }
        return instance;
    }

    @Override
    public long ping(long payload) {
        return payload;
    }

    @Override
    public String getVersion() {
        return GeneralUtils.getProductVersion().toString();
    }

    @Override
    public void openExternalFiles(@NotNull String[] fileNames) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(fileNames) + "]"));
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        UIUtils.asyncExec(() -> {
            String[] stringArray2 = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String filePath = stringArray2[n2];
                File file = new File(filePath);
                if (file.exists()) {
                    this.filesToConnect.add(file);
                    if (this.dataSourceContainer != null) {
                        EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)this.dataSourceContainer));
                    }
                    EditorUtils.openExternalFileEditor((File)file, (IWorkbenchWindow)window);
                } else {
                    DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + file.getAbsolutePath() + "': file doesn't exist");
                }
                ++n2;
            }
            shell.setMinimized(false);
            shell.forceActive();
        });
    }

    @Override
    public void openDatabaseConnection(@NotNull String connectionSpec) {
        InstanceConnectionParameters instanceConParameters = new InstanceConnectionParameters();
        DBPDataSourceContainer dataSource = DataSourceUtils.getDataSourceBySpec((DBPProject)DBWorkbench.getPlatform().getWorkspace().getActiveProject(), (String)GeneralUtils.replaceVariables((String)connectionSpec, (IVariableResolver)SystemVariablesResolver.INSTANCE), (GeneralUtils.IParameterHandler)instanceConParameters, (boolean)false, (boolean)instanceConParameters.createNewConnection);
        if (dataSource == null) {
            this.filesToConnect.clear();
            return;
        }
        if (!CommonUtils.isEmpty(this.filesToConnect)) {
            for (File file : this.filesToConnect) {
                EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)dataSource));
            }
        }
        if (instanceConParameters.openConsole) {
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            UIUtils.syncExec(() -> {
                SQLEditorHandlerOpenEditor.openSQLConsole((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)new SQLNavigatorContext((DBSObject)dataSource), (String)dataSource.getName(), (String)"");
                workbenchWindow.getShell().forceActive();
            });
        } else if (instanceConParameters.makeConnect) {
            DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)dataSource, null);
        }
        this.filesToConnect.clear();
    }

    @Override
    public String getThreadDump() {
        log.info((Object)"Making thread dump");
        StringBuilder td = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> tde : Thread.getAllStackTraces().entrySet()) {
            td.append(tde.getKey().getId()).append(" ").append(tde.getKey().getName()).append(":\n");
            StackTraceElement[] stackTraceElementArray = tde.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ste = stackTraceElementArray[n2];
                td.append("\t").append(ste.toString()).append("\n");
                ++n2;
            }
        }
        return td.toString();
    }

    @Override
    public void quit() {
        log.info((Object)"Program termination requested");
        new Job("Terminate application"){

            protected IStatus run(IProgressMonitor monitor) {
                System.exit(-1);
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    @Override
    public void closeAllEditors() {
        log.debug((Object)"Close all open editor tabs");
        UIUtils.syncExec(() -> {
            IWorkbenchPage page;
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                page.closeAllEditors(false);
            }
        });
    }

    @Override
    public void executeWorkbenchCommand(@NotNull String commandId) {
        log.debug((Object)("Execute workbench command " + commandId));
        ActionUtils.runCommand((String)commandId, (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
    }

    @Override
    public void fireGlobalEvent(@NotNull String eventId, @NotNull Map<String, Object> properties) {
        DBPPlatformDesktop.getInstance().getGlobalEventManager().fireGlobalEvent(eventId, properties);
    }

    @Override
    public void bringToFront() {
        UIUtils.syncExec(() -> {
            Shell shell = UIUtils.getActiveShell();
            if (shell != null) {
                if (!shell.getMinimized()) {
                    shell.setMinimized(true);
                }
                shell.setMinimized(false);
                shell.setActive();
            }
        });
    }

    public void stopInstanceServer() {
        try {
            log.debug((Object)"Stop instance server");
            this.server.stop();
            if (this.configFileChannel != null) {
                this.configFileChannel.close();
                Files.delete(DBeaverInstanceServer.getConfigPath());
            }
            log.debug((Object)"Instance server has been stopped");
        }
        catch (Exception e) {
            log.error((Object)"Can't stop instance server", (Throwable)e);
        }
    }

    @NotNull
    private static Path getConfigPath() {
        return DBeaverInstanceServer.getConfigPath(null);
    }

    @NotNull
    private static Path getConfigPath(@Nullable String workspacePath) {
        if (workspacePath != null) {
            return Path.of(workspacePath, new String[0]).resolve(".metadata").resolve("dbeaver-instance.properties");
        }
        return GeneralUtils.getMetadataFolder().resolve("dbeaver-instance.properties");
    }

    private static class InstanceConnectionParameters
    implements GeneralUtils.IParameterHandler {
        boolean makeConnect = true;
        boolean openConsole = false;
        boolean createNewConnection = true;

        private InstanceConnectionParameters() {
        }

        public boolean setParameter(String name, String value) {
            switch (name) {
                case "connect": {
                    this.makeConnect = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "openConsole": {
                    this.openConsole = CommonUtils.toBoolean((Object)value);
                    return true;
                }
                case "create": {
                    this.createNewConnection = CommonUtils.toBoolean((Object)value);
                    return true;
                }
            }
            return false;
        }
    }
}

