/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.registry.ConfirmationRegistry;
import org.jkiss.utils.CommonUtils;

public class ConfirmationDialog
extends MessageDialogWithToggle {
    public static final String PREF_KEY_PREFIX = "org.jkiss.dbeaver.core.confirm.";
    public static final String RES_KEY_TITLE = "title";
    public static final String RES_KEY_MESSAGE = "message";
    public static final String RES_KEY_TOGGLE_MESSAGE = "toggleMessage";
    private boolean hideToggle;

    public ConfirmationDialog(Shell parentShell, String dialogTitle, Image image, String message, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, dialogButtonLabels, defaultIndex, toggleMessage, toggleState);
        this.hideToggle = toggleMessage == null;
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        if (this.hideToggle) {
            this.getToggleButton().setVisible(false);
        }
        return dialogArea;
    }

    @Nullable
    public static Boolean getPersistedState(@NotNull String id, int kind) {
        String key = PREF_KEY_PREFIX + id;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if ("always".equals(store.getString(key))) {
            return true;
        }
        if ("never".equals(store.getString(key))) {
            if (kind != 3 && kind != 6) {
                return true;
            }
            return false;
        }
        return null;
    }

    public static int open(int kind, int imageKind, Shell parent, String title, String message, String toggleMessage, boolean toggleState, String key) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (toggleMessage != null) {
            if ("always".equals(prefStore.getString(key))) {
                if (kind == 3 || kind == 6) {
                    return 2;
                }
                return 0;
            }
            if ("never".equals(prefStore.getString(key))) {
                if (kind == 3 || kind == 6) {
                    return 3;
                }
                return 0;
            }
        }
        ConfirmationDialog dialog = new ConfirmationDialog(parent == null ? UIUtils.getActiveWorkbenchShell() : parent, title, null, message, imageKind, ConfirmationDialog.getButtonLabels(kind), ConfirmationDialog.getDefaultIndex(kind, imageKind), toggleMessage, toggleState);
        dialog.setPrefStore(new PreferenceStoreDelegate(prefStore));
        dialog.setPrefKey(key);
        return dialog.open();
    }

    public static String[] getButtonLabels(int kind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return new String[]{IDialogConstants.OK_LABEL};
            }
            case 5: {
                return new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            }
            case 3: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            }
            case 6: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public static int getDefaultIndex(int kind, int imageKind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 5: {
                if (imageKind == 4) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                return 1;
            }
            case 6: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in MessageDialog.open()");
    }

    public static int confirmAction(@Nullable Shell shell, @NotNull String id, int type, Object ... args) {
        return ConfirmationRegistry.getInstance().confirmAction(shell, id, type, -1, args);
    }

    public static int confirmAction(@Nullable Shell shell, int imageType, @NotNull String id, int type, Object ... args) {
        return ConfirmationRegistry.getInstance().confirmAction(shell, id, type, imageType, args);
    }

    public static String getSavedPreference(String id) {
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        return prefStore.getString(PREF_KEY_PREFIX + id);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        IPreferenceStore prefStore = this.getPrefStore();
        String prefKey = this.getPrefKey();
        if (buttonId != 1 && this.getToggleState() && prefStore != null && CommonUtils.isNotEmpty((String)prefKey)) {
            if (buttonId == 3) {
                prefStore.setValue(prefKey, "never");
            } else {
                prefStore.setValue(prefKey, "always");
            }
        }
    }
}

