/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Base64;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class TextWithOpenFile
extends TextWithOpen {
    private final String title;
    private String[] filterExt;
    private final int style;
    private boolean openFolder = false;

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, int style, boolean binary) {
        this(parent, title, filterExt, style, binary, false, false);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, int style, boolean binary, boolean multiFS, boolean secured) {
        super(parent, multiFS, secured, binary);
        this.title = title;
        this.filterExt = filterExt;
        this.style = style;
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt) {
        this(parent, title, filterExt, 4100, false);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, boolean binary) {
        this(parent, title, filterExt, 4100, binary);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, boolean binary, boolean secured) {
        this(parent, title, filterExt, 4100, binary, false, secured);
    }

    public void setOpenFolder(boolean openFolder) {
        this.openFolder = openFolder;
    }

    public void setFilterExtensions(@NotNull String[] filterExtensions) {
        this.filterExt = filterExtensions;
    }

    @Override
    protected void openBrowser(boolean remoteFS) {
        String selected;
        if (remoteFS) {
            DBNPathBase selPath = DBWorkbench.getPlatformUI().openFileSystemSelector(this.title, this.openFolder, this.style, this.isBinaryContents(), this.filterExt, this.getText());
            selected = selPath != null ? DBFUtils.getUriFromPath((Path)selPath.getPath()).toString() : null;
        } else {
            String directory = this.getDialogDirectory();
            if (this.openFolder) {
                fd = new DirectoryDialog(this.getShell(), this.style);
                if (directory != null) {
                    fd.setFilterPath(directory);
                }
                if (this.title != null) {
                    fd.setText(this.title);
                }
                selected = fd.open();
            } else {
                fd = new FileDialog(this.getShell(), this.style);
                fd.setText(this.title);
                fd.setFilterExtensions(this.filterExt);
                if (directory != null) {
                    DialogUtils.setCurDialogFolder(directory);
                }
                selected = DialogUtils.openFileDialog((FileDialog)fd);
            }
        }
        if (selected != null && this.isShowFileContentEditor()) {
            Path filePath = IOUtils.getPathFromString((String)selected);
            try {
                if (this.isBinaryContents()) {
                    byte[] bytes = Files.readAllBytes(filePath);
                    selected = Base64.getEncoder().encodeToString(bytes);
                } else {
                    selected = Files.readString(filePath);
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("File read error", "Can't read file '" + String.valueOf(filePath) + "' contents", (Throwable)e);
            }
        }
        if (selected != null) {
            this.setText(selected);
        }
    }

    private String getDialogDirectory() {
        String text = this.getText();
        if (CommonUtils.isEmptyTrimmed((String)text)) {
            return null;
        }
        try {
            String dirPath = IOUtils.getDirectoryPath((String)text);
            if (CommonUtils.isNotEmpty((String)dirPath)) {
                return dirPath;
            }
        }
        catch (InvalidPathException invalidPathException) {}
        return null;
    }
}

