/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.IOUtils;

public class TextWithOpen
extends Composite {
    private static final Log log = Log.getLog(TextWithOpen.class);
    private final Text text;
    private final ToolBar toolbar;
    private final boolean multiFS;
    private final boolean binary;

    public TextWithOpen(Composite parent, boolean multiFS) {
        this(parent, multiFS, false);
    }

    public TextWithOpen(Composite parent, boolean multiFS, boolean secured) {
        this(parent, multiFS, secured, false);
    }

    public TextWithOpen(Composite parent, boolean multiFS, final boolean secured, boolean binary) {
        super(parent, 0);
        ToolItem toolItem;
        this.multiFS = multiFS;
        this.binary = binary;
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        this.setLayout((Layout)gl);
        boolean useTextEditor = this.isShowFileContentEditor();
        this.text = new Text((Composite)this, 0x800 | (useTextEditor && !secured ? 514 : 4));
        if (secured) {
            this.text.setEchoChar('*');
        }
        GridData gd = new GridData(772);
        if (useTextEditor) {
            gd.heightHint = this.text.getLineHeight() * (secured ? 1 : 2);
            gd.widthHint = 300;
        } else {
            gd.widthHint = 200;
        }
        this.text.setLayoutData((Object)gd);
        this.toolbar = new ToolBar((Composite)this, 0x800000);
        if (useTextEditor) {
            toolItem = new ToolItem(this.toolbar, 0);
            toolItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TEXTFIELD));
            toolItem.setToolTipText(secured ? UIMessages.text_with_open_dialog_set_text : UIMessages.text_with_open_dialog_edit_text);
            toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newText = EditTextDialog.editText(TextWithOpen.this.getShell(), secured ? UIMessages.text_with_open_dialog_set_text : UIMessages.text_with_open_dialog_edit_text, secured ? "" : TextWithOpen.this.getText());
                    if (newText != null) {
                        TextWithOpen.this.setText(newText);
                    }
                }
            });
        }
        toolItem = new ToolItem(this.toolbar, 0);
        toolItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER));
        toolItem.setToolTipText(UIMessages.text_with_open_dialog_browse);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextWithOpen.this.openBrowser(false);
            }
        });
        if (this.isMultiFileSystem()) {
            ToolItem remoteFsItem = new ToolItem(this.toolbar, 0);
            remoteFsItem.setImage(DBeaverIcons.getImage((DBPImage)((this.getStyle() & 0x1000) != 0 ? UIIcon.OPEN_EXTERNAL : UIIcon.SAVE_EXTERNAL)));
            remoteFsItem.setToolTipText(UIMessages.text_with_open_dialog_browse_remote);
            remoteFsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextWithOpen.this.openBrowser(true);
                }
            });
        }
        if (!useTextEditor && !this.isBinaryContents()) {
            ToolItem editItem = new ToolItem(this.toolbar, 0);
            editItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EDIT));
            editItem.setToolTipText(UIMessages.text_with_open_dialog_edit_file);
            editItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String filePath = TextWithOpen.this.text.getText();
                    IFileStore store = EFS.getLocalFileSystem().getStore(Path.of(filePath, new String[0]).toUri());
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)UIUtils.getActiveWorkbenchWindow().getActivePage(), (IFileStore)store);
                    }
                    catch (Exception ex) {
                        DBWorkbench.getPlatformUI().showError("File open error", null, (Throwable)ex);
                    }
                }
            });
            this.text.addModifyListener(e -> {
                String fileName = this.text.getText().trim();
                try {
                    if (!IOUtils.isLocalFile((String)fileName)) {
                        editItem.setEnabled(false);
                    } else {
                        Path targetFile = Path.of(fileName, new String[0]);
                        editItem.setEnabled(Files.exists(targetFile, new LinkOption[0]) && !Files.isDirectory(targetFile, new LinkOption[0]));
                    }
                }
                catch (Exception ex) {
                    log.debug((Object)("Error getting file info: " + ex.getMessage()));
                    editItem.setEnabled(false);
                }
            });
            editItem.setEnabled(false);
        }
        gd = new GridData(66);
        this.toolbar.setLayoutData((Object)gd);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    protected boolean isShowFileContentEditor() {
        return false;
    }

    protected boolean isBinaryContents() {
        return this.binary;
    }

    public boolean isMultiFileSystem() {
        return this.multiFS;
    }

    public DBPProject getProject() {
        return null;
    }

    protected void openBrowser(boolean remoteFS) {
    }

    public Text getTextControl() {
        return this.text;
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.toolbar.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }
}

