/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassLoaderUtil {
    private static Map abbreviationMap = new HashMap();

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put(primitive, abbreviation);
    }

    public static Class getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        Class<?> clazz;
        if (abbreviationMap.containsKey(className)) {
            String clsName = "[" + abbreviationMap.get(className);
            clazz = Class.forName(clsName, initialize, classLoader).getComponentType();
        } else {
            clazz = Class.forName(ClassLoaderUtil.toCanonicalName(className), initialize, classLoader);
        }
        return clazz;
    }

    public static Class getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return ClassLoaderUtil.getClass(classLoader, className, true);
    }

    public static Class getClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.getClass(className, true);
    }

    public static Class getClass(String className, boolean initialize) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader currentCL = ClassLoaderUtil.class.getClassLoader();
        if (contextCL != null) {
            try {
                return ClassLoaderUtil.getClass(contextCL, className, initialize);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ClassLoaderUtil.getClass(currentCL, className, initialize);
    }

    private static String toCanonicalName(String className) {
        Objects.requireNonNull(className, "className");
        if (className.endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = (String)abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    static {
        ClassLoaderUtil.addAbbreviation("int", "I");
        ClassLoaderUtil.addAbbreviation("boolean", "Z");
        ClassLoaderUtil.addAbbreviation("float", "F");
        ClassLoaderUtil.addAbbreviation("long", "J");
        ClassLoaderUtil.addAbbreviation("short", "S");
        ClassLoaderUtil.addAbbreviation("byte", "B");
        ClassLoaderUtil.addAbbreviation("double", "D");
        ClassLoaderUtil.addAbbreviation("char", "C");
    }
}

