/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;

public class JDBCDatabaseMetaDataImpl
implements JDBCDatabaseMetaData {
    private JDBCSession connection;
    private DatabaseMetaData original;

    public JDBCDatabaseMetaDataImpl(JDBCSession connection, DatabaseMetaData original) {
        this.connection = connection;
        this.original = original;
    }

    public DatabaseMetaData getOriginal() throws SQLException {
        if (this.original == null) {
            throw new SQLException("Database metadata not supported by driver");
        }
        return this.original;
    }

    private JDBCResultSet makeResultSet(ResultSet resultSet, String functionName, Object ... args) throws SQLException {
        Object description = functionName;
        if (args.length > 0) {
            description = (String)description + " " + Arrays.toString(args);
        }
        return JDBCResultSetImpl.makeResultSet(this.connection, null, resultSet, (String)description, false);
    }

    @Override
    public JDBCSession getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.getOriginal().supportsSavepoints();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return this.getOriginal().supportsNamedParameters();
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return this.getOriginal().supportsMultipleOpenResults();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.getOriginal().supportsGetGeneratedKeys();
    }

    @Override
    public JDBCResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getSuperTypes(catalog, schemaPattern, typeNamePattern), "Load super types", catalog, schemaPattern, typeNamePattern);
    }

    @Override
    public JDBCResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getSuperTables(catalog, schemaPattern, tableNamePattern), "Load super tables", catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public JDBCResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern), "Load UDT attributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return this.getOriginal().supportsResultSetHoldability(holdability);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getOriginal().getResultSetHoldability();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.getOriginal().getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.getOriginal().getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return this.getOriginal().getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return this.getOriginal().getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return this.getOriginal().getSQLStateType();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return this.getOriginal().locatorsUpdateCopy();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return this.getOriginal().supportsStatementPooling();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return this.getOriginal().getRowIdLifetime();
    }

    @Override
    public JDBCResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getSchemas(catalog, schemaPattern), "Load schemas", catalog, schemaPattern);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return this.getOriginal().supportsStoredFunctionsUsingCallSyntax();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return this.getOriginal().autoCommitFailureClosesAllResultSets();
    }

    @Override
    public JDBCResultSet getClientInfoProperties() throws SQLException {
        return this.makeResultSet(this.getOriginal().getClientInfoProperties(), "Load client info", new Object[0]);
    }

    @Override
    public JDBCResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getFunctions(catalog, schemaPattern, functionNamePattern), "Load functions", catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public JDBCResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern), "Load function columns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern), "Load pseudo columns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return this.getOriginal().generatedKeyAlwaysReturned();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getOriginal().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getOriginal().isWrapperFor(iface);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.getOriginal().allProceduresAreCallable();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.getOriginal().allTablesAreSelectable();
    }

    @Override
    public String getURL() throws SQLException {
        return this.getOriginal().getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.getOriginal().getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getOriginal().isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return this.getOriginal().nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.getOriginal().nullsAreSortedLow();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return this.getOriginal().nullsAreSortedAtStart();
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.getOriginal().nullsAreSortedAtEnd();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.getOriginal().getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.getOriginal().getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return this.getOriginal().getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return this.getOriginal().getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.original == null ? 0 : this.original.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.original == null ? 0 : this.original.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.getOriginal().usesLocalFiles();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return this.getOriginal().usesLocalFilePerTable();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return this.getOriginal().supportsMixedCaseIdentifiers();
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return this.getOriginal().storesUpperCaseIdentifiers();
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return this.getOriginal().storesLowerCaseIdentifiers();
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return this.getOriginal().storesMixedCaseIdentifiers();
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getOriginal().supportsMixedCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return this.getOriginal().storesUpperCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return this.getOriginal().storesLowerCaseQuotedIdentifiers();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return this.getOriginal().storesMixedCaseQuotedIdentifiers();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return this.getOriginal().getIdentifierQuoteString();
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.getOriginal().getSQLKeywords();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return this.getOriginal().getNumericFunctions();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return this.getOriginal().getStringFunctions();
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return this.getOriginal().getSystemFunctions();
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return this.getOriginal().getTimeDateFunctions();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return this.getOriginal().getSearchStringEscape();
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return this.getOriginal().getExtraNameCharacters();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return this.getOriginal().supportsAlterTableWithAddColumn();
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return this.getOriginal().supportsAlterTableWithDropColumn();
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return this.getOriginal().supportsColumnAliasing();
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return this.getOriginal().nullPlusNonNullIsNull();
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return this.getOriginal().supportsConvert();
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return this.getOriginal().supportsConvert(fromType, toType);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return this.getOriginal().supportsTableCorrelationNames();
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return this.getOriginal().supportsDifferentTableCorrelationNames();
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return this.getOriginal().supportsExpressionsInOrderBy();
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.getOriginal().supportsOrderByUnrelated();
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return this.getOriginal().supportsGroupBy();
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.getOriginal().supportsGroupByUnrelated();
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.getOriginal().supportsGroupByBeyondSelect();
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return this.getOriginal().supportsLikeEscapeClause();
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return this.getOriginal().supportsMultipleResultSets();
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return this.getOriginal().supportsMultipleTransactions();
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return this.getOriginal().supportsNonNullableColumns();
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return this.getOriginal().supportsMinimumSQLGrammar();
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return this.getOriginal().supportsCoreSQLGrammar();
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return this.getOriginal().supportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return this.getOriginal().supportsANSI92EntryLevelSQL();
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return this.getOriginal().supportsANSI92IntermediateSQL();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return this.getOriginal().supportsANSI92FullSQL();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return this.getOriginal().supportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return this.getOriginal().supportsOuterJoins();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return this.getOriginal().supportsFullOuterJoins();
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return this.getOriginal().supportsLimitedOuterJoins();
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return this.getOriginal().getSchemaTerm();
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return this.getOriginal().getProcedureTerm();
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return this.getOriginal().getCatalogTerm();
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return this.getOriginal().isCatalogAtStart();
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return this.getOriginal().getCatalogSeparator();
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return this.getOriginal().supportsSchemasInDataManipulation();
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.getOriginal().supportsSchemasInProcedureCalls();
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return this.getOriginal().supportsSchemasInTableDefinitions();
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return this.getOriginal().supportsSchemasInIndexDefinitions();
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return this.getOriginal().supportsSchemasInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return this.getOriginal().supportsCatalogsInDataManipulation();
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return this.getOriginal().supportsCatalogsInProcedureCalls();
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return this.getOriginal().supportsCatalogsInTableDefinitions();
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return this.getOriginal().supportsCatalogsInIndexDefinitions();
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return this.getOriginal().supportsCatalogsInPrivilegeDefinitions();
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return this.getOriginal().supportsPositionedDelete();
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return this.getOriginal().supportsPositionedUpdate();
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return this.getOriginal().supportsSelectForUpdate();
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.getOriginal().supportsStoredProcedures();
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.getOriginal().supportsSubqueriesInComparisons();
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return this.getOriginal().supportsSubqueriesInExists();
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.getOriginal().supportsSubqueriesInIns();
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return this.getOriginal().supportsSubqueriesInQuantifieds();
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.getOriginal().supportsCorrelatedSubqueries();
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return this.getOriginal().supportsUnion();
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return this.getOriginal().supportsUnionAll();
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return this.getOriginal().supportsOpenCursorsAcrossCommit();
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return this.getOriginal().supportsOpenCursorsAcrossRollback();
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return this.getOriginal().supportsOpenStatementsAcrossCommit();
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return this.getOriginal().supportsOpenStatementsAcrossRollback();
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.getOriginal().getMaxBinaryLiteralLength();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return this.getOriginal().getMaxCharLiteralLength();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return this.getOriginal().getMaxColumnNameLength();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getOriginal().getMaxColumnsInGroupBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return this.getOriginal().getMaxColumnsInIndex();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getOriginal().getMaxColumnsInOrderBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return this.getOriginal().getMaxColumnsInSelect();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return this.getOriginal().getMaxColumnsInTable();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return this.getOriginal().getMaxConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return this.getOriginal().getMaxCursorNameLength();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return this.getOriginal().getMaxIndexLength();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return this.getOriginal().getMaxSchemaNameLength();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return this.getOriginal().getMaxProcedureNameLength();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return this.getOriginal().getMaxCatalogNameLength();
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return this.getOriginal().getMaxRowSize();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return this.getOriginal().doesMaxRowSizeIncludeBlobs();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return this.getOriginal().getMaxStatementLength();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.getOriginal().getMaxStatements();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return this.getOriginal().getMaxTableNameLength();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return this.getOriginal().getMaxTablesInSelect();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return this.getOriginal().getMaxUserNameLength();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return this.getOriginal().getDefaultTransactionIsolation();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return this.getOriginal().supportsTransactions();
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.getOriginal().supportsTransactionIsolationLevel(level);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return this.getOriginal().supportsDataDefinitionAndDataManipulationTransactions();
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return this.getOriginal().supportsDataManipulationTransactionsOnly();
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.getOriginal().dataDefinitionCausesTransactionCommit();
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return this.getOriginal().dataDefinitionIgnoredInTransactions();
    }

    @Override
    public JDBCResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getProcedures(catalog, schemaPattern, procedureNamePattern), "Load procedures", catalog, schemaPattern, procedureNamePattern);
    }

    @Override
    public JDBCResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern), "Load procedure columns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
    }

    @Override
    public JDBCResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return this.makeResultSet(this.getOriginal().getTables(catalog, schemaPattern, tableNamePattern, types), "Load tables", catalog, schemaPattern, tableNamePattern, types);
    }

    @Override
    public JDBCResultSet getSchemas() throws SQLException {
        return this.makeResultSet(this.getOriginal().getSchemas(), "Load schemas", new Object[0]);
    }

    @Override
    public JDBCResultSet getCatalogs() throws SQLException {
        return this.makeResultSet(this.getOriginal().getCatalogs(), "Load catalogs", new Object[0]);
    }

    @Override
    public JDBCResultSet getTableTypes() throws SQLException {
        return this.makeResultSet(this.getOriginal().getTableTypes(), "Load table types", new Object[0]);
    }

    @Override
    public JDBCResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern), "Load columns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
    }

    @Override
    public JDBCResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getColumnPrivileges(catalog, schema, table, columnNamePattern), "Load column privileges", catalog, schema, table, columnNamePattern);
    }

    @Override
    public JDBCResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.makeResultSet(this.getOriginal().getTablePrivileges(catalog, schemaPattern, tableNamePattern), "Load table privileges", catalog, schemaPattern, tableNamePattern);
    }

    @Override
    public JDBCResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.makeResultSet(this.getOriginal().getBestRowIdentifier(catalog, schema, table, scope, nullable), "Find best row identifier", catalog, schema, table);
    }

    @Override
    public JDBCResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.makeResultSet(this.getOriginal().getVersionColumns(catalog, schema, table), "Find version columns", catalog, schema, table);
    }

    @Override
    public JDBCResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return this.makeResultSet(this.getOriginal().getPrimaryKeys(catalog, schema, table), "Load primary keys", catalog, schema, table);
    }

    @Override
    public JDBCResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.makeResultSet(this.getOriginal().getImportedKeys(catalog, schema, table), "Load imported keys", catalog, schema, table);
    }

    @Override
    public JDBCResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.makeResultSet(this.getOriginal().getExportedKeys(catalog, schema, table), "Load exported keys", catalog, schema, table);
    }

    @Override
    public JDBCResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.makeResultSet(this.getOriginal().getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable), "Load cross reference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public JDBCResultSet getTypeInfo() throws SQLException {
        return this.makeResultSet(this.getOriginal().getTypeInfo(), "Load type info", new Object[0]);
    }

    @Override
    public JDBCResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.makeResultSet(this.getOriginal().getIndexInfo(catalog, schema, table, unique, approximate), "Load indexes", catalog, schema, table);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return this.getOriginal().supportsResultSetType(type);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return this.getOriginal().supportsResultSetConcurrency(type, concurrency);
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return this.getOriginal().ownUpdatesAreVisible(type);
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return this.getOriginal().ownDeletesAreVisible(type);
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return this.getOriginal().ownInsertsAreVisible(type);
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return this.getOriginal().othersUpdatesAreVisible(type);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return this.getOriginal().othersDeletesAreVisible(type);
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return this.getOriginal().othersInsertsAreVisible(type);
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return this.getOriginal().updatesAreDetected(type);
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return this.getOriginal().deletesAreDetected(type);
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return this.getOriginal().insertsAreDetected(type);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return this.getOriginal().supportsBatchUpdates();
    }

    @Override
    public JDBCResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.makeResultSet(this.getOriginal().getUDTs(catalog, schemaPattern, typeNamePattern, types), "Load UDTs", catalog, schemaPattern, typeNamePattern);
    }
}

