/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IDocumentDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterJSON
extends StreamExporterAbstract
implements IDocumentDataExporter {
    public static final String PROP_FORMAT_DATE_ISO = "formatDateISO";
    public static final String PROP_PRINT_TABLE_NAME = "printTableName";
    public static final String PROP_EXPORT_JSON_VALUES = "exportJsonValues";
    public static final String PROP_EXPORT_JSON_VALUES_AS_STRING = "string";
    public static final String PROP_EXPORT_JSON_VALUES_AS_JSON = "json";
    private DBDAttributeBinding[] columns;
    private String tableName;
    private int rowNum = 0;
    private boolean printTableName = true;
    private boolean formatDateISO = true;
    private String exportJsonAs = "string";

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.formatDateISO = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_FORMAT_DATE_ISO), (boolean)true);
        this.printTableName = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_PRINT_TABLE_NAME), (boolean)true);
        this.exportJsonAs = (String)site.getProperties().getOrDefault(PROP_EXPORT_JSON_VALUES, PROP_EXPORT_JSON_VALUES_AS_STRING);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.tableName = this.getSite().getSource().getName();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        if (this.printTableName) {
            out.write("{\n");
            out.write("\"" + JSONUtils.escapeJsonString((String)this.tableName) + "\": ");
        }
        out.write("[\n");
        this.rowNum = 0;
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        if (this.rowNum > 0) {
            out.write(",\n");
        }
        ++this.rowNum;
        if (this.isJsonDocumentResults(row)) {
            this.writeDocument(session, (DBDDocument)row[0]);
        } else {
            out.write("\t{\n");
            int i = 0;
            while (i < this.columns.length) {
                DBDAttributeBinding column = this.columns[i];
                String columnName = CommonUtils.isEmpty((String)column.getLabel()) ? column.getName() : column.getLabel();
                out.write("\t\t\"" + JSONUtils.escapeJsonString((String)columnName) + "\" : ");
                Object cellValue = row[i];
                if (DBUtils.isNullValue((Object)cellValue)) {
                    this.writeTextCell(null, true);
                } else if (cellValue instanceof DBDContent) {
                    DBDContent content = (DBDContent)cellValue;
                    this.writeContentValue(session, resultSet, content);
                } else if (cellValue instanceof Number || cellValue instanceof Boolean) {
                    out.write(cellValue.toString());
                } else if (cellValue instanceof Date && this.formatDateISO) {
                    this.writeTextCell(JSONUtils.formatDate((Date)((Date)cellValue)), true);
                } else if (PROP_EXPORT_JSON_VALUES_AS_JSON.equalsIgnoreCase(this.exportJsonAs) && this.hasJsonDataType(column)) {
                    this.writeTextCell(super.getValueDisplayString(column, cellValue), false);
                } else {
                    this.writeTextCell(super.getValueDisplayString(column, cellValue), true);
                }
                if (i < this.columns.length - 1) {
                    out.write(",");
                }
                out.write("\n");
                ++i;
            }
            out.write("\t}");
        }
    }

    private boolean isJsonDocumentResults(@NotNull Object[] row) {
        if (!ArrayUtils.isEmpty((Object[])this.columns)) {
            Object object;
            DBPDataKind dataKind = this.columns[0].getDataKind();
            if (this.columns.length == 1 && (dataKind == DBPDataKind.DOCUMENT || dataKind == DBPDataKind.STRUCT) && row.length > 0 && !DBUtils.isNullValue((Object)row[0]) && (object = row[0]) instanceof DBDDocument) {
                DBDDocument document = (DBDDocument)object;
                return "text/json".equalsIgnoreCase(document.getDocumentContentType());
            }
        }
        return false;
    }

    private void writeDocument(DBCSession session, DBDDocument document) throws DBException, IOException {
        document.serializeDocument(session.getProgressMonitor(), this.getOutputStream(), StandardCharsets.UTF_8);
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        PrintWriter out = this.getWriter();
        out.write("\n]");
        if (this.printTableName) {
            out.write("}");
        }
        out.write("\n");
    }

    private void writeTextCell(@Nullable String value, boolean escape) {
        if (value == null) {
            this.getWriter().write("null");
        } else if (escape) {
            this.getWriter().write("\"" + JSONUtils.escapeJsonString((String)value) + "\"");
        } else {
            this.getWriter().write(value);
        }
    }

    private void writeContentValue(DBCSession session, DBCResultSet resultSet, DBDContent content) throws DBCException, IOException {
        try {
            DBDContentStorage cs = content.getContents(session.getProgressMonitor());
            if (cs != null) {
                if (ContentUtils.isTextContent((DBDContent)content)) {
                    this.writeClob(content, cs);
                } else {
                    this.writeBlob(cs);
                }
            }
        }
        finally {
            DTUtils.closeContents(resultSet, content);
        }
    }

    private void writeClob(DBDContent content, DBDContentStorage cs) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Reader in = cs.getContentReader();){
            if (PROP_EXPORT_JSON_VALUES_AS_JSON.equalsIgnoreCase(this.exportJsonAs) && ContentUtils.isJSON((DBDContent)content)) {
                this.writeCellValue(in, false);
            } else {
                this.getWriter().write("\"");
                this.writeCellValue(in, true);
                this.getWriter().write("\"");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeBlob(DBDContentStorage cs) throws IOException {
        this.getWriter().write("\"");
        this.getSite().writeBinaryData(cs);
        this.getWriter().write("\"");
    }

    private void writeCellValue(Reader reader, boolean escape) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            String chunk = new String(buffer, 0, count);
            this.getWriter().write(escape ? JSONUtils.escapeJsonString((String)chunk) : chunk);
        }
    }

    private boolean hasJsonDataType(@NotNull DBDAttributeBinding column) {
        DBCAttributeMetaData metaAttribute = column.getMetaAttribute();
        if (metaAttribute == null) {
            return false;
        }
        return metaAttribute.getTypeName().toLowerCase(Locale.ROOT).contains(PROP_EXPORT_JSON_VALUES_AS_JSON);
    }
}

