/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.stream.IMultiStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class StreamProducerSettings
implements IDataTransferSettings {
    private static final Log log = Log.getLog(StreamProducerSettings.class);
    private final Map<String, StreamEntityMapping> entityMapping = new LinkedHashMap<String, StreamEntityMapping>();
    private Map<String, Object> processorProperties;
    private int maxRows;
    private transient Map<String, Object> lastProcessorProperties;
    private transient StreamTransferProducer lastProducer;

    public Map<String, Object> getProcessorProperties() {
        return this.processorProperties;
    }

    public void setProcessorProperties(Map<String, Object> processorProperties) {
        this.processorProperties = processorProperties;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.setProcessorProperties(dataTransferSettings.getProcessorProperties());
        try {
            runnableContext.run(true, true, monitor -> {
                for (Map mapping : JSONUtils.getObjectList((Map)settings, (String)"mappings")) {
                    try {
                        StreamEntityMapping em = new StreamEntityMapping(monitor, dataTransferSettings.getProject(), mapping);
                        this.entityMapping.put(em.getEntityName(), em);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                this.updateMappingsFromStream(monitor, dataTransferSettings);
            });
        }
        catch (Exception e) {
            log.error((Object)"Error loading stream producer settings", (Throwable)e);
        }
    }

    public void updateMappingsFromStream(DBRProgressMonitor monitor, DataTransferSettings dataTransferSettings) {
        for (DataTransferPipe pipe : dataTransferSettings.getDataPipes()) {
            StreamTransferProducer producer = (StreamTransferProducer)pipe.getProducer();
            if (producer.getEntityMapping() == null) continue;
            this.updateProducerSettingsFromStream(monitor, producer, dataTransferSettings);
        }
    }

    public boolean extractExtraEntities(@NotNull DBRProgressMonitor monitor, @NotNull StreamEntityMapping entityMapping, @NotNull DataTransferSettings settings, @NotNull Collection<StreamEntityMapping> pendingEntityMappings) {
        block17: {
            if (!entityMapping.isChild() && settings.getProcessor().isMulti()) {
                IMultiStreamDataImporter importer = (IMultiStreamDataImporter)settings.getProcessor().getInstance();
                monitor.beginTask("Extract extra entities from stream", 1);
                try {
                    boolean bl;
                    block16: {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        InputStream is = Files.newInputStream(entityMapping.getInputFile(), new OpenOption[0]);
                        try {
                            bl = pendingEntityMappings.addAll(importer.readEntitiesInfo(entityMapping, is));
                            if (is == null) break block16;
                        }
                        catch (Throwable throwable2) {
                            try {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Exception e) {
                                settings.getState().addError(e);
                                log.error((Object)"IO error while reading entities from stream", (Throwable)e);
                                break block17;
                            }
                        }
                        is.close();
                    }
                    return bl;
                }
                finally {
                    monitor.done();
                }
            }
        }
        return false;
    }

    public void updateProducerSettingsFromStream(@NotNull DBRProgressMonitor monitor, @NotNull StreamTransferProducer producer, @NotNull DataTransferSettings dataTransferSettings) {
        try {
            this.updateProducerSettingsFromStream(monitor, producer, dataTransferSettings.getProcessor().getInstance(), dataTransferSettings.getProcessorProperties());
        }
        catch (DBException e) {
            log.warn((Object)"Exception during of updating producer settings", (Throwable)e);
            dataTransferSettings.getState().addError(e);
        }
    }

    public void updateProducerSettingsFromStream(@NotNull DBRProgressMonitor monitor, @NotNull StreamTransferProducer producer, @NotNull IDataTransferProcessor processor, @NotNull Map<String, Object> processorProperties) throws DBException {
        monitor.beginTask("Update data produces settings from import stream", 1);
        if (CommonUtils.equalObjects(this.lastProcessorProperties, processorProperties) && CommonUtils.equalObjects((Object)this.lastProducer, (Object)producer)) {
            return;
        }
        this.lastProcessorProperties = new LinkedHashMap<String, Object>(processorProperties);
        this.lastProducer = producer;
        StreamEntityMapping entityMapping = producer.getEntityMapping();
        if (entityMapping != null && processor instanceof IStreamDataImporter) {
            IStreamDataImporter sdi = (IStreamDataImporter)processor;
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (InputStream is = Files.newInputStream(entityMapping.getInputFile(), new OpenOption[0]);){
                    sdi.init(new StreamDataImporterSite(this, entityMapping, processorProperties));
                    try {
                        List<StreamDataImporterColumnInfo> columnInfos = sdi.readColumnsInfo(entityMapping, is);
                        entityMapping.setStreamColumns(columnInfos);
                    }
                    finally {
                        sdi.dispose();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException && DBWorkbench.getPlatform().getApplication().isMultiuser() && IOUtils.isLocalPath((Path)entityMapping.getInputFile())) {
                    throw new DBException("Local file '" + String.valueOf(entityMapping.getInputFile()) + "' doesn't exist or not accessible. Use Cloud Storage to import/export data.\nLearn more at " + HelpUtils.getHelpExternalReference((String)"Cloud-Storage"), (Throwable)e);
                }
                throw new DBException("Error reading columns from stream", (Throwable)e);
            }
        }
        monitor.done();
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        ArrayList<Map<String, Object>> mappings = new ArrayList<Map<String, Object>>();
        settings.put("mappings", mappings);
        for (StreamEntityMapping emc : this.entityMapping.values()) {
            Map<String, Object> emSettings = emc.saveSettings();
            if (emSettings == null) continue;
            mappings.add(emSettings);
        }
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        return summary.toString();
    }
}

