/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsNaturalJoinModel
extends SQLQueryRowsSetOperationModel {
    @Nullable
    private final SQLQueryValueExpression condition;
    @Nullable
    private final List<SQLQuerySymbolEntry> columsToJoin;
    @Nullable
    private final SQLQueryLexicalScope conditionScope;

    public SQLQueryRowsNaturalJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @NotNull SQLQueryValueExpression condition, @NotNull SQLQueryLexicalScope conditionScope) {
        super(range, syntaxNode, left, right);
        super.registerSubnode(condition);
        this.condition = condition;
        this.conditionScope = conditionScope;
        this.columsToJoin = null;
        this.registerLexicalScope(conditionScope);
    }

    public SQLQueryRowsNaturalJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @Nullable List<SQLQuerySymbolEntry> columsToJoin, @NotNull SQLQueryLexicalScope conditionScope) {
        super(range, syntaxNode, left, right);
        this.condition = null;
        this.conditionScope = conditionScope;
        this.columsToJoin = columsToJoin;
        this.registerLexicalScope(conditionScope);
    }

    @Nullable
    public SQLQueryValueExpression getCondition() {
        return this.condition;
    }

    @Nullable
    public List<SQLQuerySymbolEntry> getColumsToJoin() {
        return this.columsToJoin;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(context, statistics);
        if (this.columsToJoin != null) {
            for (SQLQuerySymbolEntry column : this.columsToJoin) {
                if (!column.isNotClassified()) continue;
                SQLQuerySymbol symbol = column.getSymbol();
                SQLQueryResultColumn leftColumnDef = left.resolveColumn(statistics.getMonitor(), column.getName());
                SQLQueryResultColumn rightColumnDef = right.resolveColumn(statistics.getMonitor(), column.getName());
                if (leftColumnDef != null && rightColumnDef != null) {
                    symbol.setDefinition(column);
                    symbol.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                    continue;
                }
                if (leftColumnDef != null) {
                    statistics.appendError(column, "Column " + column.getName() + " not found to the left of join");
                } else {
                    statistics.appendError(column, "Column " + column.getName() + " not found to the right of join");
                }
                symbol.setSymbolClass(SQLQuerySymbolClass.ERROR);
            }
        }
        SQLQueryDataContext combinedContext = left.combineForJoin(right);
        if (this.condition != null) {
            this.condition.propagateContext(combinedContext, statistics);
        }
        this.conditionScope.setContext(combinedContext);
        return combinedContext;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsNaturalJoin(this, arg);
    }
}

