/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueVariableExpression
extends SQLQueryValueExpression {
    @Nullable
    private final SQLQuerySymbolEntry name;
    @NotNull
    private final VariableExpressionKind kind;
    @NotNull
    private final String rawName;

    public SQLQueryValueVariableExpression(@NotNull STMTreeNode syntaxNode, @Nullable SQLQuerySymbolEntry name, @NotNull VariableExpressionKind kind, @NotNull String rawName) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.kind = kind;
        this.rawName = rawName;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.kind == VariableExpressionKind.BATCH_VARIABLE ? this.name.getSymbol() : null;
    }

    @NotNull
    public VariableExpressionKind getKind() {
        return this.kind;
    }

    @NotNull
    public String getRawName() {
        return this.rawName;
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.name != null && this.name.isNotClassified()) {
            this.name.getSymbol().setSymbolClass(this.kind.symbolClass);
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueVariableExpr(this, arg);
    }

    @NotNull
    public String toString() {
        return "Variable[" + String.valueOf((Object)this.kind) + ":" + String.valueOf(this.name) + "]";
    }

    public static enum VariableExpressionKind {
        BATCH_VARIABLE(SQLQuerySymbolClass.SQL_BATCH_VARIABLE),
        CLIENT_VARIABLE(SQLQuerySymbolClass.DBEAVER_VARIABLE),
        CLIENT_PARAMETER(SQLQuerySymbolClass.DBEAVER_PARAMETER);

        public final SQLQuerySymbolClass symbolClass;

        private VariableExpressionKind(SQLQuerySymbolClass symbolClass) {
            this.symbolClass = symbolClass;
        }
    }
}

