/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueMemberExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.utils.Pair;

public class SQLQueryValueColumnReferenceExpression
extends SQLQueryValueExpression {
    private final boolean rowRefAllowed;
    @Nullable
    private final SQLQueryQualifiedName tableName;
    @Nullable
    private final SQLQuerySymbolEntry columnName;
    @Nullable
    private SQLQueryResultColumn column = null;

    public SQLQueryValueColumnReferenceExpression(@NotNull STMTreeNode syntaxNode, boolean rowRefAllowed, @Nullable SQLQueryQualifiedName tableName, @Nullable SQLQuerySymbolEntry columnName) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.rowRefAllowed = rowRefAllowed;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    @Nullable
    public SQLQueryQualifiedName getTableName() {
        return this.tableName;
    }

    @Nullable
    public SQLQuerySymbolEntry getColumnName() {
        return this.columnName;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.columnName == null ? null : this.columnName.getSymbol();
    }

    @Override
    @Nullable
    public SQLQueryResultColumn getColumnIfTrivialExpression() {
        return this.column;
    }

    public static void propagateColumnDefinition(@NotNull SQLQuerySymbolEntry columnName, @Nullable SQLQueryResultColumn resultColumn, @NotNull SQLQueryRecognitionContext statistics) {
        if (resultColumn != null) {
            columnName.setDefinition(resultColumn.symbol.getDefinition());
        } else {
            columnName.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR);
            statistics.appendError(columnName, "Column " + columnName.getName() + " not found");
        }
    }

    @Override
    protected void propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryExprType type;
        SQLQueryResultColumn resultColumn;
        if (this.tableName != null && this.tableName.isNotClassified()) {
            if (this.tableName.invalidPartsCount == 0) {
                SourceResolutionResult rr = context.resolveSource(statistics.getMonitor(), this.tableName.toListOfStrings());
                if (rr != null) {
                    this.tableName.setDefinition(rr);
                    if (this.columnName != null) {
                        resultColumn = rr.source.getResultDataContext().resolveColumn(statistics.getMonitor(), this.columnName.getName());
                        if (resultColumn != null || !rr.source.getResultDataContext().hasUndresolvedSource()) {
                            SQLQueryValueColumnReferenceExpression.propagateColumnDefinition(this.columnName, resultColumn, statistics);
                        }
                        type = resultColumn != null ? resultColumn.type : SQLQueryExprType.UNKNOWN;
                    } else {
                        resultColumn = null;
                        type = SQLQueryExprType.UNKNOWN;
                        statistics.appendError(this.tableName.getSyntaxNode(), "Expected column name after the table reference");
                    }
                } else {
                    resultColumn = null;
                    ArrayList<SQLQuerySymbolEntry> fullName = new ArrayList<SQLQuerySymbolEntry>(this.tableName.scopeName.size() + 2);
                    fullName.addAll(this.tableName.scopeName);
                    fullName.add(this.tableName.entityName);
                    fullName.add(this.columnName);
                    Pair<SQLQueryResultColumn, SQLQueryExprType> columnAndType = SQLQueryValueColumnReferenceExpression.resolveColumn(context, statistics, (SQLQuerySymbolEntry)fullName.get(0), true);
                    SQLQueryExprType memberType = (SQLQueryExprType)columnAndType.getSecond();
                    if (memberType != null) {
                        int i = 1;
                        while (i < fullName.size() && memberType != null) {
                            memberType = SQLQueryValueMemberExpression.tryResolveMemberReference(statistics, memberType, (SQLQuerySymbolEntry)fullName.get(i));
                            ++i;
                        }
                        type = memberType != null ? memberType : SQLQueryExprType.UNKNOWN;
                    } else {
                        if (this.tableName.isNotClassified()) {
                            this.tableName.setSymbolClass(SQLQuerySymbolClass.ERROR);
                        }
                        type = SQLQueryExprType.UNKNOWN;
                        statistics.appendError(this.tableName.entityName, "Table or subquery " + this.tableName.toIdentifierString() + " not found");
                    }
                }
            } else {
                resultColumn = null;
                type = SQLQueryExprType.UNKNOWN;
                statistics.appendError(this.getSyntaxNode(), "Invalid column reference");
            }
        } else if (this.tableName == null && this.columnName != null && this.columnName.isNotClassified()) {
            Pair<SQLQueryResultColumn, SQLQueryExprType> columnAndType = SQLQueryValueColumnReferenceExpression.resolveColumn(context, statistics, this.columnName, this.rowRefAllowed);
            resultColumn = (SQLQueryResultColumn)columnAndType.getFirst();
            type = columnAndType.getSecond() != null ? (SQLQueryExprType)columnAndType.getSecond() : SQLQueryExprType.UNKNOWN;
        } else {
            resultColumn = null;
            type = SQLQueryExprType.UNKNOWN;
        }
        this.column = resultColumn;
        this.type = type;
    }

    private static Pair<SQLQueryResultColumn, SQLQueryExprType> resolveColumn(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics, @NotNull SQLQuerySymbolEntry columnName, boolean rowRefAllowed) {
        SQLQueryExprType type;
        SQLQueryResultColumn resultColumn;
        SQLDialect dialect = context.getDialect();
        SQLQueryResultPseudoColumn pseudoColumn = context.resolveGlobalPseudoColumn(statistics.getMonitor(), columnName.getName());
        if (pseudoColumn == null) {
            pseudoColumn = context.resolvePseudoColumn(statistics.getMonitor(), columnName.getName());
        }
        if (pseudoColumn != null) {
            resultColumn = null;
            type = pseudoColumn.type;
            columnName.setDefinition(pseudoColumn);
        } else {
            SQLQuerySymbolDefinition rowsSourceDef;
            SourceResolutionResult rowsSourceIfAllowed;
            resultColumn = context.resolveColumn(statistics.getMonitor(), columnName.getName());
            SQLQuerySymbolClass forcedClass = null;
            if (resultColumn == null) {
                SQLQueryRowsTableDataModel tableModel;
                SourceResolutionResult sourceResolutionResult = rowsSourceIfAllowed = rowRefAllowed ? context.resolveSource(statistics.getMonitor(), List.of(columnName.getName())) : null;
                rowsSourceDef = rowsSourceIfAllowed != null ? (rowsSourceIfAllowed.aliasOrNull != null ? rowsSourceIfAllowed.aliasOrNull.getDefinition() : (rowsSourceIfAllowed.source instanceof SQLQueryRowsTableDataModel && (tableModel = (SQLQueryRowsTableDataModel)rowsSourceIfAllowed.source).getName() != null ? tableModel.getName().entityName : null)) : null;
                if (rowsSourceDef == null && columnName.isNotClassified()) {
                    String rawString = columnName.getRawName();
                    forcedClass = dialect.isQuotedString(rawString) ? SQLQuerySymbolClass.STRING : SQLQueryModelRecognizer.tryFallbackSymbolForStringLiteral(dialect, columnName, false);
                }
            } else {
                rowsSourceDef = null;
                rowsSourceIfAllowed = null;
            }
            if (rowsSourceDef != null) {
                columnName.setDefinition(rowsSourceDef);
                type = SQLQueryExprType.forReferencedRow(columnName, rowsSourceIfAllowed);
            } else if (forcedClass != null) {
                columnName.getSymbol().setSymbolClass(forcedClass);
                type = forcedClass == SQLQuerySymbolClass.STRING ? SQLQueryExprType.STRING : null;
            } else {
                if (resultColumn != null || !context.hasUndresolvedSource()) {
                    SQLQueryValueColumnReferenceExpression.propagateColumnDefinition(columnName, resultColumn, statistics);
                }
                type = resultColumn != null ? resultColumn.type : null;
            }
        }
        return Pair.of((Object)resultColumn, (Object)type);
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueColumnRefExpr(this, arg);
    }

    public String toString() {
        String columnName = this.columnName == null ? "<NULL>" : this.columnName.getName();
        String name = this.tableName == null ? columnName : this.tableName.toIdentifierString() + "." + columnName;
        String type = this.type == null ? "<NULL>" : this.type.toString();
        return "ColumnReference[" + name + ":" + type + "]";
    }
}

