/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryColumnSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterActionKind;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableAlterActionSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.ddl.SQLQueryTableConstraintSpec;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableAlterModel
extends SQLQueryModelContent {
    private static final Map<String, SQLQueryTableAlterActionKind> alterActionKindByNodeName = Map.of(STMKnownRuleNames.addColumnDefinition, SQLQueryTableAlterActionKind.ADD_COLUMN, STMKnownRuleNames.alterColumnDefinition, SQLQueryTableAlterActionKind.ALTER_COLUMN, STMKnownRuleNames.renameColumnDefinition, SQLQueryTableAlterActionKind.RENAME_COLUMN, STMKnownRuleNames.dropColumnDefinition, SQLQueryTableAlterActionKind.DROP_COLUMN, STMKnownRuleNames.addTableConstraintDefinition, SQLQueryTableAlterActionKind.ADD_TABLE_CONSTRAINT, STMKnownRuleNames.dropTableConstraintDefinition, SQLQueryTableAlterActionKind.DROP_TABLE_CONSTRAINT);
    @Nullable
    private final SQLQueryRowsTableDataModel targetTable;
    @NotNull
    private final List<SQLQueryTableAlterActionSpec> alterActions;
    @Nullable
    private SQLQueryDataContext dataContext = null;

    public SQLQueryTableAlterModel(@NotNull STMTreeNode syntaxNode, @Nullable SQLQueryRowsTableDataModel targetTable, @NotNull List<SQLQueryTableAlterActionSpec> alterActions) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.targetTable = targetTable;
        this.alterActions = List.copyOf(alterActions);
        this.alterActions.forEach(this::registerSubnode);
    }

    @Nullable
    public SQLQueryRowsTableDataModel getTargetTable() {
        return this.targetTable;
    }

    @NotNull
    public List<SQLQueryTableAlterActionSpec> getAlterActions() {
        return this.alterActions;
    }

    @Override
    protected void applyContext(@NotNull SQLQueryDataContext dataContext, @NotNull SQLQueryRecognitionContext statistics) {
        this.dataContext = dataContext;
        if (this.targetTable != null) {
            SQLQueryDataContext tableContext = this.targetTable.propagateContext(dataContext, statistics);
            for (SQLQueryTableAlterActionSpec alterAction : this.alterActions) {
                alterAction.propagateContext(dataContext, this.targetTable.getTable() == null ? null : tableContext, statistics);
            }
        } else {
            statistics.appendWarning(this.getSyntaxNode(), "Missing table name");
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, T arg) {
        return visitor.visitAlterTable(this, arg);
    }

    @Override
    @Nullable
    public SQLQueryDataContext getGivenDataContext() {
        return this.dataContext;
    }

    @Override
    @Nullable
    public SQLQueryDataContext getResultDataContext() {
        return this.dataContext;
    }

    public static SQLQueryTableAlterModel recognize(SQLQueryModelRecognizer recognizer, STMTreeNode node) {
        SQLQueryRowsTableDataModel targetTable = recognizer.collectTableReference(node, true);
        LinkedList<SQLQueryTableAlterActionSpec> alterActions = new LinkedList<SQLQueryTableAlterActionSpec>();
        for (STMTreeNode subnode : node.findChildrenOfName(STMKnownRuleNames.alterTableAction)) {
            STMTreeNode actionNode = subnode.findFirstNonErrorChild();
            if (actionNode == null) continue;
            SQLQueryTableAlterActionKind actionKind = alterActionKindByNodeName.get(actionNode.getNodeName());
            SQLQueryColumnSpec columnSpec = null;
            SQLQuerySymbolEntry columnName = null;
            SQLQueryTableConstraintSpec tableConstraintSpec = null;
            SQLQueryQualifiedName tableConstraintName = null;
            if (actionKind == null) continue;
            switch (actionKind) {
                case ADD_COLUMN: {
                    columnSpec = Optional.ofNullable(actionNode.findFirstChildOfName(STMKnownRuleNames.columnDefinition)).map(n -> SQLQueryColumnSpec.recognize(recognizer, n)).orElse(null);
                    break;
                }
                case ALTER_COLUMN: 
                case RENAME_COLUMN: 
                case DROP_COLUMN: {
                    columnName = Optional.ofNullable(actionNode.findFirstChildOfName(STMKnownRuleNames.columnName)).map(recognizer::collectIdentifier).orElse(null);
                    break;
                }
                case ADD_TABLE_CONSTRAINT: {
                    tableConstraintSpec = Optional.ofNullable(actionNode.findFirstChildOfName(STMKnownRuleNames.tableConstraintDefinition)).map(n -> SQLQueryTableConstraintSpec.recognize(recognizer, n)).orElse(null);
                    break;
                }
                case DROP_TABLE_CONSTRAINT: {
                    tableConstraintName = Optional.ofNullable(actionNode.findFirstChildOfName(STMKnownRuleNames.constraintName)).map(recognizer::collectQualifiedName).orElse(null);
                }
            }
            alterActions.addLast(new SQLQueryTableAlterActionSpec(actionNode, actionKind, columnSpec, columnName, tableConstraintSpec, tableConstraintName));
        }
        return new SQLQueryTableAlterModel(node, targetTable, alterActions);
    }
}

