/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class SQLQueryObjectDataModel
extends SQLQueryRowsSourceModel
implements SQLQuerySymbolDefinition {
    private static final Log log = Log.getLog(SQLQueryObjectDataModel.class);
    @NotNull
    private final SQLQueryQualifiedName name;
    @NotNull
    private DBSObjectType objectType;
    @Nullable
    private DBSObject object = null;

    public SQLQueryObjectDataModel(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryQualifiedName name, @NotNull DBSObjectType objectType) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.name = name;
        this.objectType = objectType;
    }

    @NotNull
    public DBSObjectType getObjectType() {
        return this.objectType;
    }

    @NotNull
    public SQLQueryQualifiedName getName() {
        return this.name;
    }

    @Nullable
    public DBSObject getObject() {
        return this.object;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.object != null ? SQLQuerySymbolClass.TABLE : SQLQuerySymbolClass.ERROR;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.name.isNotClassified()) {
            List<String> nameStrings = this.name.toListOfStrings();
            this.object = context.findRealObject(statistics.getMonitor(), this.objectType, nameStrings);
            if (this.object != null) {
                this.name.setDefinition(this.object);
            } else {
                statistics.appendError(this.getSyntaxNode(), "Object " + this.name.toIdentifierString() + " not found in the database");
            }
        }
        return context;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitObjectReference(this, arg);
    }
}

