/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;

public abstract class SQLQueryCompletionItem {
    private final int score;
    @NotNull
    private final SQLQueryWordEntry filterKey;

    private SQLQueryCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey) {
        this.score = score;
        this.filterKey = filterKey;
    }

    public int getScore() {
        return this.score;
    }

    @NotNull
    public SQLQueryWordEntry getFilterInfo() {
        return this.filterKey;
    }

    @NotNull
    public abstract SQLQueryCompletionItemKind getKind();

    @Nullable
    public DBSObject getObject() {
        return null;
    }

    public final <R> R apply(SQLQueryCompletionItemVisitor<R> visitor) {
        return this.applyImpl(visitor);
    }

    protected abstract <R> R applyImpl(SQLQueryCompletionItemVisitor<R> var1);

    @NotNull
    public static SQLQueryCompletionItem forReservedWord(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull String text) {
        return new SQLReservedWordCompletionItem(score, filterKey, text);
    }

    @NotNull
    public static SQLQueryCompletionItem forRowsSourceAlias(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLQuerySymbol aliasSymbol, @NotNull SourceResolutionResult source) {
        return new SQLRowsSourceAliasCompletionItem(score, filterKey, aliasSymbol, source);
    }

    @NotNull
    public static SQLQueryCompletionItem forRealTable(int score, @NotNull SQLQueryWordEntry filterKey, @Nullable ContextObjectInfo resolvedContext, @NotNull DBSEntity table, boolean isUsed) {
        return new SQLTableNameCompletionItem(score, filterKey, resolvedContext, table, isUsed);
    }

    @NotNull
    public static SQLColumnNameCompletionItem forSubsetColumn(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLQueryResultColumn columnInfo, @Nullable SourceResolutionResult sourceInfo, boolean absolute) {
        return new SQLColumnNameCompletionItem(score, filterKey, columnInfo, sourceInfo, absolute);
    }

    @NotNull
    public static SQLQueryCompletionItem forDbObject(int score, @NotNull SQLQueryWordEntry filterKey, @Nullable ContextObjectInfo resolvedContext, @NotNull DBSObject object) {
        return new SQLDbNamedObjectCompletionItem(score, filterKey, resolvedContext, object);
    }

    public static SQLQueryCompletionItem forJoinCondition(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLColumnNameCompletionItem first, @NotNull SQLColumnNameCompletionItem second) {
        return new SQLJoinConditionCompletionItem(score, filterKey, first, second);
    }

    public static List<String> prepareQualifiedNameParts(@NotNull DBSObject object, @Nullable DBSObject knownSubroot) {
        LinkedList<String> parts = new LinkedList<String>();
        parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)object));
        DBSObject o = object.getParentObject();
        while (o != knownSubroot) {
            if (o instanceof DBSStructContainer) {
                parts.addFirst(DBUtils.getQuotedIdentifier((DBSObject)o));
            }
            o = o.getParentObject();
        }
        return parts;
    }

    public record ContextObjectInfo(@NotNull String string, @NotNull DBSObject object) {
    }

    public static class SQLColumnNameCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final SQLQueryResultColumn columnInfo;
        @Nullable
        public final SourceResolutionResult sourceInfo;
        public final boolean absolute;

        SQLColumnNameCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLQueryResultColumn columnInfo, @Nullable SourceResolutionResult sourceInfo, boolean absolute) {
            super(score, filterKey);
            if (columnInfo == null) {
                throw new IllegalArgumentException("columnInfo should not be null");
            }
            this.columnInfo = columnInfo;
            this.sourceInfo = sourceInfo;
            this.absolute = absolute;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.columnInfo.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED ? SQLQueryCompletionItemKind.DERIVED_COLUMN_NAME : SQLQueryCompletionItemKind.TABLE_COLUMN_NAME;
        }

        @Override
        @Nullable
        public DBSObject getObject() {
            return this.columnInfo.realAttr;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitColumnName(this);
        }
    }

    public static class SQLDbNamedObjectCompletionItem
    extends SQLDbObjectCompletionItem<DBSObject> {
        SQLDbNamedObjectCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @Nullable ContextObjectInfo resolvedContext, @NotNull DBSObject object) {
            super(score, filterKey, resolvedContext, object);
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.UNKNOWN;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitNamedObject(this);
        }
    }

    public static abstract class SQLDbObjectCompletionItem<T extends DBSObject>
    extends SQLQueryCompletionItem {
        @Nullable
        public final ContextObjectInfo resolvedContext;
        @NotNull
        public final T object;

        SQLDbObjectCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @Nullable ContextObjectInfo resolvedContext, @NotNull T object) {
            super(score, filterKey);
            this.resolvedContext = resolvedContext;
            this.object = object;
        }

        @Override
        @NotNull
        public DBSObject getObject() {
            return this.object;
        }
    }

    public static class SQLJoinConditionCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final SQLColumnNameCompletionItem left;
        @NotNull
        public final SQLColumnNameCompletionItem right;

        SQLJoinConditionCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLColumnNameCompletionItem left, @NotNull SQLColumnNameCompletionItem right) {
            super(score, filterKey);
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.JOIN_CONDITION;
        }

        @Override
        protected <R> R applyImpl(@NotNull SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitJoinCondition(this);
        }
    }

    public static class SQLReservedWordCompletionItem
    extends SQLQueryCompletionItem {
        public final String text;

        SQLReservedWordCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull String text) {
            super(score, filterKey);
            this.text = text;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.RESERVED;
        }

        @Override
        protected <R> R applyImpl(@NotNull SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitReservedWord(this);
        }
    }

    public static class SQLRowsSourceAliasCompletionItem
    extends SQLQueryCompletionItem {
        @NotNull
        public final SQLQuerySymbol symbol;
        @NotNull
        public final SourceResolutionResult sourceInfo;

        SQLRowsSourceAliasCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @NotNull SQLQuerySymbol symbol, @NotNull SourceResolutionResult sourceInfo) {
            super(score, filterKey);
            this.symbol = symbol;
            this.sourceInfo = sourceInfo;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return SQLQueryCompletionItemKind.SUBQUERY_ALIAS;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitSubqueryAlias(this);
        }
    }

    public static class SQLTableNameCompletionItem
    extends SQLDbObjectCompletionItem<DBSEntity> {
        public final boolean isUsed;

        SQLTableNameCompletionItem(int score, @NotNull SQLQueryWordEntry filterKey, @Nullable ContextObjectInfo resolvedContext, @NotNull DBSEntity table, boolean isUsed) {
            super(score, filterKey, resolvedContext, table);
            this.isUsed = isUsed;
        }

        @Override
        @NotNull
        public SQLQueryCompletionItemKind getKind() {
            return this.isUsed ? SQLQueryCompletionItemKind.USED_TABLE_NAME : SQLQueryCompletionItemKind.NEW_TABLE_NAME;
        }

        @Override
        protected <R> R applyImpl(SQLQueryCompletionItemVisitor<R> visitor) {
            return visitor.visitTableName(this);
        }
    }
}

