/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSearchUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLScriptItemAtOffset;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionSet;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryCombinedContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModel;
import org.jkiss.dbeaver.model.stm.LSMInspections;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermErrorNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.utils.Pair;

public abstract class SQLQueryCompletionContext {
    private static final Log log = Log.getLog(SQLQueryCompletionContext.class);
    private static final Set<String> statementStartKeywords = LSMInspections.prepareOffquerySyntaxInspection().predictedWords();
    private static final int statementStartKeywordMaxLength = statementStartKeywords.stream().mapToInt(String::length).max().orElse(0);
    private static final Set<SQLQuerySymbolClass> potentialKeywordPartClassification = Set.of(SQLQuerySymbolClass.UNKNOWN, SQLQuerySymbolClass.ERROR, SQLQuerySymbolClass.RESERVED);
    private final int scriptItemOffset;
    private final int requestOffset;
    protected boolean searchInsideWords;

    public static int getMaxKeywordLength() {
        return statementStartKeywordMaxLength;
    }

    public static SQLQueryCompletionContext prepareEmpty(int scriptItemOffset, int requestOffset) {
        return new SQLQueryCompletionContext(0, requestOffset){

            @Override
            @Nullable
            public SQLQueryDataContext getDataContext() {
                return null;
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return LSMInspections.SyntaxInspectionResult.EMPTY;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                return List.of(new SQLQueryCompletionSet(this.getRequestOffset(), 0, Collections.emptyList()));
            }
        };
    }

    @NotNull
    public static SQLQueryCompletionContext prepareOffquery(final int scriptItemOffset, int requestOffset) {
        return new SQLQueryCompletionContext(scriptItemOffset, requestOffset){
            private static final LSMInspections.SyntaxInspectionResult syntaxInspectionResult = LSMInspections.prepareOffquerySyntaxInspection();
            private static final Pattern KEYWORD_FILTER_PATTERN = Pattern.compile("([a-zA-Z0-9]+)");

            @Override
            @Nullable
            public SQLQueryDataContext getDataContext() {
                return null;
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                String lineText;
                int lineStartOffset;
                try {
                    IDocument doc = request.getDocument();
                    IRegion lineInfo = doc.getLineInformationOfOffset(this.getRequestOffset());
                    lineStartOffset = lineInfo.getOffset();
                    lineText = doc.get(lineStartOffset, lineInfo.getLength());
                }
                catch (BadLocationException badLocationException) {
                    lineStartOffset = -1;
                    lineText = "";
                }
                Matcher m = KEYWORD_FILTER_PATTERN.matcher(lineText);
                SQLQueryWordEntry filter = null;
                if (m.find() && lineStartOffset >= 0) {
                    MatchResult mr = m.toMatchResult();
                    int inLineOffset = this.getRequestOffset() - lineStartOffset;
                    int i = 0;
                    while (i < mr.groupCount()) {
                        int start = mr.start(i);
                        int end = mr.end(i);
                        if (start <= inLineOffset && end >= inLineOffset) {
                            String filterKeyString = lineText.substring(m.start(), m.end()).toLowerCase();
                            int filterStart = start + lineStartOffset - scriptItemOffset;
                            filter = new SQLQueryWordEntry(filterStart, filterKeyString);
                            break;
                        }
                        ++i;
                    }
                }
                SQLQueryCompletionSet keywordCompletions = this.prepareKeywordCompletions(statementStartKeywords, filter);
                return List.of(keywordCompletions);
            }
        };
    }

    private SQLQueryCompletionContext(int scriptItemOffset, int requestOffset) {
        this.scriptItemOffset = scriptItemOffset;
        this.requestOffset = requestOffset;
    }

    public int getOffset() {
        return this.scriptItemOffset;
    }

    public int getRequestOffset() {
        return this.requestOffset;
    }

    @Nullable
    public abstract SQLQueryDataContext getDataContext();

    @NotNull
    public abstract LSMInspections.SyntaxInspectionResult getInspectionResult();

    @NotNull
    public Set<String> getAliasesInUse() {
        return Collections.emptySet();
    }

    @NotNull
    public Set<DBSObjectContainer> getExposedContexts() {
        return Collections.emptySet();
    }

    @NotNull
    public List<? extends SQLQueryCompletionItem> prepareCurrentTupleColumns() {
        return Collections.emptyList();
    }

    @NotNull
    public abstract Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor var1, @NotNull SQLCompletionRequest var2);

    @NotNull
    protected SQLQueryWordEntry makeFilterInfo(@Nullable SQLQueryWordEntry filterKey, @NotNull String filterString) {
        return new SQLQueryWordEntry(filterKey == null ? -1 : this.getOffset() + filterKey.offset, filterString);
    }

    public static SQLQueryCompletionContext prepare(final @NotNull SQLScriptItemAtOffset scriptItem, final int requestOffset, final @Nullable DBCExecutionContext dbcExecutionContext, final @NotNull LSMInspections.SyntaxInspectionResult syntaxInspectionResult, final @NotNull SQLQueryModel.LexicalContextResolutionResult context, final @Nullable SQLQueryLexicalScopeItem lexicalItem, final @NotNull STMTreeNode[] nameNodes, final boolean hasPeriod, final @Nullable STMTreeNode currentTerm) {
        return new SQLQueryCompletionContext(scriptItem.offset, requestOffset){
            private final Set<DBSObjectContainer> exposedContexts;
            private final SQLQueryDataContext.KnownSourcesInfo knownSources;
            {
                super($anonymous0, $anonymous1);
                this.exposedContexts = SQLQueryCompletionContext.obtainExposedContexts(dBCExecutionContext);
                this.knownSources = lexicalContextResolutionResult.deepestContext().collectKnownSources();
            }

            @Override
            @NotNull
            public SQLQueryDataContext getDataContext() {
                return context.deepestContext();
            }

            @Override
            @NotNull
            public LSMInspections.SyntaxInspectionResult getInspectionResult() {
                return syntaxInspectionResult;
            }

            @Override
            @NotNull
            public Set<String> getAliasesInUse() {
                return context.nearestResultContext().collectKnownSources().getAliasesInUse();
            }

            @Override
            @NotNull
            public Set<DBSObjectContainer> getExposedContexts() {
                return this.exposedContexts;
            }

            @Override
            @NotNull
            public Collection<SQLQueryCompletionSet> prepareProposal(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request) {
                SQLQueryCompletionSet tableRefCompletions;
                this.searchInsideWords = request.getContext().isSearchInsideNames();
                int position = this.getRequestOffset() - this.getOffset();
                SQLQueryWordEntry currentWord = this.obtainCurrentWord(currentTerm, position);
                List<SQLQueryWordEntry> parts = this.obtainIdentifierParts(position);
                boolean keywordsAllowed = (lexicalItem == null || potentialKeywordPartClassification.contains((Object)lexicalItem.getSymbolClass())) && !hasPeriod;
                SQLQueryCompletionSet keywordCompletions = keywordsAllowed ? this.prepareKeywordCompletions(syntaxInspectionResult.predictedWords(), currentWord) : null;
                SQLQueryCompletionSet columnRefCompletions = (syntaxInspectionResult.expectingColumnName() || syntaxInspectionResult.expectingColumnReference()) && nameNodes.length == 0 ? this.prepareColumnCompletions(monitor, null) : null;
                SQLQueryCompletionSet sQLQueryCompletionSet = tableRefCompletions = syntaxInspectionResult.expectingTableReference() && nameNodes.length == 0 ? this.prepareTableCompletions(monitor, request, null) : null;
                SQLQueryCompletionSet lexicalItemCompletions = lexicalItem != null ? this.prepareLexicalItemCompletions(monitor, request, lexicalItem, position) : (syntaxInspectionResult.expectingIdentifier() || nameNodes.length > 0 && (parts.size() > 1 || parts.size() == 1 && parts.get(0) != null) ? this.prepareInspectedIdentifierCompletions(monitor, request, parts) : null);
                List<SQLQueryCompletionSet> completionSets = Stream.of(columnRefCompletions, tableRefCompletions, lexicalItemCompletions, keywordCompletions).filter(s -> s != null && s.getItems().size() > 0).collect(Collectors.toList());
                return completionSets;
            }

            @Nullable
            private SQLQueryWordEntry obtainCurrentWord(STMTreeNode currentTerm2, int position) {
                block4: {
                    Interval wordRange;
                    block6: {
                        block5: {
                            if (currentTerm2 == null) {
                                return null;
                            }
                            wordRange = currentTerm2.getRealInterval();
                            if (wordRange.b < position - 1) break block4;
                            if (!(currentTerm2 instanceof STMTreeTermNode)) break block5;
                            STMTreeTermNode t = (STMTreeTermNode)currentTerm2;
                            if (t.symbol.getType() != 176) break block6;
                        }
                        if (!(currentTerm2 instanceof STMTreeTermErrorNode)) break block4;
                    }
                    return new SQLQueryWordEntry(wordRange.a, currentTerm2.getTextContent().substring(0, position - currentTerm2.getRealInterval().a));
                }
                return null;
            }

            @Nullable
            private SQLQueryCompletionSet prepareInspectedIdentifierCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull List<SQLQueryWordEntry> parts) {
                String[][] quoteStrs;
                List<SQLQueryWordEntry> prefix = parts.subList(0, parts.size() - 1);
                SQLQueryWordEntry tail = parts.get(parts.size() - 1);
                if (tail != null && (quoteStrs = request.getContext().getDataSource().getSQLDialect().getIdentifierQuoteStrings()).length > 0) {
                    String qp = Stream.of(quoteStrs).flatMap(ss -> Stream.of(ss)).map(Pattern::quote).distinct().collect(Collectors.joining("|"));
                    tail = new SQLQueryWordEntry(tail.offset, tail.string.replaceAll(qp, ""));
                }
                SQLQueryCompletionSet result = syntaxInspectionResult.expectingColumnReference() || syntaxInspectionResult.expectingColumnName() ? this.accomplishColumnReference(monitor, prefix, tail) : (syntaxInspectionResult.expectingTableReference() ? this.accomplishTableReference(monitor, request, prefix, tail) : null);
                return result;
            }

            @Nullable
            private SQLQueryCompletionSet accomplishTableReference(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail) {
                if (dbcExecutionContext == null || dbcExecutionContext.getDataSource() == null || !DBStructUtils.isConnectedContainer((DBPObject)dbcExecutionContext.getDataSource())) {
                    return null;
                }
                if (prefix.isEmpty()) {
                    return this.prepareTableCompletions(monitor, request, tail);
                }
                List<String> contextName = prefix.stream().map(e -> e.string).collect(Collectors.toList());
                DBSObject prefixContext = SQLSearchUtils.findObjectByFQN(monitor, (DBSObjectContainer)dbcExecutionContext.getDataSource(), dbcExecutionContext, contextName, false, request.getWordDetector());
                LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
                if (prefixContext instanceof DBSObjectContainer) {
                    DBSObjectContainer container = (DBSObjectContainer)prefixContext;
                    SQLQueryCompletionItem.ContextObjectInfo contextObject = this.prepareContextInfo(request, prefix, tail, prefixContext);
                    try {
                        this.collectTables(monitor, container, contextObject, tail, items);
                        this.collectContextSchemasAndCatalogs(monitor, List.of(container), contextObject, tail, items);
                    }
                    catch (DBException e2) {
                        log.error((Object)e2);
                    }
                }
                return this.makeFilteredCompletionSet(prefix.isEmpty() ? tail : prefix.get(0), items);
            }

            @NotNull
            private SQLQueryCompletionSet accomplishColumnReference(@NotNull DBRProgressMonitor monitor, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail) {
                if (prefix.size() > 0) {
                    ArrayList<Function<SourceResolutionResult, Integer>> sourcePredicates = new ArrayList<Function<SourceResolutionResult, Integer>>(5);
                    List<String> tableName = prefix.stream().map(w -> w.string).toList();
                    SourceResolutionResult referencedSource = this.getDataContext().resolveSource(monitor, tableName);
                    if (prefix.size() == 1) {
                        SQLQueryWordEntry mayBeAliasName = prefix.get(0);
                        sourcePredicates.add(srr -> srr.aliasOrNull == null ? 0 : SQLQueryWordEntry.matches(srr.aliasOrNull.getName().toLowerCase(), mayBeAliasName, this.searchInsideWords));
                    }
                    sourcePredicates.add(srr -> {
                        if (srr.tableOrNull != null) {
                            List<String> parts = SQLQueryCompletionItem.prepareQualifiedNameParts((DBSObject)srr.tableOrNull, null);
                            int partsMatched = 0;
                            int totalScore = 0;
                            int i = prefix.size() - 1;
                            int j = parts.size() - 1;
                            while (i >= 0 && j >= 0) {
                                int score = SQLQueryWordEntry.matches(parts.get(j).toLowerCase(), (SQLQueryWordEntry)prefix.get(i), this.searchInsideWords);
                                if (score == Integer.MAX_VALUE) {
                                    ++partsMatched;
                                } else {
                                    totalScore += score;
                                }
                                --i;
                                --j;
                            }
                            return partsMatched == prefix.size() && totalScore == 0 ? Integer.MAX_VALUE : totalScore;
                        }
                        return 0;
                    });
                    LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem> items = new LinkedList<SQLQueryCompletionItem.SQLColumnNameCompletionItem>();
                    for (SourceResolutionResult rr : this.knownSources.getResolutionResults().values()) {
                        boolean isGlobal;
                        int prefixScore = sourcePredicates.stream().mapToInt(p -> (Integer)p.apply(rr)).max().orElse(0);
                        boolean bl = isGlobal = referencedSource != null && rr.source == referencedSource.source;
                        if (prefixScore <= 0) continue;
                        for (SQLQueryResultColumn c : rr.source.getResultDataContext().getColumnsList()) {
                            SQLQueryWordEntry key = this.makeFilterInfo(tail, c.symbol.getName());
                            int nameScore = key.matches(tail, this.searchInsideWords);
                            if (nameScore <= 0) continue;
                            int totalScore = prefixScore == Integer.MAX_VALUE ? nameScore : prefixScore + nameScore;
                            items.addLast(SQLQueryCompletionItem.forSubsetColumn(totalScore, key, c, rr, isGlobal));
                        }
                    }
                    return this.makeFilteredCompletionSet(prefix.get(0), items);
                }
                return this.prepareColumnCompletions(monitor, tail);
            }

            @Nullable
            private SQLQueryCompletionSet prepareObjectComponentCompletions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull SQLQueryWordEntry componentNamePart, @NotNull List<Class<? extends DBSObject>> componentTypes) {
                return this.prepareObjectComponentCompletions(monitor, object, componentNamePart, componentTypes, (r, e, o) -> SQLQueryCompletionItem.forDbObject(r, e, null, o));
            }

            @Nullable
            private <T extends DBSObject> SQLQueryCompletionSet prepareObjectComponentCompletions(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @Nullable SQLQueryWordEntry componentNamePart, @NotNull List<Class<? extends T>> componentTypes, CompletionItemProducer<T> queryCompletionItemProvider) {
                try {
                    DBSObjectContainer container;
                    DBSEntity entity;
                    List attrs;
                    Collection<Object> components = object instanceof DBSEntity ? ((attrs = (entity = (DBSEntity)object).getAttributes(monitor)) != null ? attrs : Collections.emptyList()) : (object instanceof DBSObjectContainer && DBStructUtils.isConnectedContainer((DBPObject)(container = (DBSObjectContainer)object)) ? container.getChildren(monitor) : Collections.emptyList());
                    LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
                    for (DBSObject o : components) {
                        SQLQueryWordEntry filter;
                        int score;
                        if (!componentTypes.stream().anyMatch(t -> t.isInstance(o)) || (score = (filter = this.makeFilterInfo(componentNamePart, o.getName())).matches(componentNamePart, this.searchInsideWords)) <= 0) continue;
                        items.addLast(queryCompletionItemProvider.produce(score, filter, o));
                    }
                    return this.makeFilteredCompletionSet(componentNamePart, items);
                }
                catch (DBException ex) {
                    log.error((Object)ex);
                    return null;
                }
            }

            private List<SQLQueryWordEntry> obtainIdentifierParts(int position) {
                ArrayList<SQLQueryWordEntry> parts = new ArrayList<SQLQueryWordEntry>(nameNodes.length);
                int i = 0;
                while (i < nameNodes.length) {
                    block5: {
                        STMTreeNode term;
                        block4: {
                            block3: {
                                term = nameNodes[i];
                                if (!(term instanceof STMTreeTermNode)) break block3;
                                STMTreeTermNode t = (STMTreeTermNode)term;
                                if (t.symbol.getType() != 176) break block4;
                            }
                            if (!(term instanceof STMTreeTermErrorNode)) break block5;
                        }
                        if (term.getRealInterval().b + 1 >= position) break;
                        parts.add(new SQLQueryWordEntry(term.getRealInterval().a, term.getTextContent()));
                    }
                    ++i;
                }
                STMTreeNode currentNode = i >= nameNodes.length ? null : nameNodes[i];
                String currentPart = currentNode == null ? null : currentNode.getTextContent().substring(0, position - currentNode.getRealInterval().a);
                parts.add(currentPart == null ? null : new SQLQueryWordEntry(currentNode.getRealInterval().a, currentPart));
                return parts;
            }

            private SQLQuerySymbolDefinition unrollSymbolDefinition(SQLQuerySymbolDefinition def) {
                while (def instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)def;
                    def = entry.getDefinition();
                }
                return def;
            }

            @Nullable
            private SQLQueryCompletionSet prepareLexicalItemCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @NotNull SQLQueryLexicalScopeItem lexicalItem2, int position) {
                Interval pos = Interval.of((int)position, (int)position);
                if (lexicalItem2 instanceof SQLQueryQualifiedName) {
                    Interval catalogRange;
                    Interval schemaRange;
                    SQLQueryQualifiedName qname = (SQLQueryQualifiedName)lexicalItem2;
                    SQLQuerySymbolEntry schemaName = qname.scopeName.size() <= 0 ? null : qname.scopeName.get(qname.scopeName.size() - 1);
                    SQLQuerySymbolEntry catalogName = qname.scopeName.size() <= 1 ? null : qname.scopeName.get(qname.scopeName.size() - 2);
                    Interval nameRange = qname.entityName.getSyntaxNode().getRealInterval();
                    if (nameRange.properlyContains(pos)) {
                        SQLQueryWordEntry part = new SQLQueryWordEntry(qname.entityName.getInterval().a, qname.entityName.getRawName().substring(0, position - nameRange.a));
                        if (schemaName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(schemaName.getDefinition());
                            if (scopeDef instanceof SQLQuerySymbolByDbObjectDefinition) {
                                SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)scopeDef;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, List.of(DBSEntity.class));
                            }
                            return null;
                        }
                        return this.prepareInspectedIdentifierCompletions(monitor, request, List.of(part));
                    }
                    if (schemaName != null && (schemaRange = schemaName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        SQLQueryWordEntry part = new SQLQueryWordEntry(schemaName.getInterval().a, schemaName.getRawName().substring(0, position - schemaRange.a));
                        if (catalogName != null) {
                            SQLQuerySymbolDefinition scopeDef = this.unrollSymbolDefinition(schemaName.getDefinition());
                            if (scopeDef instanceof SQLQuerySymbolByDbObjectDefinition) {
                                SQLQuerySymbolByDbObjectDefinition byObjDef = (SQLQuerySymbolByDbObjectDefinition)scopeDef;
                                return this.prepareObjectComponentCompletions(monitor, byObjDef.getDbObject(), part, List.of(DBSSchema.class));
                            }
                            return null;
                        }
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, List.of(DBSSchema.class));
                    }
                    if (catalogName != null && (catalogRange = catalogName.getSyntaxNode().getRealInterval()).properlyContains(pos)) {
                        SQLQueryWordEntry part = new SQLQueryWordEntry(catalogName.getInterval().a, catalogName.getRawName().substring(0, position - catalogRange.a));
                        return this.prepareObjectComponentCompletions(monitor, (DBSObject)dbcExecutionContext.getDataSource(), part, List.of(DBSCatalog.class));
                    }
                    throw new UnsupportedOperationException("Illegal SQLQueryQualifiedName");
                }
                if (lexicalItem2 instanceof SQLQuerySymbolEntry) {
                    SQLQuerySymbolEntry entry = (SQLQuerySymbolEntry)lexicalItem2;
                    Interval nameRange = entry.getSyntaxNode().getRealInterval();
                    SQLQueryWordEntry part = new SQLQueryWordEntry(entry.getInterval().a, entry.getRawName().substring(0, position - nameRange.a));
                    return this.prepareInspectedIdentifierCompletions(monitor, request, List.of(part));
                }
                throw new UnsupportedOperationException("Unexpected lexical item kind to complete " + lexicalItem2.getClass().getName());
            }

            private List<SQLQueryCompletionItem> prepareJoinConditionCompletions(@NotNull DBRProgressMonitor monitor, @Nullable SQLQueryWordEntry filterOrNull) {
                SQLQueryCombinedContext joinContext;
                SQLQueryDataContext sQLQueryDataContext;
                LinkedList<SQLQueryCompletionItem> result = new LinkedList<SQLQueryCompletionItem>();
                if (this.knownSources.getReferencedTables().size() > 1 && this.knownSources.getResolutionResults().size() > 1 && (sQLQueryDataContext = context.deepestContext()) instanceof SQLQueryCombinedContext && (joinContext = (SQLQueryCombinedContext)sQLQueryDataContext).isJoin()) {
                    class AssociationsResolutionContext {
                        public final Map<DBSEntityAttribute, List<SQLQueryCompletionItem.SQLColumnNameCompletionItem>> realColumnRefsByEntityAttribute;
                        private final Map<DBSEntity, Map<DBSEntityAttribute, List<DBSEntityAttribute>>> associatedAttrsByEntity;
                        private final /* synthetic */ SQLQueryWordEntry val$filterOrNull;
                        private final /* synthetic */ DBRProgressMonitor val$monitor;

                        AssociationsResolutionContext(SQLQueryWordEntry sQLQueryWordEntry, SQLQueryModel.LexicalContextResolutionResult lexicalContextResolutionResult, DBRProgressMonitor dBRProgressMonitor) {
                            this.val$filterOrNull = sQLQueryWordEntry;
                            this.val$monitor = dBRProgressMonitor;
                            this.realColumnRefsByEntityAttribute = lexicalContextResolutionResult.deepestContext().getColumnsList().stream().filter(rc -> rc.realAttr != null && rc.realAttr.getParentObject() == rc.realSource).collect(Collectors.groupingBy(rc -> rc.realAttr)).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, g -> ((List)g.getValue()).stream().map(rc -> {
                                SQLQueryWordEntry word = this.makeFilterInfo(null, rc.symbol.getName());
                                int score = word.matches(sQLQueryWordEntry, searchInsideWords);
                                return SQLQueryCompletionItem.forSubsetColumn(score, word, rc, knownSources.getResolutionResults().get(rc.source), false);
                            }).toList()));
                            this.associatedAttrsByEntity = new HashMap<DBSEntity, Map<DBSEntityAttribute, List<DBSEntityAttribute>>>();
                        }

                        public List<DBSEntityAttribute> findAssociations(DBSEntityAttribute key) {
                            return Optional.ofNullable((List)this.associatedAttrsByEntity.computeIfAbsent(key.getParentObject(), this::prepareAllAssociations).get(key)).orElse(Collections.emptyList());
                        }

                        private Map<DBSEntityAttribute, List<DBSEntityAttribute>> prepareAllAssociations(DBSEntity entity) {
                            try {
                                return Stream.concat(Optional.ofNullable(entity.getAssociations(this.val$monitor)).stream().flatMap(Collection::stream).filter(a -> knownSources.getReferencedTables().contains(a.getAssociatedEntity())), Optional.ofNullable(entity.getReferences(this.val$monitor)).stream().flatMap(Collection::stream).filter(r -> knownSources.getReferencedTables().contains(r.getParentObject()))).filter(c -> c instanceof DBSTableForeignKey).map(c -> {
                                    try {
                                        return ((DBSTableForeignKey)c).getAttributeReferences((DBRProgressMonitor)new VoidProgressMonitor());
                                    }
                                    catch (DBException dBException) {
                                        return null;
                                    }
                                }).filter(aa -> aa != null && aa.size() == 1 && aa.get(0) instanceof DBSTableForeignKeyColumn).map(aa -> (DBSTableForeignKeyColumn)aa.get(0)).map(attrRef -> {
                                    DBSEntityAttribute sourceAttr = attrRef.getAttribute();
                                    DBSEntityAttribute targetAttr = attrRef.getReferencedColumn();
                                    if (targetAttr != null && sourceAttr != null) {
                                        if (sourceAttr.getParentObject() == entity) {
                                            return Pair.of((Object)sourceAttr, (Object)targetAttr);
                                        }
                                        return Pair.of((Object)targetAttr, (Object)sourceAttr);
                                    }
                                    return null;
                                }).filter(Objects::nonNull).collect(Collectors.groupingBy(Pair::getFirst, Collectors.mapping(Pair::getSecond, Collectors.toList())));
                            }
                            catch (DBException dBException) {
                                return Collections.emptyMap();
                            }
                        }
                    }
                    AssociationsResolutionContext associations = new AssociationsResolutionContext(filterOrNull, context, monitor);
                    for (SQLQueryResultColumn joinedColumn : joinContext.getRightParent().getColumnsList()) {
                        if (joinedColumn.realAttr == null) continue;
                        for (DBSEntityAttribute otherColumnAttribute : associations.findAssociations(joinedColumn.realAttr)) {
                            List<SQLQueryCompletionItem.SQLColumnNameCompletionItem> otherColumnRefs = associations.realColumnRefsByEntityAttribute.get(otherColumnAttribute);
                            if (otherColumnRefs == null) continue;
                            for (SQLQueryCompletionItem.SQLColumnNameCompletionItem thisColumnRef : associations.realColumnRefsByEntityAttribute.get(joinedColumn.realAttr)) {
                                if (thisColumnRef.columnInfo != joinedColumn) continue;
                                for (SQLQueryCompletionItem.SQLColumnNameCompletionItem otherColumnRef : otherColumnRefs) {
                                    int thisScore = thisColumnRef.getScore();
                                    int otherScore = otherColumnRef.getScore();
                                    if (thisScore <= 0 && otherScore <= 0) continue;
                                    int score = thisScore >= otherScore ? thisScore : otherScore;
                                    SQLQueryWordEntry word = (thisScore >= otherScore ? thisColumnRef : otherColumnRef).getFilterInfo();
                                    result.addLast(SQLQueryCompletionItem.forJoinCondition(score, word, thisColumnRef, otherColumnRef));
                                }
                            }
                        }
                    }
                }
                return result;
            }

            @NotNull
            private SQLQueryCompletionSet prepareColumnCompletions(@NotNull DBRProgressMonitor monitor, @Nullable SQLQueryWordEntry filterOrNull) {
                List<? extends SQLQueryCompletionItem> subsetColumns = this.prepareCurrentTupleColumns(filterOrNull);
                LinkedList<SQLQueryCompletionItem> tableRefs = new LinkedList<SQLQueryCompletionItem>();
                if (syntaxInspectionResult.expectingColumnReference()) {
                    for (SourceResolutionResult rr : this.knownSources.getResolutionResults().values()) {
                        SQLQueryWordEntry tableName;
                        int score;
                        if (rr.aliasOrNull != null && !rr.isCteSubquery) {
                            SQLQueryWordEntry sourceAlias = this.makeFilterInfo(filterOrNull, rr.aliasOrNull.getName());
                            score = sourceAlias.matches(filterOrNull, this.searchInsideWords);
                            if (score <= 0) continue;
                            tableRefs.add(SQLQueryCompletionItem.forRowsSourceAlias(score, sourceAlias, rr.aliasOrNull, rr));
                            continue;
                        }
                        if (rr.tableOrNull == null || (score = (tableName = this.makeFilterInfo(filterOrNull, rr.tableOrNull.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                        tableRefs.add(SQLQueryCompletionItem.forRealTable(score, tableName, null, rr.tableOrNull, true));
                    }
                }
                List joinConditions = syntaxInspectionResult.expectingJoinCondition() ? this.prepareJoinConditionCompletions(monitor, filterOrNull) : Collections.emptyList();
                return this.makeFilteredCompletionSet(filterOrNull, Stream.of(subsetColumns, tableRefs, joinConditions).flatMap(Collection::stream).toList());
            }

            @Override
            @NotNull
            public List<? extends SQLQueryCompletionItem> prepareCurrentTupleColumns() {
                return this.prepareCurrentTupleColumns(null);
            }

            @NotNull
            private List<? extends SQLQueryCompletionItem> prepareCurrentTupleColumns(@Nullable SQLQueryWordEntry filterOrNull) {
                Stream<SQLQueryCompletionItem.SQLColumnNameCompletionItem> subsetColumns = context.deepestContext().getColumnsList().stream().map(rc -> {
                    SQLQueryWordEntry filterKey = this.makeFilterInfo(filterOrNull, rc.symbol.getName());
                    int score = filterKey.matches(filterOrNull, this.searchInsideWords);
                    return score <= 0 ? null : SQLQueryCompletionItem.forSubsetColumn(score, filterKey, rc, this.knownSources.getResolutionResults().get(rc.source), false);
                }).filter(Objects::nonNull);
                return subsetColumns.toList();
            }

            @NotNull
            private SQLQueryCompletionSet prepareTableCompletions(@NotNull DBRProgressMonitor monitor, @NotNull SQLCompletionRequest request, @Nullable SQLQueryWordEntry filterOrNull) {
                LinkedList<SQLQueryCompletionItem> completions = new LinkedList<SQLQueryCompletionItem>();
                for (SourceResolutionResult rr : this.knownSources.getResolutionResults().values()) {
                    SQLQueryWordEntry aliasName;
                    int score;
                    if (rr.aliasOrNull == null || !rr.isCteSubquery || (score = (aliasName = this.makeFilterInfo(filterOrNull, rr.aliasOrNull.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                    completions.add(SQLQueryCompletionItem.forRowsSourceAlias(score, aliasName, rr.aliasOrNull, rr));
                }
                if (dbcExecutionContext != null) {
                    try {
                        DBCExecutionContextDefaults defaults = dbcExecutionContext.getContextDefaults();
                        if (defaults != null) {
                            DBPDataSource dBPDataSource;
                            DBSSchema defaultSchema = defaults.getDefaultSchema();
                            DBSCatalog defaultCatalog = defaults.getDefaultCatalog();
                            if (defaultCatalog == null && defaultSchema == null && (dBPDataSource = dbcExecutionContext.getDataSource()) instanceof DBSObjectContainer) {
                                DBSObjectContainer container = (DBSObjectContainer)dBPDataSource;
                                this.collectTables(monitor, container, null, filterOrNull, completions);
                            } else if ((request.getContext().isSearchGlobally() || defaultSchema == null) && defaultCatalog != null) {
                                this.collectTables(monitor, (DBSObjectContainer)defaultCatalog, null, filterOrNull, completions);
                            } else if (defaultSchema != null) {
                                this.collectTables(monitor, (DBSObjectContainer)defaultSchema, null, filterOrNull, completions);
                            }
                        }
                        this.collectContextSchemasAndCatalogs(monitor, this.exposedContexts, null, filterOrNull, completions);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                    }
                }
                return this.makeFilteredCompletionSet(filterOrNull, completions);
            }

            private void collectContextSchemasAndCatalogs(@NotNull DBRProgressMonitor monitor, @NotNull Collection<DBSObjectContainer> contexts, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> completions) throws DBException {
                for (DBSObjectContainer container : contexts) {
                    Collection children = container.getChildren(monitor);
                    for (DBSObject child : children) {
                        SQLQueryWordEntry childName;
                        int score;
                        if (!(child instanceof DBSSchema) && !(child instanceof DBSCatalog) || (score = (childName = this.makeFilterInfo(filterOrNull, child.getName())).matches(filterOrNull, this.searchInsideWords)) <= 0) continue;
                        completions.addLast(SQLQueryCompletionItem.forDbObject(score, childName, contextObjext, child));
                    }
                }
            }

            private void collectTables(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @Nullable SQLQueryCompletionItem.ContextObjectInfo contextObjext, @Nullable SQLQueryWordEntry filterOrNull, @NotNull LinkedList<SQLQueryCompletionItem> accumulator) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, filterOrNull, List.of(DBSTable.class, DBSView.class), (s, e, o) -> SQLQueryCompletionItem.forRealTable(s, e, contextObjext, o, this.knownSources.getReferencedTables().contains(o)));
            }

            private void collectSchemas(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull LinkedList<SQLQueryCompletionItem> accumulator, @Nullable SQLQueryWordEntry filterOrNull) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, filterOrNull, List.of(DBSSchema.class), (s, e, o) -> SQLQueryCompletionItem.forDbObject(s, e, null, (DBSObject)o));
            }

            private void collectCatalogs(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull LinkedList<SQLQueryCompletionItem> accumulator, @Nullable SQLQueryWordEntry filterOrNull) throws DBException {
                this.collectObjectsRecursively(monitor, container, new HashSet<DBSObject>(), accumulator, filterOrNull, List.of(DBSCatalog.class), (s, e, c) -> SQLQueryCompletionItem.forDbObject(s, e, null, (DBSObject)c));
            }

            private <T extends DBSObject> void collectObjectsRecursively(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectContainer container, @NotNull Set<DBSObject> alreadyReferencedObjects, @NotNull LinkedList<SQLQueryCompletionItem> accumulator, @Nullable SQLQueryWordEntry filterOrNull, @NotNull List<Class<? extends T>> types, @NotNull CompletionItemProducer<T> completionItemFabric) throws DBException {
                Collection children = container.getChildren(monitor);
                for (DBSObject child : children) {
                    if (DBUtils.isHiddenObject((Object)child)) continue;
                    if (types.stream().anyMatch(t -> t.isInstance(child))) {
                        SQLQueryWordEntry childName = this.makeFilterInfo(filterOrNull, child.getName());
                        int score = childName.matches(filterOrNull, this.searchInsideWords);
                        if (!alreadyReferencedObjects.add(child) || score <= 0) continue;
                        accumulator.add(completionItemFabric.produce(score, childName, child));
                        continue;
                    }
                    if (!(child instanceof DBSObjectContainer)) continue;
                    DBSObjectContainer sc = (DBSObjectContainer)child;
                    if (!DBStructUtils.isConnectedContainer((DBPObject)child)) continue;
                    this.collectObjectsRecursively(monitor, sc, alreadyReferencedObjects, accumulator, filterOrNull, types, completionItemFabric);
                }
            }

            private SQLQueryCompletionItem.ContextObjectInfo prepareContextInfo(@NotNull SQLCompletionRequest request, @NotNull List<SQLQueryWordEntry> prefix, @Nullable SQLQueryWordEntry tail, @NotNull DBSObject contextObject) {
                if (contextObject != null) {
                    int prefixStart = prefix.get((int)0).offset;
                    int requestPosition = tail != null ? tail.offset : requestOffset - scriptItem.offset;
                    String prefixString = scriptItem.item.getOriginalText().substring(prefixStart, requestPosition);
                    return new SQLQueryCompletionItem.ContextObjectInfo(prefixString, contextObject);
                }
                return null;
            }

            static /* synthetic */ SQLQueryDataContext.KnownSourcesInfo access$0(3 var0) {
                return var0.knownSources;
            }
        };
    }

    protected SQLQueryCompletionSet prepareKeywordCompletions(@NotNull Set<String> keywords, @Nullable SQLQueryWordEntry filterOrNull) {
        LinkedList<SQLQueryCompletionItem> items = new LinkedList<SQLQueryCompletionItem>();
        for (String s : keywords) {
            SQLQueryWordEntry filterWord = this.makeFilterInfo(filterOrNull, s);
            int score = filterWord.matches(filterOrNull, this.searchInsideWords);
            if (score <= 0) continue;
            items.addLast(SQLQueryCompletionItem.forReservedWord(score, filterWord, s));
        }
        return this.makeFilteredCompletionSet(filterOrNull, items);
    }

    protected SQLQueryCompletionSet makeFilteredCompletionSet(@Nullable SQLQueryWordEntry filterOrNull, List<? extends SQLQueryCompletionItem> items) {
        int replacementPosition = filterOrNull == null ? this.getRequestOffset() : this.getOffset() + filterOrNull.offset;
        int replacementLength = this.getRequestOffset() - replacementPosition;
        return new SQLQueryCompletionSet(replacementPosition, replacementLength, items);
    }

    @NotNull
    private static Set<DBSObjectContainer> obtainExposedContexts(@Nullable DBCExecutionContext dbcExecutionContext) {
        LinkedHashSet<DBSObjectContainer> exposedContexts = new LinkedHashSet<DBSObjectContainer>();
        if (dbcExecutionContext != null) {
            DBSObjectContainer container;
            DBSObject contextObject = DBUtils.getSelectedObject((DBCExecutionContext)dbcExecutionContext);
            while (contextObject != null) {
                if (contextObject instanceof DBSObjectContainer) {
                    container = (DBSObjectContainer)contextObject;
                    exposedContexts.add(container);
                }
                contextObject = contextObject.getParentObject();
            }
            DBPDataSource dataSource = dbcExecutionContext.getDataSource();
            if (dataSource instanceof DBSObjectContainer) {
                container = (DBSObjectContainer)dataSource;
                exposedContexts.add(container);
            }
        }
        return exposedContexts;
    }

    @FunctionalInterface
    private static interface CompletionItemProducer<T> {
        public SQLQueryCompletionItem produce(int var1, SQLQueryWordEntry var2, T var3);
    }
}

