/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScopeItem;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQuerySymbolEntry
extends SQLQueryLexicalScopeItem
implements SQLQuerySymbolDefinition {
    @NotNull
    private final String name;
    @NotNull
    private final String rawName;
    @Nullable
    private SQLQuerySymbol symbol = null;
    @Nullable
    private SQLQuerySymbolDefinition definition = null;

    public SQLQuerySymbolEntry(@NotNull STMTreeNode syntaxNode, @NotNull String name, @NotNull String rawName) {
        super(syntaxNode);
        this.name = name;
        this.rawName = rawName;
    }

    @Override
    @NotNull
    public STMTreeNode[] getSyntaxComponents() {
        return new STMTreeNode[]{this.syntaxNode};
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getRawName() {
        return this.rawName;
    }

    @NotNull
    public Interval getInterval() {
        return this.syntaxNode.getRealInterval();
    }

    @Nullable
    public SQLQuerySymbolDefinition getDefinition() {
        return this.definition != null ? this.definition : (this.symbol != null ? this.symbol.getDefinition() : null);
    }

    public void setDefinition(@Nullable SQLQuerySymbolDefinition definition) {
        if (this.definition != null) {
            throw new UnsupportedOperationException("Symbol entry definition has already been set");
        }
        if (this.symbol != null && this.symbol.getDefinition() != null) {
            this.definition = definition;
        } else {
            this.getSymbol().setDefinition(definition);
        }
    }

    @NotNull
    public SQLQuerySymbol getSymbol() {
        if (this.symbol == null) {
            this.symbol = new SQLQuerySymbol(this.name);
            this.symbol.registerEntry(this);
        }
        return this.symbol;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.getSymbol().getSymbolClass();
    }

    public void merge(@NotNull SQLQuerySymbol symbol) {
        if (this.symbol == null) {
            this.symbol = symbol;
            this.symbol.registerEntry(this);
        }
    }

    @NotNull
    public SQLQuerySymbol merge(@NotNull SQLQuerySymbolEntry other) {
        SQLQuerySymbol symbol;
        if (this.symbol != null && other.symbol != null) {
            symbol = this.symbol.merge(other.symbol);
        } else if (this.symbol == null && other.symbol == null) {
            symbol = new SQLQuerySymbol(this.name);
            symbol.registerEntry(other);
            symbol.registerEntry(this);
            this.symbol = symbol;
            other.symbol = symbol;
        } else if (this.symbol != null) {
            symbol = this.symbol;
            symbol.registerEntry(other);
            other.symbol = symbol;
        } else {
            symbol = other.symbol;
            symbol.registerEntry(this);
            this.symbol = symbol;
        }
        return symbol;
    }

    static void updateSymbol(@NotNull SQLQuerySymbolEntry entry, @NotNull SQLQuerySymbol newSymbol) {
        entry.symbol = newSymbol;
    }

    public String toString() {
        return this.name + " (" + String.valueOf((Object)this.getSymbolClass()) + ")";
    }

    public boolean isNotClassified() {
        return this.symbol == null || this.symbol.getSymbolClass() == SQLQuerySymbolClass.UNKNOWN;
    }
}

