/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class SQLGroupingQueryGenerator {
    private static final Log log = Log.getLog(SQLGroupingQueryGenerator.class);
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String DEFAULT_FUNCTION = "COUNT(*)";
    @NotNull
    private final DBPDataSource dataSource;
    @NotNull
    private final DBSDataContainer container;
    @NotNull
    private final SQLDialect dialect;
    @NotNull
    private final SQLSyntaxManager syntaxManager;
    @NotNull
    private final List<SQLGroupingAttribute> groupAttributes;
    @NotNull
    private final List<String> groupFunctions;
    private final boolean showDuplicatesOnly;
    private String[] funcAliases = new String[0];

    public SQLGroupingQueryGenerator(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer container, @NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull List<SQLGroupingAttribute> groupAttributes, @NotNull List<String> groupFunctions, boolean showDuplicatesOnly) {
        this.dataSource = dataSource;
        this.container = container;
        this.dialect = dialect;
        this.syntaxManager = syntaxManager;
        this.groupAttributes = groupAttributes;
        this.groupFunctions = groupFunctions;
        this.showDuplicatesOnly = showDuplicatesOnly;
    }

    public String generateGroupingQuery(String queryText) throws DBException {
        boolean isDefaultGrouping;
        String subqueryAlias;
        if (queryText == null || queryText.isEmpty()) {
            if (this.container != null) {
                queryText = this.container.getName();
            } else {
                throw new DBException("Empty data container");
            }
        }
        String[] stringArray = this.syntaxManager.getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            while (queryText.endsWith(delimiter)) {
                queryText = queryText.substring(0, queryText.length() - delimiter.length());
            }
            ++n2;
        }
        boolean useAliasForColumns = this.dataSource.getSQLDialect().supportsAliasInConditions();
        StringBuilder sql = new StringBuilder();
        this.funcAliases = new String[this.groupFunctions.size()];
        int i = 0;
        while (i < this.groupFunctions.size()) {
            this.funcAliases[i] = useAliasForColumns ? this.makeGroupFunctionAlias(this.groupFunctions, i) : this.groupFunctions.get(i);
            ++i;
        }
        if (!(this.container instanceof DBSEntity) && this.dialect.supportsSubqueries()) {
            subqueryAlias = "src";
            sql.append("SELECT ");
            int i2 = 0;
            while (i2 < this.groupAttributes.size()) {
                if (i2 > 0) {
                    sql.append(", ");
                }
                sql.append(this.groupAttributes.get(i2).prepareSqlString(subqueryAlias));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.groupFunctions.size()) {
                String func = this.groupFunctions.get(i2);
                sql.append(", ").append(func);
                if (useAliasForColumns) {
                    sql.append(" as ").append(this.funcAliases[i2]);
                }
                ++i2;
            }
            sql.append(" FROM (\n");
            sql.append(queryText);
            sql.append("\n) ").append(subqueryAlias);
        } else {
            subqueryAlias = null;
            try {
                SelectBody selectBody;
                Statement statement = SQLSemanticProcessor.parseQuery((SQLDialect)this.dataSource.getSQLDialect(), (String)queryText);
                if (statement instanceof Select && (selectBody = ((Select)statement).getSelectBody()) instanceof PlainSelect) {
                    PlainSelect select = (PlainSelect)selectBody;
                    select.setOrderByElements(null);
                    SQLDialect sqlDialect = this.dataSource.getSQLDialect();
                    FromItem fromItem = select.getFromItem();
                    if (fromItem instanceof Table) {
                        Table table = (Table)fromItem;
                        FormattedTable formattedTable = new FormattedTable(table, sqlDialect);
                        formattedTable.setAlias(table.getAlias());
                        select.setFromItem((FromItem)formattedTable);
                    }
                    ArrayList<SelectExpressionItem> selectItems = new ArrayList<SelectExpressionItem>();
                    select.setSelectItems(selectItems);
                    for (SQLGroupingAttribute groupAttribute : this.groupAttributes) {
                        selectItems.add(new SelectExpressionItem(groupAttribute.prepareExpression()));
                    }
                    int i3 = 0;
                    while (i3 < this.groupFunctions.size()) {
                        String func = this.groupFunctions.get(i3);
                        Expression expression = SQLSemanticProcessor.parseExpression((String)func);
                        SelectExpressionItem sei = new SelectExpressionItem(expression);
                        if (useAliasForColumns) {
                            sei.setAlias(new Alias(this.funcAliases[i3]));
                        }
                        selectItems.add(sei);
                        ++i3;
                    }
                }
                queryText = statement.toString();
            }
            catch (Throwable e) {
                log.debug((Object)"SQL parse error", e);
            }
            sql.append(queryText);
        }
        sql.append("\nGROUP BY ");
        int i4 = 0;
        while (i4 < this.groupAttributes.size()) {
            if (i4 > 0) {
                sql.append(", ");
            }
            sql.append(this.groupAttributes.get(i4).prepareSqlString(subqueryAlias));
            ++i4;
        }
        boolean bl = isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equalsIgnoreCase(DEFAULT_FUNCTION);
        if (isDefaultGrouping && this.showDuplicatesOnly) {
            sql.append("\nHAVING ");
            if (this.dataSource.getSQLDialect().supportsAliasInHaving()) {
                sql.append(this.funcAliases[0]);
            } else {
                sql.append(DEFAULT_FUNCTION);
            }
            sql.append(" > 1");
        }
        return sql.toString();
    }

    private String makeGroupFunctionAlias(List<String> groupFunctions, int funcIndex) {
        String function = groupFunctions.get(funcIndex);
        StringBuilder alias = new StringBuilder();
        int i = 0;
        while (i < function.length()) {
            char c = function.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                alias.append(c);
            }
            ++i;
        }
        if (alias.length() > 0) {
            alias.append('_');
            return alias.toString().toLowerCase(Locale.ENGLISH);
        }
        return "i_" + funcIndex;
    }

    public String[] getFuncAliases() {
        return this.funcAliases;
    }

    private static class FormattedTable
    extends Table {
        private final SQLDialect sqlDialect;

        public FormattedTable(Table table, SQLDialect sqlDialect) {
            super(table.getDatabase(), table.getSchemaName(), table.getName());
            this.sqlDialect = sqlDialect;
        }

        public String getFullyQualifiedName() {
            String databaseName = !CommonUtils.isEmpty((String)this.getDatabase().getDatabaseName()) ? this.getDatabase().getDatabaseName() + this.sqlDialect.getCatalogSeparator() : "";
            String schemaName = this.getSchemaName() != null ? this.getSchemaName() + this.sqlDialect.getStructSeparator() : "";
            return databaseName + schemaName + this.getName();
        }
    }
}

