/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.CubridConstants;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridUser;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CubridTrigger
extends GenericTableTrigger {
    private String owner;
    private String targetColumn;
    private boolean active;
    private boolean persisted;
    private Double priority;
    private String event;
    private String condition;
    private String actionTime;
    private String actionType;
    private String actionDefinition;
    private Map<Integer, String> events = Map.of(0, "UPDATE", 1, "UPDATE STATEMENT", 2, "DELETE", 3, "DELETE STATEMENT", 4, "INSERT", 5, "INSERT STATEMENT", 8, "COMMIT", 9, "ROLLBACK");
    private Map<Integer, String> actionTimes = Map.of(1, "BEFORE", 2, "AFTER", 3, "DEFERRED");
    private Map<Integer, String> actionTypes = Map.of(1, "OTHER STATEMENT", 2, "REJECT", 3, "INVALIDATE_TRANSACTION", 4, "PRINT");
    List<String> columnList = new ArrayList<String>();

    public CubridTrigger(@NotNull GenericTableBase container, @NotNull String name, @Nullable String description, @NotNull JDBCResultSet dbResult) {
        super(container, name, description);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"owner.name");
        this.active = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"status").equals(2);
        this.targetColumn = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"target_attribute");
        this.priority = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"priority");
        this.event = this.events.get(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"event"));
        this.condition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"condition");
        this.actionTime = this.actionTimes.get(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"action_time"));
        this.actionType = this.actionTypes.get(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"action_type"));
        this.actionDefinition = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"action_definition");
        this.persisted = true;
    }

    public CubridTrigger(@NotNull GenericTableBase container, @NotNull String name, DBRProgressMonitor monitor) throws DBException {
        super(container, name, null);
        this.owner = container.getSchema().getName();
        this.active = true;
        this.priority = 0.0;
        this.event = "UPDATE";
        this.actionTime = "BEFORE";
        this.actionType = "OTHER STATEMENT";
        this.persisted = false;
        for (GenericTableColumn col : container.getAttributes(monitor)) {
            this.columnList.add(col.getName());
        }
    }

    @NotNull
    public boolean isPersisted() {
        return this.persisted;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public CubridUser getOwner() {
        return new CubridUser(this.getTable().getDataSource(), this.owner, null);
    }

    @Property(viewable=true, order=4)
    @NotNull
    public CubridTable getTable() {
        return (CubridTable)super.getTable();
    }

    @Property(viewable=true, editable=true, listProvider=ColumnNameListProvider.class, order=5)
    @Nullable
    public String getTargetColumn() {
        return this.targetColumn;
    }

    public void setTargetColumn(String targetColumn) {
        this.targetColumn = targetColumn;
    }

    @Property(viewable=true, editable=true, updatable=true, order=6)
    @NotNull
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Property(viewable=true, editable=true, updatable=true, order=10)
    @NotNull
    public Double getPriority() {
        return this.priority;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    @Property(viewable=true, editable=true, listProvider=ActionTimeListProvider.class, order=20)
    @NotNull
    public String getActionTime() {
        return this.actionTime;
    }

    public void setActionTime(String actionTime) {
        this.actionTime = actionTime;
    }

    @Property(viewable=true, editable=true, listProvider=EventOptionListProvider.class, order=30)
    @NotNull
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    @Property(viewable=true, editable=true, order=40)
    @NotNull
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Property(viewable=true, editable=true, listProvider=ActionTypeListProvider.class, order=50)
    @NotNull
    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Property(viewable=true, editable=true, order=60)
    @NotNull
    public String getActionDefinition() {
        return this.actionDefinition;
    }

    public void setActionDefinition(String actionDefinition) {
        this.actionDefinition = actionDefinition;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (this.getTable().getDataSource().getSupportMultiSchema()) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getTable().getSchema(), this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this});
    }

    @Nullable
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.persisted) {
            StringBuilder ddl = new StringBuilder();
            ddl.append("CREATE TRIGGER ");
            ddl.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL));
            ddl.append(this.getActive() ? "\nSTATUS ACTIVE" : "\nSTATUS INACTIVE");
            ddl.append("\nPRIORITY ").append(this.getPriority());
            ddl.append("\n" + this.getActionTime());
            ddl.append(" ");
            if (this.getEvent().equals("COMMIT") || this.getEvent().equals("ROLLBACK")) {
                ddl.append(this.getEvent());
            } else {
                ddl.append(this.getEvent());
                ddl.append(" ON ").append(this.getTable().getUniqueName());
                if (this.getEvent().contains("UPDATE") && this.getTargetColumn() != null) {
                    ddl.append("(" + this.getTargetColumn() + ")");
                }
                if (this.getCondition() != null) {
                    ddl.append("\nIF ").append(this.getCondition());
                }
            }
            ddl.append("\nEXECUTE ");
            if (this.getActionType().equals("REJECT") || this.getActionType().equals("INVALIDATE_TRANSACTION")) {
                ddl.append(this.getActionType());
            } else if (this.getActionType().equals("PRINT")) {
                ddl.append(this.getActionType() + " ");
                ddl.append(this.getActionDefinition() == null ? "" : SQLUtils.quoteString((DBPDataSource)this.getDataSource(), (String)this.actionDefinition));
            } else {
                ddl.append(this.getActionDefinition() == null ? "" : this.actionDefinition);
            }
            return ddl.toString();
        }
        return "-- Trigger definition not available";
    }

    public static class ActionTimeListProvider
    implements IPropertyValueListProvider<CubridTrigger> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(CubridTrigger object) {
            return CubridConstants.ACTION_TIME_OPTION;
        }
    }

    public static class ActionTypeListProvider
    implements IPropertyValueListProvider<CubridTrigger> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(CubridTrigger object) {
            return CubridConstants.ACTION_TYPE_OPTION;
        }
    }

    public static class ColumnNameListProvider
    implements IPropertyValueListProvider<CubridTrigger> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(CubridTrigger object) {
            return object.columnList.toArray();
        }
    }

    public static class EventOptionListProvider
    implements IPropertyValueListProvider<CubridTrigger> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(CubridTrigger object) {
            return CubridConstants.EVENT_OPTION;
        }
    }
}

