/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTableColumn;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class CubridTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    @NotNull
    protected CubridTableColumn createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, @Nullable Object container, @Nullable Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        CubridTable table = (CubridTable)((Object)container);
        DBSDataType columnType = CubridTableColumnManager.findBestDataType((DBSObject)table, (String[])DBConstants.DEFAULT_DATATYPE_NAMES);
        int columnSize = columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0;
        CubridTableColumn column = new CubridTableColumn((GenericTableBase)table, null, null, false, null);
        column.setName(this.getNewColumnName(monitor, context, (DBSEntity)table));
        column.setTypeName(columnType == null ? "INTEGER" : columnType.getName());
        column.setMaxLength(columnSize);
        column.setRequired(false);
        column.setDescription(null);
        column.setDefaultValue(null);
        column.setAutoIncrement(false);
        column.setPersisted(false);
        return column;
    }

    @NotNull
    public StringBuilder getNestedDeclaration(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase owner, @NotNull DBECommandAbstract<GenericTableColumn> command, @NotNull Map<String, Object> options) {
        StringBuilder decl = new StringBuilder(40);
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        String columnName = DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)column.getName());
        if (command instanceof SQLObjectEditor.ObjectRenameCommand) {
            columnName = DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)((SQLObjectEditor.ObjectRenameCommand)command).getNewName());
        }
        decl.append(columnName);
        SQLTableColumnManager.ColumnModifier[] columnModifierArray = new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.NullNotNullModifierConditional};
        int n = columnModifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLTableColumnManager.ColumnModifier modifier = columnModifierArray[n2];
            modifier.appendModifier(monitor, (DBPObject)column, decl, command);
            ++n2;
        }
        if (!CommonUtils.isEmpty((String)column.getDefaultValue())) {
            decl.append(" DEFAULT ").append(SQLUtils.quoteString((DBSObject)column, (String)column.getDefaultValue()));
        }
        if (column.isAutoIncrement() && (column.getTypeName().equals("INTEGER") || column.getTypeName().equals("BIGINT"))) {
            decl.append(" AUTO_INCREMENT");
        }
        if (!CommonUtils.isEmpty((String)column.getDescription())) {
            decl.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)column, (String)column.getDescription()));
        }
        return decl;
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        String table = ((GenericTableBase)column.getTable()).getSchema().getName() + "." + ((GenericTableBase)column.getTable()).getName();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + table + " MODIFY " + String.valueOf(this.getNestedDeclaration(monitor, (GenericTableBase)column.getTable(), (DBECommandAbstract<GenericTableColumn>)command, options))));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        CubridTableColumn column = (CubridTableColumn)command.getObject();
        String table = ((GenericTableBase)column.getTable()).getSchema().getName() + "." + ((GenericTableBase)column.getTable()).getName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + table + " RENAME COLUMN " + command.getOldName() + " AS " + command.getNewName()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

