/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;

public class SQLCompletionSorter
implements ICompletionProposalSorter {
    private final SQLEditorBase editor;
    private boolean sortAlphabetically;

    public SQLCompletionSorter(SQLEditorBase editor) {
        this.editor = editor;
    }

    public int compare(ICompletionProposal p1, ICompletionProposal p2) {
        int rc;
        int a = SQLCompletionSorter.getScore(p1);
        int b = SQLCompletionSorter.getScore(p2);
        if ((a > 0 || b > 0) && (rc = a - b) != 0) {
            return rc;
        }
        if (this.sortAlphabetically) {
            return p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString());
        }
        return 0;
    }

    private static int getScore(ICompletionProposal p) {
        if (p instanceof SQLCompletionProposal) {
            SQLCompletionProposal cp = (SQLCompletionProposal)p;
            return cp.getProposalScore();
        }
        if (p instanceof SQLQueryCompletionProposal) {
            SQLQueryCompletionProposal qcp = (SQLQueryCompletionProposal)p;
            return qcp.getProposalScore();
        }
        return 0;
    }

    public void refreshSettings() {
        this.sortAlphabetically = this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.proposals.sort.alphabetically");
    }
}

