/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLTableAliasInsertMode;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;

public class SQLQueryCompletionTextProvider
implements SQLQueryCompletionItemVisitor<String> {
    private static final Log log = Log.getLog(SQLQueryCompletionTextProvider.class);
    private final SQLCompletionRequest request;
    private final SQLQueryCompletionContext queryCompletionContext;
    private final SQLTableAliasInsertMode aliasMode;
    private final char structSeparator;
    private final Set<String> localKnownColumnNames;
    private final DBRProgressMonitor monitor;
    private final DBSObjectContainer activeContext;

    public SQLQueryCompletionTextProvider(@NotNull SQLCompletionRequest request, @NotNull SQLQueryCompletionContext queryCompletionContext, @NotNull DBRProgressMonitor monitor) {
        DBSObjectContainer c2;
        DBSObject dBSObject;
        this.request = request;
        this.queryCompletionContext = queryCompletionContext;
        this.aliasMode = SQLTableAliasInsertMode.fromPreferences((DBPPreferenceStore)request.getContext().getSyntaxManager().getPreferenceStore());
        this.structSeparator = request.getContext().getDataSource().getSQLDialect().getStructSeparator();
        this.localKnownColumnNames = queryCompletionContext.getDataContext() == null ? Collections.emptySet() : queryCompletionContext.getDataContext().getColumnsList().stream().map(c -> c.symbol.getName()).collect(Collectors.toSet());
        this.monitor = monitor;
        this.activeContext = request.getContext().getExecutionContext() == null ? null : ((dBSObject = DBUtils.getSelectedObject((DBCExecutionContext)request.getContext().getExecutionContext())) instanceof DBSObjectContainer ? (c2 = (DBSObjectContainer)dBSObject) : null);
    }

    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem subqueryAlias) {
        return subqueryAlias.symbol.getName();
    }

    @NotNull
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        String preparedColumnName = this.convertCaseIfNeeded(columnName.columnInfo.symbol.getName());
        Object prefix = columnName.sourceInfo != null && this.queryCompletionContext.getInspectionResult().expectingColumnReference() ? (columnName.sourceInfo.aliasOrNull != null ? columnName.sourceInfo.aliasOrNull.getName() + this.structSeparator : (columnName.sourceInfo.tableOrNull != null && columnName.absolute ? this.prepareObjectName((DBSObject)columnName.sourceInfo.tableOrNull) + this.structSeparator : "")) : "";
        return (String)prefix + preparedColumnName;
    }

    @NotNull
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        Object suffix;
        if (this.queryCompletionContext.getInspectionResult().expectingTableSourceIntroduction() && this.aliasMode != SQLTableAliasInsertMode.NONE) {
            SQLDialect sqlDialect = SQLUtils.getDialectFromObject((DBPObject)tableName.object);
            String alias = SQLUtils.generateEntityAlias((DBSEntity)((DBSEntity)tableName.object), s -> sqlDialect.getKeywordType(s) != null || this.queryCompletionContext.getAliasesInUse().contains(s) || this.queryCompletionContext.getDataContext() != null && this.queryCompletionContext.getDataContext().resolveSource(this.monitor, List.of(s)) != null);
            suffix = this.prepareAliasPrefix() + this.convertCaseIfNeeded(alias);
        } else {
            suffix = "";
        }
        return this.prepareObjectName((SQLQueryCompletionItem.SQLDbObjectCompletionItem<?>)tableName) + (String)suffix;
    }

    @NotNull
    private String prepareAliasPrefix() {
        return this.aliasMode == SQLTableAliasInsertMode.EXTENDED ? " " + SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)"as", (boolean)false) + " " : " ";
    }

    @NotNull
    public String visitReservedWord(@NotNull SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)reservedWord.text, (boolean)false);
    }

    @NotNull
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        return this.prepareObjectName((SQLQueryCompletionItem.SQLDbObjectCompletionItem<?>)namedObject);
    }

    @Nullable
    public String visitJoinCondition(@NotNull SQLQueryCompletionItem.SQLJoinConditionCompletionItem joinCondition) {
        return (String)joinCondition.left.apply((SQLQueryCompletionItemVisitor)this) + " = " + (String)joinCondition.right.apply((SQLQueryCompletionItemVisitor)this);
    }

    private <T extends DBSObject> String prepareObjectName(@NotNull SQLQueryCompletionItem.SQLDbObjectCompletionItem<?> objectCompletionItem) {
        Object name;
        if (objectCompletionItem.resolvedContext != null) {
            String accomplishedPart = this.prepareQualifiedName(objectCompletionItem.object, objectCompletionItem.resolvedContext.object());
            name = objectCompletionItem.resolvedContext.string() + this.convertCaseIfNeeded(accomplishedPart);
        } else {
            name = this.prepareObjectName(objectCompletionItem.object);
        }
        return name;
    }

    @NotNull
    private <T extends DBSObject> String prepareObjectName(@NotNull DBSObject namedObject) {
        String name;
        boolean forceFullName = !this.objectBelongsToTheActiveContext(namedObject) || this.activeContextHasConflictingName(namedObject);
        String shortName = DBUtils.getQuotedIdentifier((DBSObject)namedObject);
        if (this.request.getContext().isUseShortNames() && !forceFullName) {
            name = shortName;
        } else if (this.request.getContext().isUseFQNames() || forceFullName) {
            name = DBUtils.getObjectFullName((DBPNamedObject)namedObject, (DBPEvaluationContext)DBPEvaluationContext.DML);
            if (name.equals(shortName)) {
                name = this.prepareQualifiedName(namedObject, null);
            }
        } else {
            name = shortName;
        }
        return this.convertCaseIfNeeded(name);
    }

    private boolean objectBelongsToTheActiveContext(@NotNull DBSObject object) {
        DBSObject dBSObject = object.getParentObject();
        if (dBSObject instanceof DBSObjectContainer) {
            DBSObjectContainer objectContainer = (DBSObjectContainer)dBSObject;
            if (this.queryCompletionContext.getExposedContexts().contains(objectContainer)) {
                return true;
            }
        }
        return false;
    }

    private boolean activeContextHasConflictingName(@NotNull DBSObject object) {
        try {
            if (this.activeContext != null) {
                DBSObject child = this.activeContext.getChild(this.monitor, object.getName());
                return child != null && !child.equals(object);
            }
        }
        catch (DBException e) {
            log.debug((Object)"Failed to validate database object completion name ambiguity", (Throwable)e);
        }
        return false;
    }

    private String prepareQualifiedName(@NotNull DBSObject object, DBSObject knownSubroot) {
        List parts = SQLQueryCompletionItem.prepareQualifiedNameParts((DBSObject)object, (DBSObject)knownSubroot);
        return String.join((CharSequence)Character.toString(object.getDataSource().getSQLDialect().getStructSeparator()), parts);
    }

    @NotNull
    private String convertCaseIfNeeded(@NotNull String name) {
        String result = this.request.getWordDetector().isQuoted(name) ? name : SQLCompletionAnalyzer.convertKeywordCase((SQLCompletionRequest)this.request, (String)name, (boolean)true);
        return result;
    }
}

