/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionHelper;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SuggestionInformationControlCreator;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryCompletionProposalContext;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private static final Log log = Log.getLog(SQLQueryCompletionProposal.class);
    private static final boolean DEBUG = false;
    private final SQLQueryCompletionProposalContext proposalContext;
    private final SQLQueryCompletionItemKind itemKind;
    private final DBSObject object;
    private final DBPImage image;
    private final String displayString;
    private final String decorationString;
    private final String description;
    private final String replacementString;
    private final int replacementOffset;
    private final int replacementLength;
    private final SQLQueryWordEntry filterString;
    private int proposalScore;
    private boolean cachedProposalInfoComputed = false;
    private Object cachedProposalInfo = null;
    private Image cachedSwtImage = null;

    public SQLQueryCompletionProposal(@NotNull SQLQueryCompletionProposalContext proposalContext, @NotNull SQLQueryCompletionItemKind itemKind, @Nullable DBSObject object, @Nullable DBPImage image, @Nullable String displayString, @Nullable String decorationString, @NotNull String description, @NotNull String replacementString, int replacementOffset, int replacementLength, @Nullable SQLQueryWordEntry filterString, int proposalScore) {
        this.proposalContext = proposalContext;
        this.itemKind = itemKind;
        this.object = object;
        this.image = image;
        this.displayString = displayString;
        this.decorationString = decorationString;
        this.description = description;
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.filterString = filterString;
        this.proposalScore = proposalScore;
    }

    public int getProposalScore() {
        return this.proposalScore;
    }

    @NotNull
    public SQLQueryCompletionProposalContext getProposalContext() {
        return this.proposalContext;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Image getImage() {
        return this.image == null ? null : (this.cachedSwtImage != null ? this.cachedSwtImage : (this.cachedSwtImage = DBeaverIcons.getImage((DBPImage)this.image)));
    }

    public String getDisplayString() {
        return CommonUtils.isNotEmpty((String)this.displayString) ? this.displayString : this.replacementString.replaceAll("[\r\n]", "");
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public StyledString getStyledDisplayString() {
        StyledString result = new StyledString(this.getDisplayString(), this.proposalContext.getStyler(this.itemKind));
        if (CommonUtils.isNotEmpty((String)this.decorationString)) {
            result.append(this.decorationString, StyledString.DECORATIONS_STYLER);
        }
        return result;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor progressMonitor) {
        if (!this.getProposalContext().getActivityTracker().isAdditionalInfoExpected()) {
            return this.description;
        }
        if (!this.cachedProposalInfoComputed) {
            DefaultProgressMonitor monitor = new DefaultProgressMonitor(progressMonitor);
            if (this.object != null) {
                DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBRProgressMonitor)monitor, this.object, true);
                this.cachedProposalInfo = this.object;
            } else {
                Object info;
                this.cachedProposalInfo = this.itemKind == SQLQueryCompletionItemKind.RESERVED ? ((info = SQLCompletionHelper.readAdditionalProposalInfo((DBRProgressMonitor)monitor, (SQLCompletionContext)this.proposalContext.getCompletionContext(), (DBPNamedObject)this.object, (String[])new String[]{this.getDisplayString()}, (DBPKeywordType)DBPKeywordType.KEYWORD)) == null || info.equals(this.getDisplayString()) ? this.description : info) : this.description;
            }
            this.cachedProposalInfoComputed = true;
        }
        return this.cachedProposalInfo;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return this.object == null || !this.getProposalContext().getActivityTracker().isAdditionalInfoExpected() ? null : SuggestionInformationControlCreator.INSTANCE;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.replacementString;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.replacementOffset;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public Point getSelection(IDocument document) {
        return new Point(Math.min(this.replacementOffset + this.replacementString.length(), document.getLength()), 0);
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException ex) {
            log.error((Object)"Error applying completion proposal", (Throwable)ex);
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.validate(document, offset, null)) {
            try {
                document.replace(this.replacementOffset, offset - this.replacementOffset, this.replacementString);
            }
            catch (BadLocationException ex) {
                log.error((Object)"Error applying completion proposal", (Throwable)ex);
            }
        }
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        this.getProposalContext().getActivityTracker().implicitlyTriggered();
        if (this.filterString != null && CommonUtils.isNotEmpty((String)this.filterString.filterString)) {
            int filterKeyStart;
            block5: {
                filterKeyStart = this.filterString.offset >= 0 ? this.filterString.offset : this.proposalContext.getRequestOffset();
                if (offset <= document.getLength()) break block5;
                return false;
            }
            try {
                int filterKeyLength = offset - filterKeyStart;
                if (filterKeyLength > 0) {
                    String filterKey = document.get(filterKeyStart, filterKeyLength);
                    this.proposalScore = this.filterString.matches(filterKey, this.proposalContext.getCompletionContext().isSearchInsideNames());
                    return this.proposalScore > 0;
                }
                return true;
            }
            catch (BadLocationException ex) {
                log.error((Object)"Error validating completion proposal", (Throwable)ex);
            }
        }
        return true;
    }
}

