/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDEEncoding;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlCommandHandler;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.sql.eval.ScriptVariablesResolver;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLCommandInclude
implements SQLControlCommandHandler {
    private static final Log log = Log.getLog(SQLCommandInclude.class);

    public static String getResourceEncoding() {
        String resourceEncoding = IDEEncoding.getResourceEncoding();
        return CommonUtils.isEmpty((String)resourceEncoding) ? GeneralUtils.getDefaultFileEncoding() : resourceEncoding;
    }

    @NotNull
    public SQLControlResult handleCommand(@NotNull DBRProgressMonitor monitor, @NotNull SQLControlCommand command, @NotNull SQLScriptContext scriptContext) throws DBException {
        String fileContents;
        Path incFile;
        String fileName = command.getParameter();
        if (CommonUtils.isEmpty((String)fileName)) {
            throw new DBException("Empty input file");
        }
        fileName = GeneralUtils.replaceVariables((String)fileName, (IVariableResolver)new ScriptVariablesResolver(scriptContext), (boolean)true).trim();
        fileName = DBUtils.getUnQuotedIdentifier((DBPDataSource)scriptContext.getExecutionContext().getDataSource(), (String)fileName);
        Path curFile = scriptContext.getSourceFile();
        Path path = incFile = curFile == null ? Path.of(fileName, new String[0]) : curFile.getParent().resolve(fileName);
        if (!Files.exists(incFile, new LinkOption[0])) {
            incFile = Path.of(fileName, new String[0]);
        }
        if (!Files.exists(incFile, new LinkOption[0])) {
            throw new DBException("File '" + fileName + "' not found");
        }
        SQLScriptContext sc = scriptContext;
        while (sc != null) {
            if (sc.getSourceFile() != null && sc.getSourceFile().equals(incFile)) {
                throw new DBException("File '" + fileName + "' recursive inclusion");
            }
            sc = sc.getParentContext();
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream is = Files.newInputStream(incFile, new OpenOption[0]);){
                InputStreamReader reader = new InputStreamReader(is, SQLCommandInclude.getResourceEncoding());
                fileContents = IOUtils.readToString((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("IO error reading file '" + fileName + "'", (Throwable)e);
        }
        Path finalIncFile = incFile;
        boolean[] statusFlag = new boolean[1];
        UIUtils.syncExec(() -> {
            try {
                IncludeScriptListener scriptListener;
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            IEditorInput iEditorInput = editorReference.getEditorInput();
                            if (iEditorInput instanceof IncludeEditorInput) {
                                IncludeEditorInput includeInput = (IncludeEditorInput)iEditorInput;
                                if (includeInput.incFile.toAbsolutePath().toString().equals(finalIncFile.toAbsolutePath().toString())) {
                                    UIUtils.syncExec(() -> {
                                        boolean bl = page.closeEditor(editorReference.getEditor(false), false);
                                    });
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                IncludeEditorInput input = new IncludeEditorInput(finalIncFile, fileContents);
                SQLEditor sqlEditor = SQLEditorHandlerOpenEditor.openSQLConsole(workbenchWindow, new SQLNavigatorContext(scriptContext), (IEditorInput)input);
                boolean execResult = sqlEditor.processSQL(false, true, null, scriptListener = new IncludeScriptListener(workbenchWindow, sqlEditor, statusFlag));
                if (!execResult) {
                    blArray[0] = true;
                }
            }
            catch (Throwable e) {
                log.error((Object)e);
                blArray[0] = true;
            }
        });
        while (!statusFlag[0]) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return SQLControlResult.success();
    }

    private static class IncludeEditorInput
    extends StringEditorInput
    implements IURIEditorInput {
        private final Path incFile;

        IncludeEditorInput(Path incFile, CharSequence value) {
            super(incFile.getFileName().toString(), value, true, GeneralUtils.DEFAULT_ENCODING);
            this.incFile = incFile;
        }

        public URI getURI() {
            return this.incFile.toUri();
        }
    }

    private static class IncludeScriptListener
    implements SQLQueryListener {
        private final IWorkbenchWindow workbenchWindow;
        private final SQLEditor editor;
        private final boolean[] statusFlag;

        IncludeScriptListener(IWorkbenchWindow workbenchWindow, SQLEditor editor, boolean[] statusFlag) {
            this.workbenchWindow = workbenchWindow;
            this.editor = editor;
            this.statusFlag = statusFlag;
        }

        public void onStartScript() {
        }

        public void onStartQuery(DBCSession session, SQLQuery query) {
        }

        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
        }

        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            if (this.editor.getActivePreferenceStore().getBoolean("SQLEditor.closeIncludedScriptAfterExecution")) {
                UIUtils.syncExec(() -> {
                    boolean bl = this.workbenchWindow.getActivePage().closeEditor((IEditorPart)this.editor, false);
                });
            }
            this.statusFlag[0] = true;
        }

        public void onEndSqlJob(DBCSession session, SqlJobResult result) {
        }
    }
}

