/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedureParameter;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericScriptObject;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class GenericProcedure
extends AbstractProcedure<GenericDataSource, GenericStructContainer>
implements GenericScriptObject,
DBPUniqueObject,
DBPRefreshableObject {
    private static final Pattern PATTERN_COL_NAME_NUMERIC = Pattern.compile("\\$?([0-9]+)");
    private String specificName;
    private DBSProcedureType procedureType;
    private List<GenericProcedureParameter> columns;
    private String source;
    private GenericFunctionResultType functionResultType;

    public GenericProcedure(GenericStructContainer container, String procedureName, String specificName, String description, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        super((DBSObjectContainer)container, true, procedureName, description);
        this.procedureType = procedureType;
        this.functionResultType = functionResultType;
        this.specificName = specificName;
    }

    public GenericProcedure(GenericStructContainer container, String name, String description, DBSProcedureType procedureType, String source, boolean persisted) {
        super((DBSObjectContainer)container, persisted, name, description);
        this.procedureType = procedureType;
        this.source = source;
    }

    @Property(viewable=true, order=3, labelProvider=GenericCatalog.CatalogNameTermProvider.class)
    public GenericCatalog getCatalog() {
        return ((GenericStructContainer)this.getContainer()).getCatalog();
    }

    @Property(viewable=true, labelProvider=GenericSchema.SchemaNameTermProvider.class, order=4)
    public GenericSchema getSchema() {
        return ((GenericStructContainer)this.getContainer()).getSchema();
    }

    @Property(viewable=true, order=5)
    public GenericPackage getPackage() {
        return this.getContainer() instanceof GenericPackage ? (GenericPackage)this.getContainer() : null;
    }

    @Property(viewable=true, order=6)
    public DBSProcedureType getProcedureType() {
        return this.procedureType;
    }

    @Property(viewable=true, order=7)
    public GenericFunctionResultType getFunctionResultType() {
        return this.functionResultType;
    }

    @Nullable
    public Collection<GenericProcedureParameter> getParameters(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.columns == null) {
            this.loadProcedureColumns(monitor);
            if (this.columns == null) {
                this.columns = new ArrayList<GenericProcedureParameter>();
            }
        }
        return this.columns;
    }

    public void loadProcedureColumns(DBRProgressMonitor monitor) throws DBException {
        Collection<? extends GenericProcedure> procedures = ((GenericStructContainer)this.getContainer()).getProcedures(monitor, this.getName());
        if (procedures == null || !procedures.contains(this)) {
            throw new DBException("Internal error - cannot read columns for procedure '" + this.getName() + "' because its not found in container");
        }
        Iterator<? extends GenericProcedure> procIter = procedures.iterator();
        GenericProcedure procedure = null;
        GenericMetaObject pcObject = ((GenericDataSource)this.getDataSource()).getMetaObject("procedure-column");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load procedure columns");
                 JDBCResultSet dbResult = DBSProcedureType.PROCEDURE == this.procedureType ? session.getMetaData().getProcedureColumns((String)(this.getCatalog() == null ? (this.getPackage() == null || !this.getPackage().isNameFromCatalog() ? null : this.getPackage().getName()) : this.getCatalog().getName()), this.getSchema() == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)this.getSchema().getName()), JDBCUtils.escapeWildCards((JDBCSession)session, (String)this.getName()), ((GenericDataSource)this.getDataSource()).getAllObjectsPattern()) : session.getMetaData().getFunctionColumns(this.getCatalog() == null ? null : this.getCatalog().getName(), this.getSchema() == null ? null : JDBCUtils.escapeWildCards((JDBCSession)session, (String)this.getSchema().getName()), JDBCUtils.escapeWildCards((JDBCSession)session, (String)this.getName()), ((GenericDataSource)this.getDataSource()).getAllObjectsPattern());){
                int previousPosition = -1;
                while (dbResult.next()) {
                    Matcher numberMatcher;
                    DBSProcedureParameterKind parameterType;
                    String columnName = GenericUtils.safeGetString(pcObject, (ResultSet)dbResult, "COLUMN_NAME");
                    int columnTypeNum = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "COLUMN_TYPE");
                    int valueType = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "DATA_TYPE");
                    String typeName = GenericUtils.safeGetString(pcObject, (ResultSet)dbResult, "TYPE_NAME");
                    int columnSize = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "LENGTH");
                    boolean notNull = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "NULLABLE") == 0;
                    int scale = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "SCALE");
                    int precision = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "PRECISION");
                    String remarks = GenericUtils.safeGetString(pcObject, (ResultSet)dbResult, "REMARKS");
                    int position = GenericUtils.safeGetInt(pcObject, (ResultSet)dbResult, "ORDINAL_POSITION");
                    if (DBSProcedureType.PROCEDURE == this.procedureType) {
                        switch (columnTypeNum) {
                            case 1: {
                                parameterType = DBSProcedureParameterKind.IN;
                                break;
                            }
                            case 2: {
                                parameterType = DBSProcedureParameterKind.INOUT;
                                break;
                            }
                            case 4: {
                                parameterType = DBSProcedureParameterKind.OUT;
                                break;
                            }
                            case 5: {
                                parameterType = DBSProcedureParameterKind.RETURN;
                                break;
                            }
                            case 3: {
                                parameterType = DBSProcedureParameterKind.RESULTSET;
                                break;
                            }
                            default: {
                                parameterType = DBSProcedureParameterKind.UNKNOWN;
                                break;
                            }
                        }
                    } else {
                        switch (columnTypeNum) {
                            case 1: {
                                parameterType = DBSProcedureParameterKind.IN;
                                break;
                            }
                            case 2: {
                                parameterType = DBSProcedureParameterKind.INOUT;
                                break;
                            }
                            case 3: {
                                parameterType = DBSProcedureParameterKind.OUT;
                                break;
                            }
                            case 4: {
                                parameterType = DBSProcedureParameterKind.RETURN;
                                break;
                            }
                            case 5: {
                                parameterType = DBSProcedureParameterKind.RESULTSET;
                                break;
                            }
                            default: {
                                parameterType = DBSProcedureParameterKind.UNKNOWN;
                            }
                        }
                    }
                    if (CommonUtils.isEmpty((String)columnName) && parameterType == DBSProcedureParameterKind.RETURN) {
                        columnName = "RETURN";
                    }
                    if (position == 0 && (numberMatcher = PATTERN_COL_NAME_NUMERIC.matcher(columnName)).matches()) {
                        position = Integer.parseInt(numberMatcher.group(1));
                    }
                    if (procedure == null || previousPosition >= 0 && position <= previousPosition && procIter.hasNext()) {
                        procedure = procIter.next();
                    }
                    GenericProcedureParameter column = new GenericProcedureParameter(procedure, columnName, typeName, valueType, position, columnSize, scale, precision, notNull, remarks, parameterType);
                    procedure.addColumn(column);
                    previousPosition = position;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, this.getDataSource());
        }
    }

    public void addColumn(GenericProcedureParameter column) {
        if (this.columns == null) {
            this.columns = new ArrayList<GenericProcedureParameter>();
        }
        this.columns.add(column);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this.getSchema(), this});
    }

    @NotNull
    public String getUniqueName() {
        return CommonUtils.isEmpty((String)this.specificName) ? this.getName() : this.specificName;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null) {
            this.source = ((GenericDataSource)this.getDataSource()).getMetaModel().getProcedureDDL(monitor, this);
        }
        return this.source;
    }

    @NotNull
    public String getProcedureSignature(DBRProgressMonitor monitor, boolean showParamNames) throws DBException {
        return this.getFullyQualifiedName(DBPEvaluationContext.DML) + "(" + this.makeSignature(monitor, showParamNames) + ")";
    }

    private String makeSignature(DBRProgressMonitor monitor, boolean showParamNames) throws DBException {
        Collection<GenericProcedureParameter> parameters = this.getParameters(monitor);
        if (!CommonUtils.isEmpty(parameters)) {
            StringBuilder paramsSignature = new StringBuilder(64);
            boolean hasParam = false;
            for (GenericProcedureParameter param : parameters) {
                if (param.getParameterKind() != DBSProcedureParameterKind.IN && param.getParameterKind() != DBSProcedureParameterKind.INOUT) continue;
                if (hasParam) {
                    paramsSignature.append(',');
                }
                hasParam = true;
                if (showParamNames) {
                    paramsSignature.append(param.getName()).append(' ');
                }
                paramsSignature.append(param.getFullTypeName());
            }
            return paramsSignature.toString();
        }
        return "";
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.source = null;
        return this;
    }
}

