/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.data.OracleBinaryFormatter;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateFactory;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicatesCondition;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class OracleSQLDialect
extends JDBCSQLDialect
implements SQLDataTypeConverter,
SQLDialectDDLExtension,
SQLDialectSchemaController {
    private static final Log log = Log.getLog(OracleSQLDialect.class);
    private static final String[] EXEC_KEYWORDS = new String[]{"call"};
    private static final String[] ORACLE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"CREATE", "ALTER", "DROP", "ANALYZE", "VALIDATE"});
    private static final String[][] ORACLE_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"LOOP", "END LOOP"}, {"CASE", "END CASE"}};
    private static final String[] ORACLE_BLOCK_HEADERS = new String[]{"DECLARE", "PACKAGE"};
    private static final String[] ORACLE_INNER_BLOCK_PREFIXES = new String[]{"AS", "IS"};
    private static final String[] OTHER_TYPES_FUNCTIONS = new String[]{"CURRENT_DATE", "CURRENT_TIMESTAMP", "DBTIMEZONE", "SESSIONTIMEZONE", "SYSDATE", "SYSTIMESTAMP"};
    private static final String[] ADVANCED_KEYWORDS = new String[]{"REPLACE", "PACKAGE", "FUNCTION", "TYPE", "BODY", "RECORD", "TRIGGER", "MATERIALIZED", "IF", "EACH", "RETURN", "WRAPPED", "AFTER", "BEFORE", "DATABASE", "ANALYZE", "VALIDATE", "STRUCTURE", "COMPUTE", "STATISTICS", "LOOP", "WHILE", "BULK", "ELSIF", "EXIT", "SUBPARTITION", "TEMPFILE", "DATAFILE", "TABLESPACE"};
    private static final String AUTO_INCREMENT_KEYWORD = "GENERATED ALWAYS AS IDENTITY";
    private boolean crlfBroken;
    private DBPPreferenceStore preferenceStore;
    private SQLTokenPredicateSet cachedDialectSkipTokenPredicates = null;

    public OracleSQLDialect() {
        super("Oracle", "oracle");
        this.setUnquotedIdentCase(DBPIdentifierCase.UPPER);
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.crlfBroken = !dataSource.isServerVersionAtLeast(11, 0);
        this.preferenceStore = dataSource.getContainer().getPreferenceStore();
        this.addFunctions(Arrays.asList("SUBSTR", "APPROX_COUNT_DISTINCT", "REGEXP_SUBSTR", "REGEXP_INSTR", "REGEXP_REPLACE", "REGEXP_LIKE", "REGEXP_COUNT", "BITAND", "COSH", "NANVL", "REMAINDER", "SINH", "TANH", "TRUNC", "CHR", "INITCAP", "LPAD", "NLS_INITCAP", "NLS_LOWER", "NLSSORT", "NLS_UPPER", "RPAD", "REVERSE", "SUBSTRB", "SUBSTRC", "SUBSTR2", "SUBSTR4", "NLS_CHARSET_DECL_LEN", "NLS_CHARSET_ID", "NLS_CHARSET_NAME", "INSTR", "INSTRB", "INSTRC", "INSTR2", "INSTR4", "LENGTHB", "LENGTH", "ADD_MONTHS", "FROM_TZ", "LAST_DAY", "MONTHS_BETWEEN", "NEW_TIME", "NEXT_DAY", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "SYS_EXTRACT_UTC", "TO_CHAR", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_DSINTERVAL", "TO_YMINTERVAL", "TRUNC", "TZ_OFFSET", "GREATEST", "LEAST", "ASCIISTR", "BIN_TO_NUM", "CHARTOROWID", "COMPOSE", "DECOMPOSE", "HEXTORAW", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "RAWTOHEX", "RAWTONHEX", "ROWIDTOCHAR", "ROWIDTONCHAR", "SCN_TO_TIMESTAMP", "TIMESTAMP_TO_SCN", "TO_BINARY_DOUBLE", "TO_BINARY_FLOAT", "TO_CHAR", "TO_CLOB", "TO_DATE", "TO_DSINTERVAL", "TO_LOB", "TO_MULTI_BYTE", "TO_NCHAR", "TO_NCLOB", "TO_NUMBER", "TO_DSINTERVAL", "TO_SINGLE_BYTE", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_YMINTERVAL", "TO_YMINTERVAL", "UNISTR", "BFILENAME", "EMPTY_BLOB", "EMPTY_CLOB", "POWERMULTISET", "POWERMULTISET_BY_CARDINALITY", "SYS_CONNECT_BY_PATH", "CLUSTER_ID", "CLUSTER_PROBABILITY", "CLUSTER_SET", "FEATURE_ID", "FEATURE_SET", "FEATURE_VALUE", "PREDICTION", "PREDICTION_COST", "PREDICTION_DETAILS", "PREDICTION_PROBABILITY", "PREDICTION_SET", "APPENDCHILDXML", "DELETEXML", "DEPTH", "EXISTSNODE", "EXTRACTVALUE", "INSERTCHILDXML", "INSERTXMLBEFORE", "PATH", "SYS_DBURIGEN", "SYS_XMLAGG", "SYS_XMLGEN", "UPDATEXML", "XMLAGG", "XMLCDATA", "XMLCOLATTVAL", "XMLCOMMENT", "XMLCONCAT", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLQUERY", "XMLROOT", "XMLSEQUENCE", "XMLSERIALIZE", "XMLTABLE", "XMLTRANSFORM", "DECODE", "DUMP", "ORA_HASH", "VSIZE", "LNNVL", "NVL", "NVL2", "SYS_CONTEXT", "SYS_GUID", "SYS_TYPEID", "UID", "USERENV", "CORR_S", "CORR_K", "FIRST", "GROUP_ID", "GROUPING_ID", "LAST", "MEDIAN", "STATS_BINOMIAL_TEST", "STATS_CROSSTAB", "STATS_F_TEST", "STATS_KS_TEST", "STATS_MODE", "STATS_MW_TEST", "STATS_ONE_WAY_ANOVA", "STATS_T_TEST_ONE", "STATS_T_TEST_PAIRED", "STATS_T_TEST_INDEP", "STATS_T_TEST_INDEPU", "STATS_WSR_TEST", "STDDEV", "VARIANCE", "FIRST", "FIRST_VALUE", "LAG", "LAST", "LAST_VALUE", "LEAD", "NTILE", "RATIO_TO_REPORT", "STDDEV", "VARIANCE", "COALESCE", "MAKE_REF", "REFTOHEX", "CV", "ITERATION_NUMBER", "PRESENTNNV", "PRESENTV", "PREVIOUS", "EXTRACT", "LISTAGG", "OVER", "RANK"));
        this.removeSQLKeyword("SYSTEM");
        String[] stringArray = ADVANCED_KEYWORDS;
        int n = ADVANCED_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            this.addSQLKeyword(kw);
            ++n2;
        }
        this.addKeywords(Arrays.asList(OTHER_TYPES_FUNCTIONS), DBPKeywordType.OTHER);
        this.turnFunctionIntoKeyword("TRUNCATE");
        this.cachedDialectSkipTokenPredicates = this.makeDialectSkipTokenPredicates(dataSource);
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        super.loadDataTypesFromDatabase(dataSource);
        this.addDataTypes(OracleDataType.PREDEFINED_TYPES.keySet());
    }

    public String[][] getBlockBoundStrings() {
        return ORACLE_BEGIN_END_BLOCK;
    }

    public String[] getBlockHeaderStrings() {
        return ORACLE_BLOCK_HEADERS;
    }

    @Nullable
    public String[] getInnerBlockPrefixes() {
        return ORACLE_INNER_BLOCK_PREFIXES;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.INSERT_ALL;
    }

    public String getLikeEscapeClause(@NotNull String escapeChar) {
        return " ESCAPE " + this.getQuotedString(escapeChar);
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (CommonUtils.isNaN((Object)value) || CommonUtils.isInfinite((Object)value)) {
            return "'" + String.valueOf(value) + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsAliasInUpdate() {
        return true;
    }

    public boolean supportsAsKeywordBeforeAliasInFromClause() {
        return false;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> "UPPER(" + left + ") LIKE UPPER(" + right + ")";
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }

    public boolean isDelimiterAfterBlock() {
        return true;
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return OracleBinaryFormatter.INSTANCE;
    }

    @Nullable
    public String getDualTableName() {
        return "DUAL";
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return ORACLE_NON_TRANSACTIONAL_KEYWORDS;
    }

    protected String getStoredProcedureCallInitialClause(DBSProcedure proc) {
        if (proc.getProcedureType() == DBSProcedureType.FUNCTION) {
            return "SELECT " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
        }
        return "CALL " + proc.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    @NotNull
    protected String getProcedureCallEndClause(DBSProcedure procedure) {
        if (procedure.getProcedureType() == DBSProcedureType.FUNCTION) {
            return "FROM DUAL";
        }
        return super.getProcedureCallEndClause(procedure);
    }

    public boolean isDisableScriptEscapeProcessing() {
        return this.preferenceStore == null || this.preferenceStore.getBoolean("oracle.disable.script.escape");
    }

    public boolean supportsUuid() {
        return false;
    }

    @NotNull
    public String[] getScriptDelimiters() {
        return super.getScriptDelimiters();
    }

    public boolean isCRLFBroken() {
        return this.crlfBroken;
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        switch (typeName) {
            case "DECIMAL": 
            case "NUMBER": {
                DBSDataType dataType = DBUtils.getDataType((DBSTypedObject)column);
                Integer scale = column.getScale();
                int precision = CommonUtils.toInt((Object)column.getPrecision());
                if (precision == 0 && dataType != null && scale != null && scale.intValue() == dataType.getMinScale()) {
                    return "";
                }
                if (precision == 0 || precision > 38) {
                    precision = 38;
                }
                if (scale == null && precision <= 0) break;
                return "(" + String.valueOf(precision > 0 ? Integer.valueOf(precision) : "38") + (String)(scale != null ? "," + String.valueOf(scale) : "") + ")";
            }
            case "INTERVAL DAY TO SECOND": {
                Integer scale = column.getScale();
                if (scale == null) {
                    return "";
                }
                if (scale < 0 || scale > 9) {
                    scale = 6;
                }
                return "(" + String.valueOf(scale) + ")";
            }
            case "CONTENT POINTER": 
            case "LONG RAW": 
            case "LONG": 
            case "BFILE": 
            case "CFILE": 
            case "OCTET": 
            case "INTERVAL YEAR TO MONTH": {
                return "";
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public String convertExternalDataType(@NotNull SQLDialect sourceDialect, @NotNull DBSTypedObject sourceTypedObject, @Nullable DBPDataTypeProvider targetTypeProvider) {
        String type = super.convertExternalDataType(sourceDialect, sourceTypedObject, targetTypeProvider);
        if (type != null) {
            return type;
        }
        String externalTypeName = sourceTypedObject.getTypeName().toUpperCase(Locale.ENGLISH);
        String localDataType = null;
        Object dataTypeModifies = null;
        switch (externalTypeName) {
            case "VARCHAR": {
                localDataType = "VARCHAR2";
                if (sourceTypedObject.getMaxLength() <= 0L || sourceTypedObject.getMaxLength() == Integer.MAX_VALUE || sourceTypedObject.getMaxLength() == Long.MAX_VALUE) break;
                dataTypeModifies = String.valueOf(sourceTypedObject.getMaxLength());
                break;
            }
            case "XMLTYPE": 
            case "XML": {
                localDataType = "SYS.XMLTYPE";
                break;
            }
            case "JSON": 
            case "JSONB": {
                localDataType = "JSON";
                break;
            }
            case "GEOMETRY": 
            case "GEOGRAPHY": 
            case "SDO_GEOMETRY": {
                localDataType = "MDSYS.SDO_GEOMETRY";
                break;
            }
            case "NUMERIC": {
                localDataType = "NUMBER";
                if (sourceTypedObject.getPrecision() == null) break;
                dataTypeModifies = sourceTypedObject.getPrecision().toString();
                if (sourceTypedObject.getScale() == null) break;
                dataTypeModifies = (String)dataTypeModifies + "," + String.valueOf(sourceTypedObject.getScale());
            }
        }
        if (localDataType == null) {
            return null;
        }
        if (targetTypeProvider != null) {
            DBSDataType dataType;
            block34: {
                try {
                    dataType = targetTypeProvider.resolveDataType((DBRProgressMonitor)new VoidProgressMonitor(), localDataType);
                    if (dataType != null) break block34;
                    return null;
                }
                catch (DBException e) {
                    log.debug((Object)"Error resolving local data type", (Throwable)e);
                    return null;
                }
            }
            Object targetTypeName = DBUtils.getObjectFullName((DBPNamedObject)dataType, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            if (dataTypeModifies != null) {
                targetTypeName = (String)targetTypeName + "(" + (String)dataTypeModifies + ")";
            }
            return targetTypeName;
        }
        return localDataType;
    }

    @NotNull
    public SQLTokenPredicateSet getSkipTokenPredicates() {
        return this.cachedDialectSkipTokenPredicates == null ? super.getSkipTokenPredicates() : this.cachedDialectSkipTokenPredicates;
    }

    @NotNull
    private SQLTokenPredicateSet makeDialectSkipTokenPredicates(JDBCDataSource dataSource) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init((SQLDialect)this, dataSource.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules((DBPDataSource)dataSource, false);
        TokenPredicateFactory tt = TokenPredicateFactory.makeDialectSpecificFactory((SQLRuleManager)ruleManager);
        TokenPredicateSet conditions = TokenPredicateSet.of((TokenPredicatesCondition[])new TokenPredicatesCondition[]{new TokenPredicatesCondition(SQLParserActionKind.BEGIN_BLOCK, tt.sequence(new Object[]{"CREATE", tt.optional(new Object[]{"OR", "REPLACE"}), tt.optional(tt.alternative(new Object[]{"EDITIONABLE", "NONEDITIONABLE"})), "PACKAGE", "BODY"}), tt.sequence(new TokenPredicateNode[0])), new TokenPredicatesCondition(SQLParserActionKind.SKIP_SUFFIX_TERM, tt.sequence(new Object[]{"CREATE", tt.optional(new Object[]{"OR", "REPLACE"}), tt.optional(tt.alternative(new Object[]{"EDITIONABLE", "NONEDITIONABLE"})), tt.alternative(new Object[]{"FUNCTION", "PROCEDURE"})}), tt.sequence(new Object[]{tt.alternative(new Object[]{tt.sequence(new Object[]{"RETURN", SQLTokenType.T_TYPE}), "deterministor", "pipelined", "parallel_enable", "result_cache", ")", tt.sequence(new Object[]{"procedure", SQLTokenType.T_OTHER}), tt.sequence(new Object[]{SQLTokenType.T_OTHER, SQLTokenType.T_TYPE})}), ";"})), new TokenPredicatesCondition(SQLParserActionKind.BEGIN_BLOCK, tt.sequence(new TokenPredicateNode[0]), tt.sequence(new Object[]{tt.not("END"), "IF", tt.not("EXISTS")}))});
        if (dataSource.isServerVersionAtLeast(12, 1)) {
            conditions.add(new TokenPredicatesCondition(SQLParserActionKind.SKIP_SUFFIX_TERM, tt.token((Object)"WITH"), tt.sequence(new Object[]{"END", ";"})));
        }
        return conditions;
    }

    public boolean hasCaseSensitiveFiltration() {
        return true;
    }

    public boolean supportsAliasInConditions() {
        return false;
    }

    public String getOffsetLimitQueryPart(int offset, int limit) {
        return String.format("OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
    }

    public String getClobComparingPart(@NotNull String columnName) {
        return "DBMS_LOB.COMPARE(%s,?) = 0".formatted(columnName);
    }

    @Nullable
    public String getAutoIncrementKeyword() {
        return AUTO_INCREMENT_KEYWORD;
    }

    public boolean supportsCreateIfExists() {
        return false;
    }

    @NotNull
    public String getTimestampDataType() {
        return "TIMESTAMP";
    }

    @NotNull
    public String getBigIntegerType() {
        return "NUMBER";
    }

    @NotNull
    public String getClobDataType() {
        return "CLOB";
    }

    @NotNull
    public String getBlobDataType() {
        return "BLOB";
    }

    @NotNull
    public String getUuidDataType() {
        return "VARCHAR2(36)";
    }

    @NotNull
    public String getBooleanDataType() {
        return "VARCHAR(1)";
    }

    @NotNull
    public String getAlterColumnOperation() {
        return "MODIFY";
    }

    public boolean supportsNoActionIndex() {
        return false;
    }

    public boolean supportsAlterColumnSet() {
        return false;
    }

    public boolean supportsAlterHasColumn() {
        return false;
    }

    public boolean needsDefaultDataTypes() {
        return false;
    }

    @NotNull
    public String getSchemaExistQuery(@NotNull String schemaName) {
        return "SELECT 1 FROM all_users WHERE USERNAME='" + schemaName + "'";
    }

    @NotNull
    public String getCreateSchemaQuery(@NotNull String schemaName) {
        return "CREATE USER " + schemaName + " IDENTIFIED BY \"" + SecurityUtils.generatePassword((int)10) + "\"";
    }

    public EnumSet<SQLDialect.ProjectionAliasVisibilityScope> getProjectionAliasVisibilityScope() {
        return EnumSet.of(SQLDialect.ProjectionAliasVisibilityScope.ORDER_BY);
    }
}

