/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.adapters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.adapters.AbstractTypeAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.DPILocalObjectAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.DPIResultSetAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.DPIServerSmartObjectsAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.SQLDataReceiverAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.SQLDialectAdapter;
import org.jkiss.dbeaver.dpi.model.adapters.TimeZoneAdapter;
import org.jkiss.dbeaver.dpi.model.client.DPIClientProxy;
import org.jkiss.dbeaver.dpi.model.client.DPISmartObjectWrapper;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.dpi.DPIClientObject;
import org.jkiss.dbeaver.model.dpi.DPIContainer;
import org.jkiss.dbeaver.model.dpi.DPIElement;
import org.jkiss.dbeaver.model.dpi.DPILocalObject;
import org.jkiss.dbeaver.model.dpi.DPIObject;
import org.jkiss.dbeaver.model.dpi.DPISmartObject;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.utils.BeanUtils;

public class DPISerializer {
    private static final Log log = Log.getLog(DPISerializer.class);
    public static final String ATTR_OBJECT_ID = "id";
    public static final String ATTR_ROOT = "root";
    public static final String ATTR_OBJECT_TYPE = "type";
    private static final String ATTR_OBJECT_STRING = "string";
    private static final String ATTR_OBJECT_HASH = "hash";
    private static final String ATTR_INTERFACES = "interfaces";
    private static final String ATTR_PROPS = "properties";
    private static final String ATTR_CONTAINERS = "containers";

    public static Gson createServerSerializer(DPIContext context) {
        HashMap adapters = new HashMap(DPISerializer.getCommonAdapters());
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DPITypeAdapterFactory(context, adapters)).create();
    }

    public static Gson createClientSerializer(@NotNull DPIContext context) {
        HashMap adapters = new HashMap(DPISerializer.getCommonAdapters());
        return new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DPITypeAdapterFactory(context, adapters)).create();
    }

    private static Map<Class<?>, AdapterCreator> getCommonAdapters() {
        HashMap common = new HashMap();
        common.put(DBRProgressMonitor.class, (context, gson) -> new DPIProgressMonitorAdapter(context));
        common.put(DPIClientObject.class, (context, gson) -> new DPIObjectRefAdapter(context));
        common.put(Throwable.class, (context, gson) -> new DPIThrowableAdapter(context));
        common.put(SQLDialect.class, (context, gson) -> new SQLDialectAdapter(context));
        common.put(TimeZone.class, (context, gson) -> new TimeZoneAdapter(context));
        common.put(DBCResultSet.class, DPIResultSetAdapter::new);
        common.put(DBDDataReceiver.class, SQLDataReceiverAdapter::new);
        common.put(DPISmartObjectWrapper.class, DPIServerSmartObjectsAdapter::new);
        return common;
    }

    @Nullable
    public static DPIObject getDPIAnno(@NotNull Class<?> type) {
        return DPISerializer.getClassAnnotation(type, DPIObject.class);
    }

    public static boolean isSmartObject(@NotNull Class<?> type) {
        return DPISerializer.getClassAnnotation(type, DPISmartObject.class) != null;
    }

    @Nullable
    public static <T extends Annotation> T getClassAnnotation(@NotNull Class<?> type, @NotNull Class<T> annotationClass) {
        T annotation = type.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?>[] classArray = type.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            annotation = DPISerializer.getClassAnnotation(i, annotationClass);
            if (annotation != null) {
                return annotation;
            }
            ++n2;
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return null;
        }
        return DPISerializer.getClassAnnotation(superclass, annotationClass);
    }

    public static <T extends Annotation> T getMethodAnno(@NotNull Method method, Class<T> annoType) {
        T annotation = method.getAnnotation(annoType);
        if (annotation == null) {
            annotation = DPISerializer.getMethodAnno(method, annoType, method.getDeclaringClass());
        }
        return annotation;
    }

    @Nullable
    private static <T extends Annotation> T getMethodAnno(@NotNull Method method, Class<T> annoType, Class<?> methodClass) {
        Class<?>[] classArray = methodClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            T anno;
            Class<?> mi = classArray[n2];
            if (mi.getAnnotation(DPIObject.class) != null) {
                try {
                    Method iMethod = mi.getMethod(method.getName(), method.getParameterTypes());
                    T anno2 = iMethod.getAnnotation(annoType);
                    if (anno2 != null) {
                        return anno2;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            if ((anno = DPISerializer.getMethodAnno(method, annoType, mi)) != null) {
                return anno;
            }
            ++n2;
        }
        return null;
    }

    @FunctionalInterface
    private static interface AdapterCreator {
        public TypeAdapter<?> createAdapter(@NotNull DPIContext var1, @NotNull Gson var2);
    }

    static class DPIClassAdapter
    extends AbstractTypeAdapter<Class> {
        public DPIClassAdapter(DPIContext context) {
            super(context);
        }

        public void write(JsonWriter jsonWriter, Class aClass) throws IOException {
            jsonWriter.value(aClass.getName());
        }

        public Class<?> read(JsonReader jsonReader) throws IOException {
            String className = jsonReader.nextString();
            try {
                return Class.forName(className, true, this.context.getClassLoader());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    static class DPIObjectRefAdapter
    extends AbstractTypeAdapter<DPIClientObject> {
        public DPIObjectRefAdapter(DPIContext context) {
            super(context);
        }

        public void write(JsonWriter jsonWriter, DPIClientObject object) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name(DPISerializer.ATTR_OBJECT_ID);
            jsonWriter.value(object.dpiObjectId());
            jsonWriter.endObject();
        }

        public DPIClientObject read(JsonReader jsonReader) throws IOException {
            throw new IOException("DPI object reference deserialization is not supported");
        }
    }

    static class DPIObjectTypeAdapter<T>
    extends TypeAdapter<T> {
        private final DPIContext context;
        private final Type type;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken;

        public DPIObjectTypeAdapter(DPIContext context, Type type) {
            this.context = context;
            this.type = type;
        }

        public void write(JsonWriter jsonWriter, Object t) throws IOException {
            if (t == null) {
                jsonWriter.nullValue();
                return;
            }
            if (t instanceof DBPDataSourceContainer) {
                jsonWriter.beginObject();
                jsonWriter.name(DPISerializer.ATTR_OBJECT_ID);
                jsonWriter.value(DPISerializer.ATTR_ROOT);
                jsonWriter.endObject();
                return;
            }
            boolean oldObject = this.context.hasObject(t);
            jsonWriter.beginObject();
            jsonWriter.name(DPISerializer.ATTR_OBJECT_ID);
            jsonWriter.value(this.context.getOrCreateObjectId(t));
            if (!oldObject) {
                this.serializeObjectInfo(jsonWriter, t);
                this.serializeContainers(jsonWriter, t);
                this.serializeProperties(jsonWriter, t);
            }
            jsonWriter.endObject();
        }

        private void serializeObjectInfo(JsonWriter jsonWriter, Object t) throws IOException {
            jsonWriter.name(DPISerializer.ATTR_OBJECT_TYPE);
            jsonWriter.value(t.getClass().getName());
            jsonWriter.name(DPISerializer.ATTR_OBJECT_STRING);
            jsonWriter.value(t.toString());
            jsonWriter.name(DPISerializer.ATTR_OBJECT_HASH);
            jsonWriter.value((long)t.hashCode());
            jsonWriter.name(DPISerializer.ATTR_INTERFACES);
            jsonWriter.beginArray();
            Class<?> theClass = t.getClass();
            while (theClass != null && theClass != Object.class) {
                Class<?>[] classArray = theClass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> theInt = classArray[n2];
                    jsonWriter.value(theInt.getName());
                    ++n2;
                }
                theClass = theClass.getSuperclass();
            }
            jsonWriter.endArray();
        }

        private void serializeProperties(JsonWriter jsonWriter, Object t) throws IOException {
            int n;
            int n2;
            Object[] objectArray;
            PropertyCollector pc = new PropertyCollector(t, false);
            pc.collectProperties();
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            if (pc.getProperties().length > 0) {
                objectArray = pc.getProperties();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    DBPPropertyDescriptor prop = objectArray[n];
                    props.put(prop.getId(), pc.getPropertyValue(null, prop.getId()));
                    ++n;
                }
            }
            objectArray = t.getClass().getMethods();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                DPIElement elemAnno;
                DBPPropertyDescriptor m = objectArray[n];
                if (m.getParameterTypes().length == 0 && !m.isAnnotationPresent(Property.class) && (elemAnno = DPISerializer.getMethodAnno((Method)m, DPIElement.class)) != null && elemAnno.cache()) {
                    try {
                        Object propValue = m.invoke(t, new Object[0]);
                        props.put(BeanUtils.getPropertyNameFromGetter((String)m.getName()), propValue);
                    }
                    catch (Throwable throwable) {
                        log.debug((Object)("Error reading object element " + String.valueOf(m)));
                    }
                }
                ++n;
            }
            if (!props.isEmpty()) {
                JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)DPISerializer.ATTR_PROPS, props);
            }
        }

        private void serializeContainers(JsonWriter jsonWriter, Object t) throws IOException {
            HashSet<String> collectedContainers = null;
            boolean hasContainers = false;
            Method[] methodArray = t.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    DPIContainer anno;
                    Method method = methodArray[n2];
                    if (!(collectedContainers != null && collectedContainers.contains(method.getName()) || (anno = DPISerializer.getMethodAnno(method, DPIContainer.class)) == null || anno.root() || method.getParameterTypes().length != 0)) {
                        Object container;
                        try {
                            container = method.invoke(t, new Object[0]);
                        }
                        catch (Throwable e) {
                            log.warn((Object)"Error reading DPI container", e);
                            break block9;
                        }
                        if (container != null) {
                            if (collectedContainers == null) {
                                collectedContainers = new HashSet<String>();
                            }
                            collectedContainers.add(method.getName());
                            String containerId = this.context.getObjectId(container);
                            if (containerId != null) {
                                if (!hasContainers) {
                                    jsonWriter.name(DPISerializer.ATTR_CONTAINERS);
                                    jsonWriter.beginObject();
                                    hasContainers = true;
                                }
                                jsonWriter.name(method.getName());
                                jsonWriter.value(containerId);
                            }
                        }
                    }
                }
                ++n2;
            }
            if (hasContainers) {
                jsonWriter.endObject();
            }
        }

        /*
         * Unable to fully structure code
         */
        public T read(JsonReader jsonReader) throws IOException {
            block45: {
                block44: {
                    if (jsonReader.peek() == JsonToken.NULL) {
                        return null;
                    }
                    jsonReader.beginObject();
                    objectId = null;
                    objectType = null;
                    objectToString = null;
                    objectHashCode = null;
                    allInterfaces = new LinkedHashSet<Class<DPIClientObject>>();
                    objectContainers = null;
                    objectProperties = null;
                    if ("id".equals(jsonReader.nextName())) {
                        objectId = jsonReader.nextString();
                    }
                    if (!"root".equals(objectId)) ** GOTO lbl115
                    jsonReader.endObject();
                    return (T)this.context.getRootObject();
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = attrName = jsonReader.nextName();
                        tmp = -1;
                        switch (var10_10.hashCode()) {
                            case -1598539174: {
                                if (var10_10.equals("interfaces")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case -926053069: {
                                if (var10_10.equals("properties")) {
                                    tmp = 2;
                                }
                                break;
                            }
                            case -891985903: {
                                if (var10_10.equals("string")) {
                                    tmp = 3;
                                }
                                break;
                            }
                            case 3195150: {
                                if (var10_10.equals("hash")) {
                                    tmp = 4;
                                }
                                break;
                            }
                            case 3575610: {
                                if (var10_10.equals("type")) {
                                    tmp = 5;
                                }
                                break;
                            }
                            case 145245202: {
                                if (var10_10.equals("containers")) {
                                    tmp = 6;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 5: {
                                objectType = jsonReader.nextString();
                                break;
                            }
                            case 3: {
                                objectToString = jsonReader.nextString();
                                break;
                            }
                            case 4: {
                                objectHashCode = jsonReader.nextInt();
                                break;
                            }
                            case 1: {
                                jsonReader.beginArray();
                                while (jsonReader.peek() == JsonToken.STRING) {
                                    intName = jsonReader.nextString();
                                    try {
                                        intClass = Class.forName(intName, true, this.getClassLoader());
                                        allInterfaces.add(intClass);
                                    }
                                    catch (Exception v0) {
                                        DPISerializer.log.debug((Object)("Interface '" + intName + "' cannot be resolved"));
                                    }
                                }
                                jsonReader.endArray();
                                break;
                            }
                            case 6: {
                                jsonReader.beginObject();
                                while (jsonReader.peek() == JsonToken.NAME) {
                                    containerName = jsonReader.nextName();
                                    containerId = jsonReader.nextString();
                                    v1 = objectContainer = containerId.equals(objectId) != false ? DPIClientProxy.SELF_REFERENCE : this.context.getObject(containerId);
                                    if (objectContainer != null) {
                                        if (objectContainers == null) {
                                            objectContainers = new HashMap<String, Object>();
                                        }
                                        objectContainers.put(containerName, objectContainer);
                                        continue;
                                    }
                                    DPISerializer.log.debug((Object)("DPI container '" + containerName + "'='" + containerId + "' not found in DPI context"));
                                }
                                jsonReader.endObject();
                                break;
                            }
                            case 2: {
                                jsonReader.beginObject();
                                while (jsonReader.peek() == JsonToken.NAME) {
                                    propName = jsonReader.nextName();
                                    propValue = null;
                                    switch (DPIObjectTypeAdapter.$SWITCH_TABLE$com$google$gson$stream$JsonToken()[jsonReader.peek().ordinal()]) {
                                        case 8: {
                                            propValue = jsonReader.nextBoolean();
                                            break;
                                        }
                                        case 7: {
                                            propValue = jsonReader.nextLong();
                                            break;
                                        }
                                        case 6: {
                                            propValue = jsonReader.nextString();
                                            break;
                                        }
                                        default: {
                                            DPISerializer.log.debug((Object)("Skip property '" + propName + "' value"));
                                            jsonReader.skipValue();
                                        }
                                    }
                                    if (objectProperties == null) {
                                        objectProperties = new LinkedHashMap<String, Object>();
                                    }
                                    objectProperties.put(propName, propValue);
                                }
                                jsonReader.endObject();
                            }
                        }
lbl115:
                        // 8 sources

                        ** while (jsonReader.peek() == JsonToken.NAME)
                    }
lbl116:
                    // 1 sources

                    jsonReader.endObject();
                    if (objectId == null) {
                        throw new IOException("Object ID is not specified in DPI response");
                    }
                    object = this.context.getObject(objectId);
                    if (object != null) {
                        return (T)object;
                    }
                    if (!(this.type instanceof Class)) break block44;
                    theClass = (Class)this.type;
                    break block45;
                }
                if (!(this.type instanceof WildcardType)) ** GOTO lbl132
                upperBounds = ((WildcardType)this.type).getUpperBounds();
                if (upperBounds.length == 1 && upperBounds[0] instanceof Class) {
                    theClass = (Class)upperBounds[0];
                } else {
                    throw new IOException("Unrecognized upper bounds '" + Arrays.toString(upperBounds) + "', deserialization not supported (" + String.valueOf(this.type) + ")");
lbl132:
                    // 1 sources

                    throw new IOException("Non class result, deserialization not supported (" + String.valueOf(this.type) + ")");
                }
            }
            if (theClass.isInterface()) {
                allInterfaces.add(theClass);
            }
            Collections.addAll(allInterfaces, theClass.getInterfaces());
            allInterfaces.add(DPIClientObject.class);
            objectHandler = new DPIClientProxy(this.context, allInterfaces.toArray(new Class[0]), objectId, objectType, objectToString, objectHashCode, objectContainers, objectProperties);
            object = objectHandler.getObjectInstance();
            this.context.addObject(objectId, object);
            return (T)object;
        }

        private ClassLoader getClassLoader() {
            return this.context.getClassLoader();
        }

        static /* synthetic */ int[] $SWITCH_TABLE$com$google$gson$stream$JsonToken() {
            if ($SWITCH_TABLE$com$google$gson$stream$JsonToken != null) {
                return $SWITCH_TABLE$com$google$gson$stream$JsonToken;
            }
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_DOCUMENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NAME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NULL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.NUMBER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[JsonToken.STRING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$com$google$gson$stream$JsonToken = nArray;
            return nArray;
        }
    }

    static class DPIProgressMonitorAdapter
    extends AbstractTypeAdapter<DBRProgressMonitor> {
        public DPIProgressMonitorAdapter(DPIContext context) {
            super(context);
        }

        public void write(JsonWriter jsonWriter, DBRProgressMonitor aClass) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.endObject();
        }

        public DBRProgressMonitor read(JsonReader jsonReader) throws IOException {
            jsonReader.beginObject();
            jsonReader.endObject();
            return this.context.getProgressMonitor();
        }
    }

    static class DPIThrowableAdapter
    extends AbstractTypeAdapter<Throwable> {
        public DPIThrowableAdapter(DPIContext context) {
            super(context);
        }

        public void write(JsonWriter jsonWriter, Throwable error) throws IOException {
            if (error == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.name("class");
                jsonWriter.value(error.getClass().getName());
                if (error.getMessage() != null) {
                    jsonWriter.name("message");
                    jsonWriter.value(error.getMessage());
                }
                jsonWriter.name("stacktrace");
                jsonWriter.value(Arrays.toString(error.getStackTrace()));
                if (error instanceof SQLException) {
                    SQLException sqlError = (SQLException)error;
                    jsonWriter.name("errorCode");
                    jsonWriter.value((long)sqlError.getErrorCode());
                    if (sqlError.getSQLState() != null) {
                        jsonWriter.name("sqlState");
                        jsonWriter.value(sqlError.getSQLState());
                    }
                }
            }
        }

        public Throwable read(JsonReader jsonReader) throws IOException {
            String className = null;
            while (jsonReader.peek() == JsonToken.NAME) {
                String attrName;
                switch (attrName = jsonReader.nextName()) {
                    case "class": {
                        className = jsonReader.nextString();
                        break;
                    }
                    case "message": {
                        jsonReader.nextString();
                        break;
                    }
                    case "stacktrace": {
                        jsonReader.nextString();
                        break;
                    }
                    case "errorCode": {
                        jsonReader.nextInt();
                        break;
                    }
                    case "sqlState": {
                        jsonReader.nextString();
                    }
                }
            }
            try {
                Class.forName(className, true, this.context.getClassLoader());
                return new Exception();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    static final class DPITypeAdapterFactory
    implements TypeAdapterFactory {
        private final DPIContext context;
        private final Map<Class<?>, AdapterCreator> classAdapters;

        public DPITypeAdapterFactory(DPIContext context, Map<Class<?>, AdapterCreator> classAdapters) {
            this.context = context;
            this.classAdapters = classAdapters;
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            DPIObject annotation;
            Type[] upperBounds;
            if (typeToken.getType() == Class.class) {
                return new DPIClassAdapter(this.context);
            }
            if (typeToken.getType() instanceof Class) {
                Class theClass = (Class)typeToken.getType();
                for (Map.Entry<Class<?>, AdapterCreator> entry : this.classAdapters.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(theClass)) continue;
                    return entry.getValue().createAdapter(this.context, gson);
                }
                if (DPISerializer.getClassAnnotation(theClass, DPILocalObject.class) != null) {
                    return new DPILocalObjectAdapter(this.context);
                }
                DPIObject annotation2 = DPISerializer.getDPIAnno(theClass);
                if (annotation2 != null) {
                    return new DPIObjectTypeAdapter(this.context, typeToken.getType());
                }
            } else if (typeToken.getType() instanceof WildcardType && (upperBounds = ((WildcardType)typeToken.getType()).getUpperBounds()).length > 0 && upperBounds[0] instanceof Class && (annotation = DPISerializer.getDPIAnno((Class)upperBounds[0])) != null) {
                return new DPIObjectTypeAdapter(this.context, typeToken.getType());
            }
            return null;
        }
    }
}

