/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.tools.toad;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.config.migration.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportData;
import org.jkiss.dbeaver.ext.config.migration.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionRole;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIActivator;
import org.jkiss.dbeaver.ext.oracle.ui.tools.toad.ConfigImportWizardToad;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigImportWizardPageToadConnections
extends ConfigImportWizardPage {
    private final ImportDriverInfo oraDriver;

    protected ConfigImportWizardPageToadConnections() {
        super("Toad");
        this.setTitle("Toad");
        this.setDescription("Import Oracle Toad connections");
        this.setImageDescriptor(OracleUIActivator.getImageDescriptor("icons/toad_icon_big.png"));
        this.oraDriver = new ImportDriverInfo(null, "Oracle", "jdbc:oracle:thin:@{host}[:{port}]/{database}", "oracle.jdbc.OracleDriver");
    }

    protected void loadConnections(ImportData importData) {
        importData.addDriver(this.oraDriver);
        ConfigImportWizardToad wizard = (ConfigImportWizardToad)this.getWizard();
        File inputFile = wizard.getInputFile();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream is = new FileInputStream(inputFile);){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (InputStreamReader reader = new InputStreamReader(is);){
                    this.parseConnections(importData, reader);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    private void parseConnections(@NotNull ImportData importData, @NotNull Reader reader) throws DBException {
        try {
            Document configDocument = XMLUtils.parseDocument((Reader)reader);
            for (Element refElement : XMLUtils.getChildElementList((Element)configDocument.getDocumentElement(), (String)"ConnectionHierarchy")) {
                for (Element dbElement : XMLUtils.getChildElementList((Element)refElement, (String)"DbPlatform")) {
                    if (!"Oracle".equals(dbElement.getAttribute("name"))) continue;
                    for (Element consElement : XMLUtils.getChildElementList((Element)dbElement, (String)"Connections")) {
                        for (Element conElement : XMLUtils.getChildElementList((Element)consElement, (String)"Connection")) {
                            if (!"Oracle".equals(conElement.getAttribute("type"))) continue;
                            LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
                            boolean isServiceType = false;
                            for (Element attrElement : XMLUtils.getChildElementList((Element)conElement)) {
                                String elementBody = XMLUtils.getElementBody((Element)attrElement);
                                if (CommonUtils.isEmpty((String)elementBody)) continue;
                                attrMap.put(attrElement.getTagName(), elementBody.trim());
                                if (!"ConnectionType".equals(attrElement.getTagName())) continue;
                                isServiceType = "True".equals(attrElement.getAttribute("ServiceName"));
                            }
                            String host = (String)attrMap.get("Host");
                            String port = (String)attrMap.get("Port");
                            String sid = (String)attrMap.get("Sid");
                            String user = (String)attrMap.get("User");
                            String alias = (String)attrMap.get("Alias");
                            String role = (String)attrMap.get("ConnectionMode");
                            String guid = (String)attrMap.get("GUID");
                            String sshHost = (String)attrMap.get("SSHHost");
                            DBWHandlerConfiguration sshHandler = null;
                            if (!CommonUtils.isEmpty((String)sshHost)) {
                                if (CommonUtils.isEmpty((String)host)) {
                                    host = sshHost;
                                }
                                String sshPort = (String)attrMap.get("SSHPort");
                                String sshUser = (String)attrMap.get("SSHUser");
                                String sshPassword = (String)attrMap.get("SSHPassword");
                                String sshPrivateKey = (String)attrMap.get("SSHPrivateKey");
                                String cfr_ignored_0 = (String)attrMap.get("SSHLocalPort");
                                String cfr_ignored_1 = (String)attrMap.get("SSHRemotePort");
                                String cfr_ignored_2 = (String)attrMap.get("SSHRemoteHost");
                                NetworkHandlerDescriptor sslHD = NetworkHandlerRegistry.getInstance().getDescriptor("ssh_tunnel");
                                sshHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)sslHD, null);
                                sshHandler.setUserName(sshUser);
                                sshHandler.setSavePassword(true);
                                sshHandler.setProperty("host", (Object)sshHost);
                                sshHandler.setProperty("port", (Object)sshPort);
                                if (!CommonUtils.isEmpty((String)sshPrivateKey)) {
                                    sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PUBLIC_KEY);
                                    sshHandler.setProperty("keyPath", (Object)sshPrivateKey);
                                } else {
                                    sshHandler.setProperty("authType", (Object)SSHConstants.AuthType.PASSWORD);
                                    sshHandler.setPassword(sshPassword);
                                }
                                sshHandler.setProperty("implementation", (Object)"sshj");
                                sshHandler.setEnabled(true);
                            }
                            if (CommonUtils.isEmpty((String)alias)) {
                                alias = sid;
                            }
                            if (CommonUtils.isEmpty((String)alias)) {
                                alias = host;
                            }
                            if (CommonUtils.isEmpty((String)alias)) {
                                alias = sshHost;
                            }
                            if (CommonUtils.isEmpty((String)alias)) {
                                alias = guid;
                            }
                            ImportConnectionInfo connectionInfo = new ImportConnectionInfo(this.oraDriver, null, alias, null, host, port, sid, user, null);
                            if (sshHandler != null) {
                                connectionInfo.addNetworkHandler(sshHandler);
                            }
                            connectionInfo.setProviderProperty("@dbeaver-sid-service@", isServiceType ? OracleConnectionType.SERVICE.name() : OracleConnectionType.SID.name());
                            if (!CommonUtils.isEmpty((String)role)) {
                                if ("Default".equals(role)) {
                                    role = OracleConnectionRole.NORMAL.name();
                                }
                                connectionInfo.setProviderProperty("@dbeaver-internal-logon@", ((OracleConnectionRole)CommonUtils.valueOf(OracleConnectionRole.class, (String)role, (Enum)OracleConnectionRole.NORMAL)).getTitle());
                            }
                            importData.addConnection(connectionInfo);
                        }
                    }
                }
            }
        }
        catch (XMLException e) {
            throw new DBException("Configuration parse error: " + e.getMessage(), (Throwable)e);
        }
    }
}

