/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.dialogs.EditObjectFilterDialog;

public class NavigatorHandlerFilterConfig
extends NavigatorHandlerObjectCreateBase
implements IElementUpdater {
    private static final Log log = Log.getLog(NavigatorHandlerFilterConfig.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        if (node instanceof DBNDatabaseNode) {
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            NavigatorHandlerFilterConfig.configureFilters(HandlerUtil.getActiveShell((ExecutionEvent)event), dbNode);
        }
        return null;
    }

    public static void configureFilters(Shell shell, DBNDatabaseNode dbNode) {
        block13: {
            try {
                DBNDatabaseNode parent;
                DBNNode dBNNode;
                DBNDatabaseNode parentNode = !(dbNode instanceof DBNDatabaseFolder) && (dBNNode = dbNode.getParentNode()) instanceof DBNDatabaseNode ? (parent = (DBNDatabaseNode)dBNNode) : dbNode;
                DBXTreeItem itemsMeta = (DBXTreeItem)UIUtils.runWithMonitor(monitor -> DBNUtils.getValidItemsMeta((DBRProgressMonitor)monitor, (DBNDatabaseNode)parentNode));
                if (itemsMeta == null) break block13;
                DBSObjectFilter objectFilter = parentNode.getNodeFilter(itemsMeta, true);
                if (objectFilter == null) {
                    objectFilter = new DBSObjectFilter();
                }
                DBPDataSourceRegistry dsRegistry = dbNode.getOwnerProject().getDataSourceRegistry();
                boolean globalFilter = dbNode.getValueObject() instanceof DBPDataSource;
                String parentName = "?";
                Object object = dbNode.getValueObject();
                if (object instanceof DBSObject) {
                    DBSObject dbsObject = (DBSObject)object;
                    parentName = dbsObject.getName();
                }
                EditObjectFilterDialog dialog = new EditObjectFilterDialog(shell, dsRegistry, globalFilter ? "All " + dbNode.getNodeTypeLabel() : dbNode.getNodeTypeLabel() + " of " + parentName, objectFilter, globalFilter);
                switch (dialog.open()) {
                    case 0: {
                        parentNode.setNodeFilter(itemsMeta, dialog.getFilter(), true);
                        NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(parentNode));
                        break;
                    }
                    case 1000: {
                        Class childrenClass = null;
                        if (dbNode instanceof DBNDatabaseFolder) {
                            DBNDatabaseFolder folder = (DBNDatabaseFolder)dbNode;
                            childrenClass = folder.getChildrenClass();
                        } else {
                            Object e;
                            List childMeta = dbNode.getMeta().getChildren((DBNNode)dbNode);
                            if (!childMeta.isEmpty() && (e = childMeta.get(0)) instanceof DBXTreeItem) {
                                DBXTreeItem item = (DBXTreeItem)e;
                                childrenClass = dbNode.getChildrenClass(item);
                            }
                        }
                        if (childrenClass == null) {
                            DBWorkbench.getPlatformUI().showMessageBox("Bad node", "Cannot use node '" + dbNode.getNodeUri() + "' for filters", true);
                            return;
                        }
                        DBPDataSourceContainer dataSourceContainer = dbNode.getDataSourceContainer();
                        objectFilter = dataSourceContainer.getObjectFilter(childrenClass, null, true);
                        dialog = new EditObjectFilterDialog(shell, dsRegistry, "All " + dbNode.getNodeTypeLabel(), objectFilter != null ? objectFilter : new DBSObjectFilter(), true);
                        if (dialog.open() != 0) break;
                        dataSourceContainer.setObjectFilter(childrenClass, null, dialog.getFilter());
                        dataSourceContainer.persistConfiguration();
                        NavigatorHandlerRefresh.refreshNavigator(Collections.singletonList(parentNode));
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        DBNNode node = NavigatorUtils.getSelectedNode(element);
        if (node instanceof DBNDatabaseItem) {
            node = node.getParentNode();
        }
        if (node != null) {
            element.setText(NLS.bind((String)UINavigatorMessages.actions_navigator_filter_objects, (Object)node.getNodeTypeLabel()));
        }
    }
}

