/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.hints.DBDValueHintProvider;
import org.jkiss.dbeaver.model.data.hints.standard.VoidHintProvider;
import org.jkiss.dbeaver.registry.data.hints.AbstractValueBindingRegistry;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderConfiguration;
import org.jkiss.dbeaver.registry.data.hints.ValueHintProviderDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class ValueHintRegistry
extends AbstractValueBindingRegistry<DBDValueHintProvider, ValueHintProviderDescriptor> {
    private static final Log log = Log.getLog(ValueHintRegistry.class);
    public static final String CONFIG_FILE_NAME = "data-hints.json";
    private static final Gson gson = new GsonBuilder().create();
    private static ValueHintRegistry instance = null;
    private final List<ValueHintProviderDescriptor> descriptors = new ArrayList<ValueHintProviderDescriptor>();
    private Map<String, ValueHintProviderConfiguration> configurationMap = new LinkedHashMap<String, ValueHintProviderConfiguration>();

    public static synchronized ValueHintRegistry getInstance() {
        if (instance == null) {
            instance = new ValueHintRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ValueHintRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataHintProvider");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("hintProvider".equals(ext.getName())) {
                this.descriptors.add(new ValueHintProviderDescriptor(ext));
            }
            ++n2;
        }
        this.loadConfiguration();
    }

    public List<ValueHintProviderDescriptor> getHintDescriptors() {
        return this.getDescriptors();
    }

    public List<ValueHintProviderDescriptor> getHintDescriptors(@NotNull DBDValueHintProvider.HintObject forObject) {
        return this.getDescriptors().stream().filter(d -> d.getForObject() == forObject).toList();
    }

    @Override
    @NotNull
    protected List<ValueHintProviderDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    @NotNull
    protected DBDValueHintProvider getDefaultValueBinding() {
        return VoidHintProvider.INSTANCE;
    }

    @NotNull
    public ValueHintProviderConfiguration getConfiguration(ValueHintProviderDescriptor descriptor) {
        ValueHintProviderConfiguration configuration = this.configurationMap.get(descriptor.getId());
        if (configuration == null) {
            configuration = new ValueHintProviderConfiguration(descriptor.getId());
            configuration.setEnabled(descriptor.isVisibleByDefault());
            return configuration;
        }
        return configuration;
    }

    public void setConfiguration(@NotNull ValueHintProviderDescriptor descriptor, @Nullable ValueHintProviderConfiguration configuration) {
        if (configuration == null) {
            this.configurationMap.remove(descriptor.getId());
        } else {
            this.configurationMap.put(descriptor.getId(), configuration);
        }
    }

    public void saveConfiguration() {
        try {
            String json = gson.toJson(this.configurationMap);
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(CONFIG_FILE_NAME, json);
        }
        catch (DBException e) {
            log.error("Error saving hint providers configuration", e);
        }
    }

    private void loadConfiguration() {
        try {
            String configContent = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(CONFIG_FILE_NAME);
            if (configContent != null) {
                this.configurationMap = (Map)gson.fromJson(configContent, new TypeToken<Map<String, ValueHintProviderConfiguration>>(){}.getType());
                if (this.configurationMap == null) {
                    this.configurationMap = new LinkedHashMap<String, ValueHintProviderConfiguration>();
                }
            }
        }
        catch (Exception e) {
            log.error("Error loading hint providers configuration", e);
        }
    }

    public boolean isHintEnabled(ValueHintProviderDescriptor descriptor) {
        ValueHintProviderConfiguration configuration = this.configurationMap.get(descriptor.getId());
        return configuration == null || configuration.isEnabled();
    }
}

