/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.data.hints;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.data.hints.AbstractValueBindingDescriptor;

public abstract class AbstractValueBindingRegistry<TYPE, DESC extends AbstractValueBindingDescriptor<TYPE>> {
    @NotNull
    protected abstract List<DESC> getDescriptors();

    @NotNull
    protected abstract TYPE getDefaultValueBinding();

    @NotNull
    public TYPE getValueBinding(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject type, @Nullable Class<?> valueType) {
        TYPE valueBinding = this.findValueBinding(dataSource, type, valueType, true, true);
        if (valueBinding == null) {
            valueBinding = this.findValueBinding(dataSource, type, valueType, false, true);
        }
        if (valueBinding == null) {
            valueBinding = this.findValueBinding(dataSource, type, valueType, true, false);
        }
        if (valueBinding == null) {
            valueBinding = this.findValueBinding(dataSource, type, valueType, false, false);
        }
        if (valueBinding == null) {
            valueBinding = this.getDefaultValueBinding();
        }
        return valueBinding;
    }

    private TYPE findValueBinding(@Nullable DBPDataSource dataSource, DBSTypedObject typedObject, Class<?> valueType, boolean checkDataSource, boolean checkType) {
        for (AbstractValueBindingDescriptor desc : this.getDescriptors()) {
            if (!desc.supportsType(dataSource, typedObject, valueType, checkDataSource, checkType)) continue;
            return desc.getInstance();
        }
        return null;
    }

    @NotNull
    public List<TYPE> getAllValueBindings(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject type, @Nullable Class<?> valueType) {
        ArrayList result = new ArrayList();
        for (AbstractValueBindingDescriptor desc : this.getDescriptors()) {
            if (!desc.supportsAnyType(dataSource, type, valueType)) continue;
            result.add(desc.getInstance());
        }
        return result;
    }
}

