/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.CustomExpression;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLSemanticProcessor {
    private static final Log log = Log.getLog(SQLSemanticProcessor.class);
    private static final boolean ALLOW_COMPLEX_PARSING = false;

    public static Statement parseQuery(@Nullable SQLDialect dialect, @NotNull String sql) throws DBCException {
        String sqlWithoutComments = dialect == null ? sql : SQLUtils.stripComments(dialect, sql);
        CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(sqlWithoutComments));
        try {
            parser.withAllowComplexParsing(false);
            if (dialect != null) {
                for (String[] qs : ArrayUtils.safeArray((Object[])dialect.getIdentifierQuoteStrings())) {
                    if (qs.length != 2 || !"[".equals(qs[0]) || !"]".equals(qs[1])) continue;
                    parser.withSquareBracketQuotation(true);
                    break;
                }
            }
            return parser.Statement();
        }
        catch (Exception e) {
            throw new DBCException("Error parsing SQL query: " + e.getMessage(), e);
        }
    }

    public static Statement parseQuery(@NotNull String sql) throws DBCException {
        return SQLSemanticProcessor.parseQuery(null, sql);
    }

    public static Expression parseExpression(String expression) throws DBCException {
        return SQLSemanticProcessor.parseExpression(expression, true);
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse) throws DBCException {
        try {
            return CCJSqlParserUtil.parseExpression((String)expression, (boolean)allowPartialParse);
        }
        catch (JSQLParserException e) {
            throw new DBCException("Error parsing conditional SQL expression", e);
        }
    }

    public static Expression parseCondExpression(String expression) throws DBCException {
        return SQLSemanticProcessor.parseCondExpression(expression, true);
    }

    public static Expression parseCondExpression(String expression, boolean allowPartialParse) throws DBCException {
        try {
            return CCJSqlParserUtil.parseCondExpression((String)expression, (boolean)allowPartialParse);
        }
        catch (JSQLParserException e) {
            throw new DBCException("Error parsing SQL expression", e);
        }
    }

    public static boolean isSelectQuery(SQLDialect dialect, String query) {
        try {
            PlainSelect plainSelect;
            Select select;
            SelectBody selectBody;
            Statement statement = SQLSemanticProcessor.parseQuery(dialect, query);
            return statement instanceof Select && (selectBody = (select = (Select)statement).getSelectBody()) instanceof PlainSelect && CommonUtils.isEmpty((Collection)(plainSelect = (PlainSelect)selectBody).getIntoTables());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Deprecated
    public static String addFiltersToQuery(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        return dataSource.getSQLDialect().getQueryGenerator().getQueryWithAppliedFilters(monitor, dataSource, sqlQuery, dataFilter);
    }

    public static boolean isForceFilterSubQuery(DBPDataSource dataSource) {
        return dataSource.getSQLDialect().supportsSubqueries() && dataSource.getContainer().getPreferenceStore().getBoolean("sql.query.filter.force.subselect");
    }

    @NotNull
    public static String injectFiltersToQuery(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        try {
            PlainSelect plainSelect;
            Select select;
            SelectBody selectBody;
            Statement statement = SQLSemanticProcessor.parseQuery(dataSource.getSQLDialect(), sqlQuery);
            if (statement instanceof Select && (selectBody = (select = (Select)statement).getSelectBody()) instanceof PlainSelect && SQLSemanticProcessor.patchSelectQuery(monitor, dataSource, plainSelect = (PlainSelect)selectBody, dataFilter)) {
                return statement.toString();
            }
        }
        catch (Throwable e) {
            throw new DBException("Error parsing SQL query", e);
        }
        throw new DBException("Can't inject filters to a query that is not a plain SELECT statement");
    }

    public static String wrapQuery(@NotNull DBPDataSource dataSource, @NotNull String sqlQuery, @NotNull DBDDataFilter dataFilter) throws DBException {
        return dataSource.getSQLDialect().getQueryGenerator().getWrappedFilterQuery(dataSource, sqlQuery, dataFilter);
    }

    private static boolean patchSelectQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, PlainSelect select, DBDDataFilter filter) throws DBException {
        if (filter.hasConditions()) {
            for (DBDAttributeConstraint co : filter.getConstraints()) {
                if (!co.hasCondition() || SQLSemanticProcessor.isDynamicAttribute(co.getAttribute())) continue;
                Table table = SQLSemanticProcessor.getConstraintTable(dataSource, select, co);
                if (!SQLSemanticProcessor.isValidTableColumn(monitor, dataSource, table, co)) {
                    return false;
                }
                if (table != null) {
                    if (table.getAlias() != null) {
                        co.setEntityAlias(table.getAlias().getName());
                        continue;
                    }
                    co.setEntityAlias(table.getName());
                    continue;
                }
                return false;
            }
            StringBuilder whereString = new StringBuilder();
            SQLUtils.appendConditionString(filter, dataSource, null, whereString, true);
            String condString = whereString.toString();
            SQLSemanticProcessor.addWhereToSelect(select, condString);
        }
        if (filter.hasOrdering()) {
            String filterOrder;
            List<DBDAttributeConstraint> orderConstraints;
            ArrayList<OrderByElement> orderByElements = select.getOrderByElements();
            if (orderByElements == null) {
                orderByElements = new ArrayList<OrderByElement>();
                select.setOrderByElements(orderByElements);
            }
            if (!CommonUtils.isEmpty(orderConstraints = filter.getOrderConstraints())) {
                for (DBDAttributeConstraint co : orderConstraints) {
                    String columnName = co.getAttributeName();
                    boolean forceNumeric = filter.hasNameDuplicates(columnName) || !SQLUtils.PATTERN_SIMPLE_NAME.matcher(columnName).matches();
                    Expression orderExpr = SQLSemanticProcessor.getOrderConstraintExpression(monitor, dataSource, select, filter, co, forceNumeric);
                    OrderByElement element = new OrderByElement();
                    element.setExpression(orderExpr);
                    if (co.isOrderDescending()) {
                        element.setAsc(false);
                        element.setAscDescPresent(true);
                    }
                    orderByElements.add(element);
                }
            }
            if (!CommonUtils.isEmpty((String)(filterOrder = filter.getOrder()))) {
                CustomExpression expression = new CustomExpression(filterOrder);
                OrderByElement element = new OrderByElement();
                element.setExpression((Expression)expression);
                orderByElements.add(element);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isDynamicAttribute(@Nullable DBSAttributeBase attribute) {
        void attributeBinding;
        if (!(attribute instanceof DBDAttributeBinding)) {
            return DBUtils.isDynamicAttribute(attribute);
        }
        DBDAttributeBinding dBDAttributeBinding = (DBDAttributeBinding)attribute;
        return DBUtils.isDynamicAttribute(attributeBinding.getAttribute());
    }

    private static boolean isValidTableColumn(DBRProgressMonitor monitor, DBPDataSource dataSource, Table table, DBDAttributeConstraint co) throws DBException {
        DBSAttributeBase attribute = co.getAttribute();
        if (SQLSemanticProcessor.isDynamicAttribute(attribute)) {
            return true;
        }
        if (attribute instanceof DBDAttributeBinding) {
            DBDAttributeBinding attributeBinding = (DBDAttributeBinding)attribute;
            attribute = attributeBinding.getMetaAttribute();
        }
        if (table != null && attribute instanceof DBCAttributeMetaData) {
            DBSEntity entity;
            DBCAttributeMetaData attributeMetaData = (DBCAttributeMetaData)attribute;
            DBSEntityAttribute entityAttribute = null;
            DBCEntityMetaData entityMetaData = attributeMetaData.getEntityMetaData();
            if (entityMetaData != null && (entity = DBUtils.getEntityFromMetaData(monitor, DBUtils.getDefaultContext(dataSource, true), entityMetaData)) != null) {
                entityAttribute = entity.getAttribute(monitor, co.getAttributeName());
            }
            return entityAttribute != null;
        }
        return true;
    }

    private static Expression getOrderConstraintExpression(DBRProgressMonitor monitor, DBPDataSource dataSource, PlainSelect select, DBDDataFilter filter, DBDAttributeConstraint co, boolean forceNumeric) throws DBException {
        Expression orderExpr;
        String attrName = DBUtils.getQuotedIdentifier(dataSource, co.getAttributeName());
        if (forceNumeric || attrName.isEmpty()) {
            int orderColumnIndex = SQLUtils.getConstraintOrderIndex(filter, co);
            if (orderColumnIndex == -1) {
                throw new DBException("Can't generate column order: no position found");
            }
            orderExpr = new LongValue((long)orderColumnIndex);
        } else if (CommonUtils.isJavaIdentifier((CharSequence)attrName)) {
            Table orderTable;
            Table table = orderTable = CommonUtils.isEmpty((Collection)select.getJoins()) ? null : SQLSemanticProcessor.getConstraintTable(dataSource, select, co);
            if (!SQLSemanticProcessor.isValidTableColumn(monitor, dataSource, orderTable, co)) {
                orderTable = null;
            }
            orderExpr = new Column(orderTable, attrName);
        } else {
            orderExpr = SQLSemanticProcessor.parseExpression(attrName);
        }
        return orderExpr;
    }

    @Nullable
    public static Table getConstraintTable(DBPDataSource dataSource, PlainSelect select, DBDAttributeConstraint constraint) {
        String constrTable;
        DBSAttributeBase ca = constraint.getAttribute();
        if (ca instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding = (DBDAttributeBinding)ca;
            DBCAttributeMetaData metaAttribute = binding.getMetaAttribute();
            constrTable = metaAttribute == null ? null : metaAttribute.getEntityName();
        } else if (ca instanceof DBSEntityAttribute) {
            DBSEntityAttribute entityAttribute = (DBSEntityAttribute)ca;
            constrTable = entityAttribute.getParentObject().getName();
        } else {
            return null;
        }
        if (constrTable == null) {
            return null;
        }
        FromItem fromItem = select.getFromItem();
        Table table = SQLSemanticProcessor.findTableInFrom(dataSource, fromItem, constrTable);
        if (table == null && !CommonUtils.isEmpty((Collection)select.getJoins())) {
            for (Join join : select.getJoins()) {
                table = SQLSemanticProcessor.findTableInFrom(dataSource, join.getRightItem(), constrTable);
                if (table != null) break;
            }
        }
        return table;
    }

    @Nullable
    public static Table getTableFromSelect(Select select) {
        PlainSelect plainSelect;
        FromItem fromItem;
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect && (fromItem = (plainSelect = (PlainSelect)selectBody).getFromItem()) instanceof Table) {
            Table table = (Table)fromItem;
            return table;
        }
        return null;
    }

    @Nullable
    private static Table findTableInFrom(DBPDataSource dataSource, FromItem fromItem, String tableName) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            if (DBUtils.getUnQuotedIdentifier(dataSource, tableName).equals(DBUtils.getUnQuotedIdentifier(dataSource, table.getName()))) {
                return table;
            }
        }
        return null;
    }

    @Nullable
    public static Table findTableByNameOrAlias(Select select, String tableName) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            Table table;
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem instanceof Table && SQLSemanticProcessor.equalTables(table = (Table)fromItem, tableName)) {
                return table;
            }
            for (Join join : CommonUtils.safeCollection((Collection)plainSelect.getJoins())) {
                Table table2;
                FromItem fromItem2 = join.getRightItem();
                if (!(fromItem2 instanceof Table) || !SQLSemanticProcessor.equalTables(table2 = (Table)fromItem2, tableName)) continue;
                return table2;
            }
        }
        return null;
    }

    public static boolean equalTables(Table t1, String name) {
        if (t1 == null || name == null) {
            return true;
        }
        if (t1.getAlias() != null) {
            return CommonUtils.equalObjects((Object)t1.getAlias().getName(), (Object)name);
        }
        return CommonUtils.equalObjects((Object)t1.getName(), (Object)name);
    }

    public static void addWhereToSelect(PlainSelect select, String condString) throws DBCException {
        Expression filterWhere = SQLSemanticProcessor.parseCondExpression(condString);
        SQLSemanticProcessor.addWhereToSelect(select, filterWhere);
    }

    public static void addWhereToSelect(PlainSelect select, Expression conditionExpr) {
        Expression sourceWhere = select.getWhere();
        if (sourceWhere == null) {
            select.setWhere(conditionExpr);
        } else {
            select.setWhere((Expression)new AndExpression((Expression)new Parenthesis(sourceWhere), conditionExpr));
        }
    }
}

