/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.io.pem.PemReader;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.impl.app.CertificateGenHelper;
import org.jkiss.dbeaver.model.impl.app.PKCS1Util;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.Base64;

public class DefaultCertificateStorage
implements DBACertificateStorage {
    private static final Log log = Log.getLog(DefaultCertificateStorage.class);
    private static final char[] DEFAULT_PASSWORD = "".toCharArray();
    public static final String JKS_EXTENSION = ".jks";
    public static final String CA_CERT_ALIAS = "ca-cert";
    public static final String CLIENT_CERT_ALIAS = "client-cert";
    public static final String KEY_CERT_ALIAS = "key-cert";
    private final Path localPath;
    private final Map<String, UserDefinedKeystore> userDefinedKeystores;

    public DefaultCertificateStorage(Path localPath) {
        File[] ksFiles;
        this.localPath = localPath;
        this.userDefinedKeystores = new HashMap<String, UserDefinedKeystore>();
        if (Files.exists(localPath, new LinkOption[0]) && DBWorkbench.getPlatform().getApplication().isPrimaryInstance() && (ksFiles = localPath.toFile().listFiles()) != null) {
            File[] fileArray = ksFiles;
            int n = ksFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File ksFile = fileArray[n2];
                if (!ksFile.delete()) {
                    log.warn("Can't delete old keystore '" + ksFile.getAbsolutePath() + "'");
                }
                ++n2;
            }
        }
    }

    @Override
    public KeyStore getKeyStore(DBPDataSourceContainer container, String certType) throws DBException {
        try {
            KeyStore ks;
            block12: {
                Path ksFile = this.getKeyStorePath(container, certType);
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                if (Files.exists(ksFile, new LinkOption[0])) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = Files.newInputStream(ksFile, new OpenOption[0]);){
                        ks.load(is, this.getKeyStorePassword(container, certType));
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ks.load(null, DEFAULT_PASSWORD);
                this.saveKeyStore(container, certType, ks);
            }
            return ks;
        }
        catch (Exception e) {
            throw new DBException("Error opening keystore", e);
        }
    }

    @Override
    @NotNull
    public Path getStorageFolder() {
        return this.localPath;
    }

    private void saveKeyStore(DBPDataSourceContainer container, String certType, KeyStore keyStore) throws Exception {
        this.checkConfigFolderExists();
        Path ksFile = this.getKeyStorePath(container, certType);
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream os = Files.newOutputStream(ksFile, new OpenOption[0]);){
            keyStore.store(os, DEFAULT_PASSWORD);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkConfigFolderExists() {
        if (!Files.exists(this.localPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.localPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Can't create directory for security manager: " + String.valueOf(this.localPath), e);
            }
        }
    }

    public static byte[] readEncryptedString(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            return DefaultCertificateStorage.readEncryptedString(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readEncryptedString(Reader reader) throws IOException {
        StringBuilder result = new StringBuilder(4000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    break;
                }
                if (line.startsWith("-") || line.startsWith("#")) continue;
                result.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Base64.decode((String)result.toString());
    }

    @Override
    public void addCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, byte[] caCertData, byte[] clientCertData, byte[] keyData) throws DBException {
        if (this.userDefinedKeystores.containsKey(this.getKeyStoreName(dataSource, certType))) {
            throw new DBException("Adding new certificates would override user-specified keystore");
        }
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            int i;
            ArrayList<? extends Certificate> certificates;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> certChain = new ArrayList<Certificate>();
            if (caCertData != null) {
                certificates = new ArrayList<Certificate>(cf.generateCertificates(new ByteArrayInputStream(caCertData)));
                i = 0;
                while (i < certificates.size()) {
                    keyStore.setCertificateEntry((String)(i == 0 ? CA_CERT_ALIAS : CA_CERT_ALIAS + i), (Certificate)certificates.get(i));
                    ++i;
                }
            }
            if (clientCertData != null) {
                certificates = new ArrayList<Certificate>(cf.generateCertificates(new ByteArrayInputStream(clientCertData)));
                i = 0;
                while (i < certificates.size()) {
                    keyStore.setCertificateEntry((String)(i == 0 ? CLIENT_CERT_ALIAS : CLIENT_CERT_ALIAS + i), (Certificate)certificates.get(i));
                    certChain.add((Certificate)certificates.get(i));
                    ++i;
                }
            }
            if (keyData != null) {
                PrivateKey privateKey = DefaultCertificateStorage.loadPrivateKeyFromPEM(keyData);
                keyStore.setKeyEntry(KEY_CERT_ALIAS, privateKey, DEFAULT_PASSWORD, certChain.toArray(new Certificate[certChain.size()]));
            }
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Throwable e) {
            throw new DBException("Error adding certificate to keystore", e);
        }
    }

    @Override
    public void addCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, @NotNull String keyStorePath, @NotNull char[] keyStorePassword) throws DBException {
        this.userDefinedKeystores.put(this.getKeyStoreName(dataSource, certType), new UserDefinedKeystore(new File(keyStorePath), keyStorePassword));
    }

    @Override
    public void addCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, @NotNull byte[] keyStoreData, @NotNull char[] keyStorePassword) throws DBException {
        this.checkConfigFolderExists();
        Path keyStorePath = this.getKeyStorePath(dataSource, certType);
        if (!Files.exists(keyStorePath, new LinkOption[0])) {
            try {
                Files.write(keyStorePath, keyStoreData, new OpenOption[0]);
            }
            catch (Throwable e) {
                throw new DBException("Error adding certificate to keystore", e);
            }
        }
        this.userDefinedKeystores.put(this.getKeyStoreName(dataSource, certType), new UserDefinedKeystore(keyStorePath.toFile(), keyStorePassword));
    }

    @Override
    public void addSelfSignedCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType, @NotNull String certDN) throws DBException {
        if (this.userDefinedKeystores.containsKey(this.getKeyStoreName(dataSource, certType))) {
            throw new DBException("Adding new certificates would override user-specified keystore");
        }
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            ArrayList<Certificate> certChain = new ArrayList<Certificate>();
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            Certificate clientCert = CertificateGenHelper.generateCertificate(certDN, keyPair, 365, "SHA256withRSA");
            keyStore.setCertificateEntry(CLIENT_CERT_ALIAS, clientCert);
            certChain.add(clientCert);
            PrivateKey privateKey = keyPair.getPrivate();
            keyStore.setKeyEntry(KEY_CERT_ALIAS, privateKey, DEFAULT_PASSWORD, certChain.toArray(new Certificate[certChain.size()]));
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Throwable e) {
            throw new DBException("Error adding self-signed certificate to keystore", e);
        }
    }

    @Override
    public void deleteCertificate(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType) throws DBException {
        if (this.userDefinedKeystores.remove(this.getKeyStoreName(dataSource, certType)) != null) {
            return;
        }
        KeyStore keyStore = this.getKeyStore(dataSource, certType);
        try {
            keyStore.deleteEntry(CA_CERT_ALIAS);
            keyStore.deleteEntry(CLIENT_CERT_ALIAS);
            keyStore.deleteEntry(KEY_CERT_ALIAS);
            this.saveKeyStore(dataSource, certType, keyStore);
        }
        catch (Exception e) {
            throw new DBException("Error deleting certificate from keystore", e);
        }
    }

    @Override
    public Path getKeyStorePath(DBPDataSourceContainer dataSource, String certType) {
        UserDefinedKeystore userDefinedKeystore = this.getUserDefinedKeystore(dataSource, certType);
        if (userDefinedKeystore != null) {
            return userDefinedKeystore.file.toPath();
        }
        return this.localPath.resolve(this.getKeyStoreName(dataSource, certType) + JKS_EXTENSION);
    }

    @Override
    @NotNull
    public char[] getKeyStorePassword(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType) {
        UserDefinedKeystore userDefinedKeystore = this.getUserDefinedKeystore(dataSource, certType);
        if (userDefinedKeystore != null) {
            return userDefinedKeystore.password;
        }
        return DEFAULT_PASSWORD;
    }

    @Override
    public String getKeyStoreType(DBPDataSourceContainer dataSource) {
        return KeyStore.getDefaultType();
    }

    @NotNull
    public static byte[] loadDerFromPem(@NotNull Reader reader) throws IOException {
        return new PemReader(reader).readPemObject().getContent();
    }

    public static PrivateKey loadPrivateKeyFromPEM(byte[] keyData) throws GeneralSecurityException, IOException {
        String privateKeyPem = new String(keyData);
        if (privateKeyPem.contains("-----BEGIN PRIVATE KEY-----")) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            byte[] pkcs8EncodedKey = Base64.decode((String)privateKeyPem);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(new PKCS8EncodedKeySpec(pkcs8EncodedKey));
        }
        if (privateKeyPem.contains("-----BEGIN RSA PRIVATE KEY-----")) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            return PKCS1Util.loadPrivateKeyFromPKCS1(privateKeyPem);
        }
        throw new GeneralSecurityException("Not supported format of a private key");
    }

    @Nullable
    private UserDefinedKeystore getUserDefinedKeystore(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType) {
        return this.userDefinedKeystores.get(this.getKeyStoreName(dataSource, certType));
    }

    @NotNull
    private String getKeyStoreName(@NotNull DBPDataSourceContainer dataSource, @NotNull String certType) {
        return dataSource.getId() + "-" + certType;
    }

    private static class UserDefinedKeystore {
        private final File file;
        private final char[] password;

        public UserDefinedKeystore(@NotNull File file, @NotNull char[] password) {
            this.file = file;
            this.password = password;
        }
    }
}

