/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data.hints.standard;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDResultSetModel;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.hints.DBDAttributeHintProvider;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.data.hints.ValueHintText;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.utils.CommonUtils;

public class AttributeKeysHintProvider
implements DBDAttributeHintProvider {
    @Override
    @Nullable
    public DBDValueHint[] getAttributeHints(@NotNull DBDResultSetModel model, @NotNull DBDAttributeBinding attribute, @NotNull EnumSet<DBDValueHint.HintType> types, int options) {
        ArrayList<ValueHintText> hints = new ArrayList<ValueHintText>();
        DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
        if (rowIdentifier != null && !rowIdentifier.isIncomplete() && rowIdentifier != model.getDefaultRowIdentifier()) {
            hints.add(new ValueHintText("Unique key: " + rowIdentifier.getEntity().getName() + "(" + rowIdentifier.getAttributes().stream().map(DBDAttributeBinding::getName).collect(Collectors.joining(",")) + ")", "Unique key which will be used to edit this column's value", null));
        }
        if (rowIdentifier != null && rowIdentifier.hasAttribute(attribute)) {
            hints.add(new ValueHintText("Part of key: " + DBUtils.getObjectFullName(rowIdentifier.getUniqueKey(), DBPEvaluationContext.UI), null, DBIcon.OVER_KEY));
        }
        if (!CommonUtils.isEmpty(attribute.getReferrers())) {
            hints.add(new ValueHintText("Refers to: " + this.getRefTableNames(attribute.getReferrers()), null, DBIcon.OVER_REFERENCE));
        }
        return hints.toArray(new DBDValueHint[0]);
    }

    private String getRefTableNames(List<DBSEntityReferrer> referrers) {
        return referrers.stream().map(r -> {
            DBSEntityAssociation assoc;
            DBSEntity entity;
            if (r instanceof DBSEntityAssociation && (entity = (assoc = (DBSEntityAssociation)((Object)r)).getAssociatedEntity()) != null) {
                return DBUtils.getObjectFullName(entity, DBPEvaluationContext.UI);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(","));
    }
}

