/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.app;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBPSecretHolder;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;

public interface DBPDataSourceRegistry
extends DBPObject,
DBPSecretHolder {
    public static final String MODERN_CONFIG_FILE_PREFIX = "data-sources";
    public static final String MODERN_CONFIG_FILE_EXT = ".json";
    public static final String MODERN_CONFIG_FILE_NAME = "data-sources.json";
    public static final String CREDENTIALS_CONFIG_FILE_PREFIX = "credentials-config";
    public static final String CREDENTIALS_CONFIG_FILE_EXT = ".json";
    public static final String CREDENTIALS_CONFIG_FILE_NAME = "credentials-config.json";
    public static final String LEGACY_CONFIG_FILE_PREFIX = ".dbeaver-data-sources";
    public static final String LEGACY_CONFIG_FILE_EXT = ".xml";
    public static final String LEGACY_CONFIG_FILE_NAME = ".dbeaver-data-sources.xml";
    public static final String LEGACY2_CONFIG_FILE_NAME = "data-sources.xml";

    @NotNull
    public DBPProject getProject();

    @Nullable
    public DBPDataSourceContainer getDataSource(@NotNull String var1);

    @Nullable
    public DBPDataSourceContainer getDataSource(@NotNull DBPDataSource var1);

    @Nullable
    public DBPDataSourceContainer findDataSourceByName(String var1);

    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSourcesByProfile(@NotNull DBWNetworkProfile var1);

    @NotNull
    public List<? extends DBPDataSourceContainer> getDataSources();

    @NotNull
    public <T extends DBPDataSourceContainer> T createDataSource(@NotNull DBPDriver var1, @NotNull DBPConnectionConfiguration var2);

    public <T extends DBPDataSourceContainer> T createDataSource(@NotNull String var1, @NotNull DBPDriver var2, @NotNull DBPConnectionConfiguration var3);

    public <T extends DBPDataSourceContainer> T createDataSource(@NotNull DBPDataSourceConfigurationStorage var1, @NotNull DBPDataSourceOrigin var2, @NotNull String var3, @NotNull DBPDriver var4, @NotNull DBPConnectionConfiguration var5);

    @NotNull
    public <T extends DBPDataSourceContainer> T createDataSource(@NotNull DBPDataSourceContainer var1);

    public void addDataSourceListener(@NotNull DBPEventListener var1);

    public boolean removeDataSourceListener(@NotNull DBPEventListener var1);

    public void addDataSource(@NotNull DBPDataSourceContainer var1) throws DBException;

    public void removeDataSource(@NotNull DBPDataSourceContainer var1);

    public void updateDataSource(@NotNull DBPDataSourceContainer var1) throws DBException;

    @NotNull
    public List<? extends DBPDataSourceFolder> getAllFolders();

    @NotNull
    public List<? extends DBPDataSourceFolder> getRootFolders();

    @Nullable
    public DBPDataSourceFolder getFolder(@NotNull String var1);

    @NotNull
    public DBPDataSourceFolder addFolder(@Nullable DBPDataSourceFolder var1, @NotNull String var2);

    public void removeFolder(@NotNull DBPDataSourceFolder var1, boolean var2);

    public void moveFolder(@NotNull String var1, @NotNull String var2);

    @Nullable
    public DBSObjectFilter getSavedFilter(String var1);

    @NotNull
    public List<DBSObjectFilter> getSavedFilters();

    public void updateSavedFilter(@NotNull DBSObjectFilter var1);

    public void removeSavedFilter(@NotNull String var1);

    @Nullable
    public DBWNetworkProfile getNetworkProfile(@Nullable String var1, @NotNull String var2);

    @NotNull
    public List<DBWNetworkProfile> getNetworkProfiles();

    public void updateNetworkProfile(@NotNull DBWNetworkProfile var1);

    public void removeNetworkProfile(@NotNull DBWNetworkProfile var1);

    @Nullable
    public DBAAuthProfile getAuthProfile(@NotNull String var1);

    @NotNull
    public List<DBAAuthProfile> getAllAuthProfiles();

    @NotNull
    public List<DBAAuthProfile> getApplicableAuthProfiles(@Nullable DBPDriver var1);

    public void updateAuthProfile(@NotNull DBAAuthProfile var1);

    public void removeAuthProfile(@NotNull DBAAuthProfile var1);

    public void setAuthProfiles(@NotNull Collection<DBAAuthProfile> var1);

    public void flushConfig();

    public void refreshConfig();

    public void refreshConfig(@Nullable Collection<String> var1);

    @Nullable
    public Throwable getLastError();

    public boolean hasError();

    public void checkForErrors() throws DBException;

    public void notifyDataSourceListeners(@NotNull DBPEvent var1);

    @Nullable
    public DBACredentialsProvider getAuthCredentialsProvider();

    public void setAuthCredentialsProvider(@Nullable DBACredentialsProvider var1);

    @NotNull
    public Set<DBPDataSourceFolder> getTemporaryFolders();

    @NotNull
    public DBPPreferenceStore getPreferenceStore();

    public void dispose();
}

