/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridPrivilage;
import org.jkiss.dbeaver.ext.cubrid.ui.config.CubridPrivilageHandler;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.ControlPropertyCommandListener;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.utils.CommonUtils;

public class CubridPrivilageEditor
extends AbstractDatabaseObjectEditor<CubridPrivilage> {
    UserPageControl pageControl;
    private CubridPrivilage user;
    private Table table;
    private List<String> groups = new ArrayList<String>();

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return IRefreshablePart.RefreshResult.REFRESHED;
    }

    public void createPartControl(Composite parent) {
        this.pageControl = new UserPageControl(parent, this);
        Composite container = UIUtils.createPlaceholder((Composite)this.pageControl, (int)2, (int)10);
        this.user = (CubridPrivilage)this.getDatabaseObject();
        GridData gds = new GridData(1808);
        container.setLayoutData((Object)gds);
        GridData gd = new GridData(768);
        gd.heightHint = 30;
        Text t = UIUtils.createLabelText((Composite)container, (String)"Name ", (String)this.user.getName(), (int)2048, (Object)new GridData(768));
        GridData gd1 = new GridData();
        gd1.widthHint = 400;
        t.setLayoutData((Object)gd1);
        t.setEditable(!((CubridPrivilage)this.getDatabaseObject()).isPersisted());
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)t, (DBEPropertyHandler)CubridPrivilageHandler.NAME);
        String loginedUser = this.user.getDataSource().getContainer().getConnectionConfiguration().getUserName().toUpperCase();
        boolean allowEditPassword = new ArrayList<String>(Arrays.asList("DBA", this.user.getName())).contains(loginedUser);
        Text t2 = UIUtils.createLabelText((Composite)container, (String)"Password ", (String)"", (int)0x400800);
        GridData gd12 = new GridData();
        gd12.widthHint = 400;
        t2.setLayoutData((Object)gd12);
        t2.setEditable(allowEditPassword);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)t2, (DBEPropertyHandler)CubridPrivilageHandler.PASSWORD);
        UIUtils.createControlLabel((Composite)container, (String)"Groups", (int)1);
        this.table = new Table(container, 2080);
        gd = new GridData();
        gd.heightHint = 150;
        gd.widthHint = 390;
        this.table.setLayoutData((Object)gd);
        this.loadGroups();
        new TableCommandListener(this, this.table, CubridPrivilageHandler.GROUPS, this.groups);
        if (((CubridPrivilage)this.getDatabaseObject()).isPersisted()) {
            this.table.setEnabled(false);
        }
        Text t3 = UIUtils.createLabelText((Composite)container, (String)"Description", (String)this.user.getDescription(), (int)2626);
        GridData gd13 = new GridData(1, 0x1000000, true, false);
        gd13.heightHint = 3 * t3.getLineHeight();
        gd13.widthHint = 400;
        t3.setLayoutData((Object)gd13);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)t3, (DBEPropertyHandler)CubridPrivilageHandler.DESCRIPTION);
        this.pageControl.createProgressPanel();
    }

    public void setFocus() {
        if (this.pageControl != null) {
            this.pageControl.setFocus();
        }
    }

    private void loadGroups() {
        new AbstractJob("Load groups"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    List cubridUsers = CubridPrivilageEditor.this.user.getDataSource().getCubridPrivilages(monitor);
                    UIUtils.syncExec(() -> {
                        CubridPrivilageEditor.this.table.removeAll();
                        CubridPrivilageEditor.this.groups.clear();
                        for (CubridPrivilage privilage : cubridUsers) {
                            if (privilage.getName().equals(CubridPrivilageEditor.this.user.getName())) continue;
                            TableItem item = new TableItem(CubridPrivilageEditor.this.table, 16777302);
                            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_USER_GROUP));
                            item.setText(0, privilage.getName());
                            if (!CubridPrivilageEditor.this.user.getRoles().contains(privilage.getName())) continue;
                            CubridPrivilageEditor.this.groups.add(privilage.getName());
                            item.setChecked(true);
                        }
                    });
                }
                catch (DBException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private class TableCommandListener {
        private final CubridPrivilageEditor editor;
        private final Table widget;
        private final CubridPrivilageHandler handler;
        private List<String> values;
        private DBECommandProperty<CubridPrivilage> command;
        private List<String> oldValue;

        public TableCommandListener(CubridPrivilageEditor editor, Table widget, CubridPrivilageHandler handler, List<String> oldValue) {
            this.editor = editor;
            this.widget = widget;
            this.handler = handler;
            this.oldValue = oldValue;
            this.addEventListener();
        }

        private void addEventListener() {
            this.widget.addListener(13, event -> {
                TableItem item = (TableItem)event.item;
                if (this.values == null) {
                    this.values = new ArrayList<String>(this.oldValue);
                }
                if (item != null) {
                    if (item.getChecked()) {
                        this.values.add(item.getText());
                    } else {
                        this.values.removeIf(value -> value == item.getText());
                    }
                }
                DBECommandReflector<CubridPrivilage, DBECommandProperty<CubridPrivilage>> commandReflector = new DBECommandReflector<CubridPrivilage, DBECommandProperty<CubridPrivilage>>(){

                    public void redoCommand(DBECommandProperty<CubridPrivilage> command) {
                        if (!((TableCommandListener)TableCommandListener.this).CubridPrivilageEditor.this.table.isDisposed()) {
                            TableCommandListener.this.editor.loadGroups();
                            TableCommandListener.this.values = new ArrayList<String>(TableCommandListener.this.oldValue);
                        }
                    }

                    public void undoCommand(DBECommandProperty<CubridPrivilage> cp) {
                        if (!((TableCommandListener)TableCommandListener.this).CubridPrivilageEditor.this.table.isDisposed()) {
                            TableCommandListener.this.editor.loadGroups();
                            TableCommandListener.this.values = new ArrayList<String>(TableCommandListener.this.oldValue);
                        }
                    }
                };
                if (this.command == null) {
                    if (!CommonUtils.equalObjects(this.values, this.oldValue)) {
                        this.command = new DBECommandProperty((DBPObject)((CubridPrivilage)this.editor.getDatabaseObject()), (DBEPropertyHandler)this.handler, this.oldValue, this.values);
                        this.editor.addChangeCommand((DBECommand)this.command, (DBECommandReflector)commandReflector);
                    }
                } else if (CommonUtils.equalObjects(this.values, this.oldValue)) {
                    this.editor.removeChangeCommand((DBECommand)this.command);
                    this.command = null;
                } else {
                    this.command.setNewValue(this.values);
                    this.editor.updateChangeCommand((DBECommand)this.command, (DBECommandReflector)commandReflector);
                }
            });
        }
    }

    protected class UserPageControl
    extends ObjectEditorPageControl {
        public UserPageControl(Composite parent, CubridPrivilageEditor object) {
            super(parent, 0, (IDatabaseEditor)object);
        }

        public void fillCustomActions(IContributionManager contributionManager) {
            super.fillCustomActions(contributionManager);
            contributionManager.add((IContributionItem)new Separator());
            IWorkbenchPartSite workbenchSite = CubridPrivilageEditor.this.getSite();
            if (workbenchSite != null) {
                DatabaseEditorUtils.contributeStandardEditorActions((IWorkbenchSite)workbenchSite, (IContributionManager)contributionManager);
            }
        }
    }
}

