/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.slhdsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.slhdsa.BCSLHDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseDeterministicOrRandomSignature;
import org.bouncycastle.pqc.crypto.slhdsa.HashSLHDSASigner;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;

public class HashSignatureSpi
extends BaseDeterministicOrRandomSignature {
    private final HashSLHDSASigner signer;

    protected HashSignatureSpi(HashSLHDSASigner signer) {
        super("HASH-SLH-DSA");
        this.signer = signer;
    }

    @Override
    protected void verifyInit(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCSLHDSAPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to SLH-DSA");
        }
        BCSLHDSAPublicKey key = (BCSLHDSAPublicKey)publicKey;
        this.keyParams = key.getKeyParams();
    }

    @Override
    protected void signInit(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.appRandom = random;
        if (!(privateKey instanceof BCSLHDSAPrivateKey)) {
            throw new InvalidKeyException("unknown private key passed to SLH-DSA");
        }
        BCSLHDSAPrivateKey key = (BCSLHDSAPrivateKey)privateKey;
        this.keyParams = key.getKeyParams();
    }

    @Override
    protected void updateEngine(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void updateEngine(byte[] buf, int off, int len) throws SignatureException {
        this.signer.update(buf, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        AsymmetricKeyParameter param = this.keyParams;
        if (!(param instanceof SLHDSAPrivateKeyParameters)) {
            throw new SignatureException("engine initialized for verification");
        }
        try {
            byte[] sig;
            byte[] byArray = sig = this.signer.generateSignature();
            return byArray;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
        finally {
            this.isInitState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        AsymmetricKeyParameter param = this.keyParams;
        if (!(param instanceof SLHDSAPublicKeyParameters)) {
            throw new SignatureException("engine initialized for signing");
        }
        try {
            boolean bl = this.signer.verifySignature(sigBytes);
            return bl;
        }
        finally {
            this.isInitState = true;
        }
    }

    @Override
    protected void reInitialize(boolean forSigning, CipherParameters params) {
        this.signer.init(forSigning, params);
    }

    public static class Direct
    extends HashSignatureSpi {
        public Direct() {
            super(new HashSLHDSASigner());
        }
    }
}

