/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class HMacDSAKCalculator
implements DSAKCalculator {
    private final HMac hMac;
    private final byte[] K;
    private final byte[] V;
    private BigInteger n;

    public HMacDSAKCalculator(Digest digest) {
        this.hMac = new HMac(digest);
        int macSize = this.hMac.getMacSize();
        this.V = new byte[macSize];
        this.K = new byte[macSize];
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public void init(BigInteger n, SecureRandom random) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void init(BigInteger n, BigInteger d, byte[] message) {
        this.n = n;
        BigInteger mInt = this.bitsToInt(message);
        if (mInt.compareTo(n) >= 0) {
            mInt = mInt.subtract(n);
        }
        int size = BigIntegers.getUnsignedByteLength(n);
        byte[] x = BigIntegers.asUnsignedByteArray(size, d);
        byte[] m = BigIntegers.asUnsignedByteArray(size, mInt);
        Arrays.fill(this.K, (byte)0);
        Arrays.fill(this.V, (byte)1);
        this.hMac.init(new KeyParameter(this.K));
        this.hMac.update(this.V, 0, this.V.length);
        this.hMac.update((byte)0);
        this.hMac.update(x, 0, x.length);
        this.hMac.update(m, 0, m.length);
        this.initAdditionalInput0(this.hMac);
        this.hMac.doFinal(this.K, 0);
        this.hMac.init(new KeyParameter(this.K));
        this.hMac.update(this.V, 0, this.V.length);
        this.hMac.doFinal(this.V, 0);
        this.hMac.update(this.V, 0, this.V.length);
        this.hMac.update((byte)1);
        this.hMac.update(x, 0, x.length);
        this.hMac.update(m, 0, m.length);
        this.initAdditionalInput1(this.hMac);
        this.hMac.doFinal(this.K, 0);
        this.hMac.init(new KeyParameter(this.K));
        this.hMac.update(this.V, 0, this.V.length);
        this.hMac.doFinal(this.V, 0);
    }

    @Override
    public BigInteger nextK() {
        byte[] t = new byte[BigIntegers.getUnsignedByteLength(this.n)];
        while (true) {
            int len;
            for (int tOff = 0; tOff < t.length; tOff += len) {
                this.hMac.update(this.V, 0, this.V.length);
                this.hMac.doFinal(this.V, 0);
                len = Math.min(t.length - tOff, this.V.length);
                System.arraycopy(this.V, 0, t, tOff, len);
            }
            BigInteger k = this.bitsToInt(t);
            if (k.signum() > 0 && k.compareTo(this.n) < 0) {
                return k;
            }
            this.hMac.update(this.V, 0, this.V.length);
            this.hMac.update((byte)0);
            this.hMac.doFinal(this.K, 0);
            this.hMac.init(new KeyParameter(this.K));
            this.hMac.update(this.V, 0, this.V.length);
            this.hMac.doFinal(this.V, 0);
        }
    }

    protected void initAdditionalInput0(HMac hmac0) {
    }

    protected void initAdditionalInput1(HMac hmac1) {
    }

    private BigInteger bitsToInt(byte[] t) {
        int blen = t.length * 8;
        int qlen = this.n.bitLength();
        BigInteger v = BigIntegers.fromUnsignedByteArray(t);
        if (blen > qlen) {
            v = v.shiftRight(blen - qlen);
        }
        return v;
    }
}

