/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class NullableListCodec<T>
implements ObjectCodec<List<T>> {
    private static final Class<? extends List<?>> RANDOM_ACCESS_TYPE = Collections.unmodifiableList(new ArrayList()).getClass();
    private static final Class<? extends List<?>> SEQUENTIAL_ACCESS_TYPE = Collections.unmodifiableList(new LinkedList()).getClass();

    NullableListCodec() {
    }

    @Override
    public Class<List<T>> getEncodedClass() {
        return this.cast(AbstractList.class);
    }

    @Override
    public List<Class<? extends List<T>>> additionalEncodedClasses() {
        return ImmutableList.of(this.cast(RANDOM_ACCESS_TYPE), this.cast(SEQUENTIAL_ACCESS_TYPE));
    }

    @Override
    public void serialize(SerializationContext context, List<T> list, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(list.size());
        for (T item : list) {
            context.serialize(item, codedOut);
        }
    }

    @Override
    public List<T> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int length = codedIn.readInt32();
        if (length < 0) {
            throw new SerializationException("Expected non-negative length: " + length);
        }
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(context.deserialize(codedIn));
        }
        return this.maybeTransform(list);
    }

    protected List<T> maybeTransform(ArrayList<T> startingList) {
        return Collections.unmodifiableList(startingList);
    }

    private Class<List<T>> cast(Class<? extends List> clazz) {
        return clazz;
    }
}

