﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/kinesis-video-archived-media/KinesisVideoArchivedMedia_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace KinesisVideoArchivedMedia
{
namespace Model
{

  /**
   * <p>Represents a segment of video or other time-delimited data.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/kinesis-video-archived-media-2017-09-30/Fragment">AWS
   * API Reference</a></p>
   */
  class Fragment
  {
  public:
    AWS_KINESISVIDEOARCHIVEDMEDIA_API Fragment();
    AWS_KINESISVIDEOARCHIVEDMEDIA_API Fragment(Aws::Utils::Json::JsonView jsonValue);
    AWS_KINESISVIDEOARCHIVEDMEDIA_API Fragment& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_KINESISVIDEOARCHIVEDMEDIA_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The unique identifier of the fragment. This value monotonically increases
     * based on the ingestion order.</p>
     */
    inline const Aws::String& GetFragmentNumber() const{ return m_fragmentNumber; }
    inline bool FragmentNumberHasBeenSet() const { return m_fragmentNumberHasBeenSet; }
    inline void SetFragmentNumber(const Aws::String& value) { m_fragmentNumberHasBeenSet = true; m_fragmentNumber = value; }
    inline void SetFragmentNumber(Aws::String&& value) { m_fragmentNumberHasBeenSet = true; m_fragmentNumber = std::move(value); }
    inline void SetFragmentNumber(const char* value) { m_fragmentNumberHasBeenSet = true; m_fragmentNumber.assign(value); }
    inline Fragment& WithFragmentNumber(const Aws::String& value) { SetFragmentNumber(value); return *this;}
    inline Fragment& WithFragmentNumber(Aws::String&& value) { SetFragmentNumber(std::move(value)); return *this;}
    inline Fragment& WithFragmentNumber(const char* value) { SetFragmentNumber(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The total fragment size, including information about the fragment and
     * contained media data.</p>
     */
    inline long long GetFragmentSizeInBytes() const{ return m_fragmentSizeInBytes; }
    inline bool FragmentSizeInBytesHasBeenSet() const { return m_fragmentSizeInBytesHasBeenSet; }
    inline void SetFragmentSizeInBytes(long long value) { m_fragmentSizeInBytesHasBeenSet = true; m_fragmentSizeInBytes = value; }
    inline Fragment& WithFragmentSizeInBytes(long long value) { SetFragmentSizeInBytes(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp from the producer corresponding to the fragment.</p>
     */
    inline const Aws::Utils::DateTime& GetProducerTimestamp() const{ return m_producerTimestamp; }
    inline bool ProducerTimestampHasBeenSet() const { return m_producerTimestampHasBeenSet; }
    inline void SetProducerTimestamp(const Aws::Utils::DateTime& value) { m_producerTimestampHasBeenSet = true; m_producerTimestamp = value; }
    inline void SetProducerTimestamp(Aws::Utils::DateTime&& value) { m_producerTimestampHasBeenSet = true; m_producerTimestamp = std::move(value); }
    inline Fragment& WithProducerTimestamp(const Aws::Utils::DateTime& value) { SetProducerTimestamp(value); return *this;}
    inline Fragment& WithProducerTimestamp(Aws::Utils::DateTime&& value) { SetProducerTimestamp(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp from the Amazon Web Services server corresponding to the
     * fragment.</p>
     */
    inline const Aws::Utils::DateTime& GetServerTimestamp() const{ return m_serverTimestamp; }
    inline bool ServerTimestampHasBeenSet() const { return m_serverTimestampHasBeenSet; }
    inline void SetServerTimestamp(const Aws::Utils::DateTime& value) { m_serverTimestampHasBeenSet = true; m_serverTimestamp = value; }
    inline void SetServerTimestamp(Aws::Utils::DateTime&& value) { m_serverTimestampHasBeenSet = true; m_serverTimestamp = std::move(value); }
    inline Fragment& WithServerTimestamp(const Aws::Utils::DateTime& value) { SetServerTimestamp(value); return *this;}
    inline Fragment& WithServerTimestamp(Aws::Utils::DateTime&& value) { SetServerTimestamp(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The playback duration or other time value associated with the fragment.</p>
     */
    inline long long GetFragmentLengthInMilliseconds() const{ return m_fragmentLengthInMilliseconds; }
    inline bool FragmentLengthInMillisecondsHasBeenSet() const { return m_fragmentLengthInMillisecondsHasBeenSet; }
    inline void SetFragmentLengthInMilliseconds(long long value) { m_fragmentLengthInMillisecondsHasBeenSet = true; m_fragmentLengthInMilliseconds = value; }
    inline Fragment& WithFragmentLengthInMilliseconds(long long value) { SetFragmentLengthInMilliseconds(value); return *this;}
    ///@}
  private:

    Aws::String m_fragmentNumber;
    bool m_fragmentNumberHasBeenSet = false;

    long long m_fragmentSizeInBytes;
    bool m_fragmentSizeInBytesHasBeenSet = false;

    Aws::Utils::DateTime m_producerTimestamp;
    bool m_producerTimestampHasBeenSet = false;

    Aws::Utils::DateTime m_serverTimestamp;
    bool m_serverTimestampHasBeenSet = false;

    long long m_fragmentLengthInMilliseconds;
    bool m_fragmentLengthInMillisecondsHasBeenSet = false;
  };

} // namespace Model
} // namespace KinesisVideoArchivedMedia
} // namespace Aws
